/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda.eventsources;

import java.util.List;
import java.util.Objects;
import software.amazon.awscdk.services.lambda.IEventSource;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.awscdk.services.lambda.eventsources.$Module;
import software.amazon.awscdk.services.lambda.eventsources.S3EventSourceProps;
import software.amazon.awscdk.services.s3.Bucket;
import software.amazon.awscdk.services.s3.EventType;
import software.amazon.awscdk.services.s3.NotificationKeyFilter;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-lambda-event-sources.S3EventSource")
public class S3EventSource
extends JsiiObject
implements IEventSource {
    protected S3EventSource(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3EventSource(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public S3EventSource(Bucket bucket, S3EventSourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(bucket, "bucket is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void bind(IFunction target) {
        this.jsiiCall("bind", Void.class, new Object[]{Objects.requireNonNull(target, "target is required")});
    }

    public Bucket getBucket() {
        return (Bucket)this.jsiiGet("bucket", Bucket.class);
    }

    public static final class Builder {
        private final Bucket bucket;
        private final S3EventSourceProps.Builder props;

        public static Builder create(Bucket bucket) {
            return new Builder(bucket);
        }

        private Builder(Bucket bucket) {
            this.bucket = bucket;
            this.props = new S3EventSourceProps.Builder();
        }

        public Builder events(List<EventType> events) {
            this.props.events(events);
            return this;
        }

        public Builder filters(List<NotificationKeyFilter> filters) {
            this.props.filters(filters);
            return this;
        }

        public S3EventSource build() {
            return new S3EventSource(this.bucket, this.props.build());
        }
    }
}

