package software.amazon.awscdk.services.lambda.eventsources;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-02-19T09:09:52.807Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.eventsources.$Module.class, fqn = "@aws-cdk/aws-lambda-event-sources.DynamoEventSourceProps")
@software.amazon.jsii.Jsii.Proxy(DynamoEventSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DynamoEventSourceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.lambda.eventsources.StreamEventSourceProps {

    /**
     * @return a {@link Builder} of {@link DynamoEventSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DynamoEventSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.lambda.StartingPosition startingPosition;
        private java.lang.Number batchSize;
        private software.amazon.awscdk.core.Duration maxBatchingWindow;

        /**
         * Sets the value of {@link DynamoEventSourceProps#getStartingPosition}
         * @param startingPosition Where to begin consuming the stream. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startingPosition(software.amazon.awscdk.services.lambda.StartingPosition startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        /**
         * Sets the value of {@link DynamoEventSourceProps#getBatchSize}
         * @param batchSize The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
         *                  Your function receives an
         *                  event with all the retrieved records.
         *                  <p>
         *                  Valid Range:
         *                  <p>
         *                  <ul>
         *                  <li>Minimum value of 1</li>
         *                  <li>Maximum value of:
         *                  <p>
         *                  <ul>
         *                  <li>1000 for {&#64;link DynamoEventSource}</li>
         *                  <li>10000 for {&#64;link KinesisEventSource}</li>
         *                  </ul></li>
         *                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchSize(java.lang.Number batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        /**
         * Sets the value of {@link DynamoEventSourceProps#getMaxBatchingWindow}
         * @param maxBatchingWindow The maximum amount of time to gather records before invoking the function.
         *                          Maximum of Duration.minutes(5)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchingWindow(software.amazon.awscdk.core.Duration maxBatchingWindow) {
            this.maxBatchingWindow = maxBatchingWindow;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DynamoEventSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public DynamoEventSourceProps build() {
            return new Jsii$Proxy(startingPosition, batchSize, maxBatchingWindow);
        }
    }

    /**
     * An implementation for {@link DynamoEventSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamoEventSourceProps {
        private final software.amazon.awscdk.services.lambda.StartingPosition startingPosition;
        private final java.lang.Number batchSize;
        private final software.amazon.awscdk.core.Duration maxBatchingWindow;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.startingPosition = this.jsiiGet("startingPosition", software.amazon.awscdk.services.lambda.StartingPosition.class);
            this.batchSize = this.jsiiGet("batchSize", java.lang.Number.class);
            this.maxBatchingWindow = this.jsiiGet("maxBatchingWindow", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.lambda.StartingPosition startingPosition, final java.lang.Number batchSize, final software.amazon.awscdk.core.Duration maxBatchingWindow) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.startingPosition = java.util.Objects.requireNonNull(startingPosition, "startingPosition is required");
            this.batchSize = batchSize;
            this.maxBatchingWindow = maxBatchingWindow;
        }

        @Override
        public software.amazon.awscdk.services.lambda.StartingPosition getStartingPosition() {
            return this.startingPosition;
        }

        @Override
        public java.lang.Number getBatchSize() {
            return this.batchSize;
        }

        @Override
        public software.amazon.awscdk.core.Duration getMaxBatchingWindow() {
            return this.maxBatchingWindow;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("startingPosition", om.valueToTree(this.getStartingPosition()));
            if (this.getBatchSize() != null) {
                data.set("batchSize", om.valueToTree(this.getBatchSize()));
            }
            if (this.getMaxBatchingWindow() != null) {
                data.set("maxBatchingWindow", om.valueToTree(this.getMaxBatchingWindow()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda-event-sources.DynamoEventSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DynamoEventSourceProps.Jsii$Proxy that = (DynamoEventSourceProps.Jsii$Proxy) o;

            if (!startingPosition.equals(that.startingPosition)) return false;
            if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
            return this.maxBatchingWindow != null ? this.maxBatchingWindow.equals(that.maxBatchingWindow) : that.maxBatchingWindow == null;
        }

        @Override
        public int hashCode() {
            int result = this.startingPosition.hashCode();
            result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
            result = 31 * result + (this.maxBatchingWindow != null ? this.maxBatchingWindow.hashCode() : 0);
            return result;
        }
    }
}
