package software.amazon.awscdk.services.lambda.eventsources;

/**
 * Use an Amazon Kinesis stream as an event source for AWS Lambda.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-02-19T09:09:52.808Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.eventsources.$Module.class, fqn = "@aws-cdk/aws-lambda-event-sources.KinesisEventSource")
public class KinesisEventSource extends software.amazon.awscdk.services.lambda.eventsources.StreamEventSource {

    protected KinesisEventSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KinesisEventSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param stream This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public KinesisEventSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.IStream stream, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.eventsources.KinesisEventSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(stream, "stream is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Called by `lambda.addEventSource` to allow the event source to bind to this function.
     * <p>
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction target) {
        this.jsiiCall("bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesis.IStream getStream() {
        return this.jsiiGet("stream", software.amazon.awscdk.services.kinesis.IStream.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.eventsources.KinesisEventSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param stream This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.kinesis.IStream stream) {
            return new Builder(stream);
        }

        private final software.amazon.awscdk.services.kinesis.IStream stream;
        private final software.amazon.awscdk.services.lambda.eventsources.KinesisEventSourceProps.Builder props;

        private Builder(final software.amazon.awscdk.services.kinesis.IStream stream) {
            this.stream = stream;
            this.props = new software.amazon.awscdk.services.lambda.eventsources.KinesisEventSourceProps.Builder();
        }

        /**
         * Where to begin consuming the stream.
         * <p>
         * @return {@code this}
         * @param startingPosition Where to begin consuming the stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startingPosition(final software.amazon.awscdk.services.lambda.StartingPosition startingPosition) {
            this.props.startingPosition(startingPosition);
            return this;
        }

        /**
         * The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
         * <p>
         * Your function receives an
         * event with all the retrieved records.
         * <p>
         * Valid Range:
         * <p>
         * <ul>
         * <li>Minimum value of 1</li>
         * <li>Maximum value of:
         * <p>
         * <ul>
         * <li>1000 for {&#64;link DynamoEventSource}</li>
         * <li>10000 for {&#64;link KinesisEventSource}</li>
         * </ul></li>
         * </ul>
         * <p>
         * Default: 100
         * <p>
         * @return {@code this}
         * @param batchSize The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchSize(final java.lang.Number batchSize) {
            this.props.batchSize(batchSize);
            return this;
        }

        /**
         * The maximum amount of time to gather records before invoking the function.
         * <p>
         * Maximum of Duration.minutes(5)
         * <p>
         * Default: Duration.seconds(0)
         * <p>
         * @return {@code this}
         * @param maxBatchingWindow The maximum amount of time to gather records before invoking the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchingWindow(final software.amazon.awscdk.core.Duration maxBatchingWindow) {
            this.props.maxBatchingWindow(maxBatchingWindow);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.eventsources.KinesisEventSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.lambda.eventsources.KinesisEventSource build() {
            return new software.amazon.awscdk.services.lambda.eventsources.KinesisEventSource(
                this.stream,
                this.props.build()
            );
        }
    }
}
