package software.amazon.awscdk.services.lambda.eventsources;

/**
 * Use an Amazon DynamoDB stream as an event source for AWS Lambda.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.5.0 (build 46538f8)", date = "2020-05-08T05:31:31.738Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.eventsources.$Module.class, fqn = "@aws-cdk/aws-lambda-event-sources.DynamoEventSource")
public class DynamoEventSource extends software.amazon.awscdk.services.lambda.eventsources.StreamEventSource {

    protected DynamoEventSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DynamoEventSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param table This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DynamoEventSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.ITable table, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.eventsources.DynamoEventSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(table, "table is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Called by `lambda.addEventSource` to allow the event source to bind to this function.
     * <p>
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction target) {
        this.jsiiCall("bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * The identifier for this EventSourceMapping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEventSourceMappingId() {
        return this.jsiiGet("eventSourceMappingId", java.lang.String.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.eventsources.DynamoEventSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param table This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.dynamodb.ITable table) {
            return new Builder(table);
        }

        private final software.amazon.awscdk.services.dynamodb.ITable table;
        private final software.amazon.awscdk.services.lambda.eventsources.DynamoEventSourceProps.Builder props;

        private Builder(final software.amazon.awscdk.services.dynamodb.ITable table) {
            this.table = table;
            this.props = new software.amazon.awscdk.services.lambda.eventsources.DynamoEventSourceProps.Builder();
        }

        /**
         * Where to begin consuming the stream.
         * <p>
         * @return {@code this}
         * @param startingPosition Where to begin consuming the stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startingPosition(final software.amazon.awscdk.services.lambda.StartingPosition startingPosition) {
            this.props.startingPosition(startingPosition);
            return this;
        }

        /**
         * The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
         * <p>
         * Your function receives an
         * event with all the retrieved records.
         * <p>
         * Valid Range:
         * <p>
         * <ul>
         * <li>Minimum value of 1</li>
         * <li>Maximum value of:
         * <p>
         * <ul>
         * <li>1000 for {&#64;link DynamoEventSource}</li>
         * <li>10000 for {&#64;link KinesisEventSource}</li>
         * </ul></li>
         * </ul>
         * <p>
         * Default: 100
         * <p>
         * @return {@code this}
         * @param batchSize The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchSize(final java.lang.Number batchSize) {
            this.props.batchSize(batchSize);
            return this;
        }

        /**
         * If the function returns an error, split the batch in two and retry.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param bisectBatchOnError If the function returns an error, split the batch in two and retry. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bisectBatchOnError(final java.lang.Boolean bisectBatchOnError) {
            this.props.bisectBatchOnError(bisectBatchOnError);
            return this;
        }

        /**
         * The maximum amount of time to gather records before invoking the function.
         * <p>
         * Maximum of Duration.minutes(5)
         * <p>
         * Default: Duration.seconds(0)
         * <p>
         * @return {@code this}
         * @param maxBatchingWindow The maximum amount of time to gather records before invoking the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchingWindow(final software.amazon.awscdk.core.Duration maxBatchingWindow) {
            this.props.maxBatchingWindow(maxBatchingWindow);
            return this;
        }

        /**
         * The maximum age of a record that Lambda sends to a function for processing.
         * <p>
         * Valid Range:
         * <p>
         * <ul>
         * <li>Minimum value of 60 seconds</li>
         * <li>Maximum value of 7 days</li>
         * </ul>
         * <p>
         * Default: Duration.days(7)
         * <p>
         * @return {@code this}
         * @param maxRecordAge The maximum age of a record that Lambda sends to a function for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRecordAge(final software.amazon.awscdk.core.Duration maxRecordAge) {
            this.props.maxRecordAge(maxRecordAge);
            return this;
        }

        /**
         * An Amazon SQS queue or Amazon SNS topic destination for discarded records.
         * <p>
         * Default: discarded records are ignored
         * <p>
         * @return {@code this}
         * @param onFailure An Amazon SQS queue or Amazon SNS topic destination for discarded records. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onFailure(final software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure) {
            this.props.onFailure(onFailure);
            return this;
        }

        /**
         * The number of batches to process from each shard concurrently.
         * <p>
         * Valid Range:
         * <p>
         * <ul>
         * <li>Minimum value of 1</li>
         * <li>Maximum value of 10</li>
         * </ul>
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param parallelizationFactor The number of batches to process from each shard concurrently. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parallelizationFactor(final java.lang.Number parallelizationFactor) {
            this.props.parallelizationFactor(parallelizationFactor);
            return this;
        }

        /**
         * Maximum number of retry attempts Valid Range: * Minimum value of 0 * Maximum value of 10000.
         * <p>
         * Default: 10000
         * <p>
         * @return {@code this}
         * @param retryAttempts Maximum number of retry attempts Valid Range: * Minimum value of 0 * Maximum value of 10000. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.eventsources.DynamoEventSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.lambda.eventsources.DynamoEventSource build() {
            return new software.amazon.awscdk.services.lambda.eventsources.DynamoEventSource(
                this.table,
                this.props.build()
            );
        }
    }
}
