package software.amazon.awscdk.services.lambda.eventsources;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.5.0 (build 46538f8)", date = "2020-05-08T05:31:31.741Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.eventsources.$Module.class, fqn = "@aws-cdk/aws-lambda-event-sources.KinesisEventSourceProps")
@software.amazon.jsii.Jsii.Proxy(KinesisEventSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface KinesisEventSourceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.lambda.eventsources.StreamEventSourceProps {

    /**
     * @return a {@link Builder} of {@link KinesisEventSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KinesisEventSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.lambda.StartingPosition startingPosition;
        private java.lang.Number batchSize;
        private java.lang.Boolean bisectBatchOnError;
        private software.amazon.awscdk.core.Duration maxBatchingWindow;
        private software.amazon.awscdk.core.Duration maxRecordAge;
        private software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure;
        private java.lang.Number parallelizationFactor;
        private java.lang.Number retryAttempts;

        /**
         * Sets the value of {@link KinesisEventSourceProps#getStartingPosition}
         * @param startingPosition Where to begin consuming the stream. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startingPosition(software.amazon.awscdk.services.lambda.StartingPosition startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        /**
         * Sets the value of {@link KinesisEventSourceProps#getBatchSize}
         * @param batchSize The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
         *                  Your function receives an
         *                  event with all the retrieved records.
         *                  <p>
         *                  Valid Range:
         *                  <p>
         *                  <ul>
         *                  <li>Minimum value of 1</li>
         *                  <li>Maximum value of:
         *                  <p>
         *                  <ul>
         *                  <li>1000 for {&#64;link DynamoEventSource}</li>
         *                  <li>10000 for {&#64;link KinesisEventSource}</li>
         *                  </ul></li>
         *                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchSize(java.lang.Number batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        /**
         * Sets the value of {@link KinesisEventSourceProps#getBisectBatchOnError}
         * @param bisectBatchOnError If the function returns an error, split the batch in two and retry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bisectBatchOnError(java.lang.Boolean bisectBatchOnError) {
            this.bisectBatchOnError = bisectBatchOnError;
            return this;
        }

        /**
         * Sets the value of {@link KinesisEventSourceProps#getMaxBatchingWindow}
         * @param maxBatchingWindow The maximum amount of time to gather records before invoking the function.
         *                          Maximum of Duration.minutes(5)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchingWindow(software.amazon.awscdk.core.Duration maxBatchingWindow) {
            this.maxBatchingWindow = maxBatchingWindow;
            return this;
        }

        /**
         * Sets the value of {@link KinesisEventSourceProps#getMaxRecordAge}
         * @param maxRecordAge The maximum age of a record that Lambda sends to a function for processing.
         *                     Valid Range:
         *                     <p>
         *                     <ul>
         *                     <li>Minimum value of 60 seconds</li>
         *                     <li>Maximum value of 7 days</li>
         *                     </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRecordAge(software.amazon.awscdk.core.Duration maxRecordAge) {
            this.maxRecordAge = maxRecordAge;
            return this;
        }

        /**
         * Sets the value of {@link KinesisEventSourceProps#getOnFailure}
         * @param onFailure An Amazon SQS queue or Amazon SNS topic destination for discarded records.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onFailure(software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        /**
         * Sets the value of {@link KinesisEventSourceProps#getParallelizationFactor}
         * @param parallelizationFactor The number of batches to process from each shard concurrently.
         *                              Valid Range:
         *                              <p>
         *                              <ul>
         *                              <li>Minimum value of 1</li>
         *                              <li>Maximum value of 10</li>
         *                              </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parallelizationFactor(java.lang.Number parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
            return this;
        }

        /**
         * Sets the value of {@link KinesisEventSourceProps#getRetryAttempts}
         * @param retryAttempts Maximum number of retry attempts Valid Range: * Minimum value of 0 * Maximum value of 10000.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KinesisEventSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public KinesisEventSourceProps build() {
            return new Jsii$Proxy(startingPosition, batchSize, bisectBatchOnError, maxBatchingWindow, maxRecordAge, onFailure, parallelizationFactor, retryAttempts);
        }
    }

    /**
     * An implementation for {@link KinesisEventSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisEventSourceProps {
        private final software.amazon.awscdk.services.lambda.StartingPosition startingPosition;
        private final java.lang.Number batchSize;
        private final java.lang.Boolean bisectBatchOnError;
        private final software.amazon.awscdk.core.Duration maxBatchingWindow;
        private final software.amazon.awscdk.core.Duration maxRecordAge;
        private final software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure;
        private final java.lang.Number parallelizationFactor;
        private final java.lang.Number retryAttempts;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.startingPosition = this.jsiiGet("startingPosition", software.amazon.awscdk.services.lambda.StartingPosition.class);
            this.batchSize = this.jsiiGet("batchSize", java.lang.Number.class);
            this.bisectBatchOnError = this.jsiiGet("bisectBatchOnError", java.lang.Boolean.class);
            this.maxBatchingWindow = this.jsiiGet("maxBatchingWindow", software.amazon.awscdk.core.Duration.class);
            this.maxRecordAge = this.jsiiGet("maxRecordAge", software.amazon.awscdk.core.Duration.class);
            this.onFailure = this.jsiiGet("onFailure", software.amazon.awscdk.services.lambda.IEventSourceDlq.class);
            this.parallelizationFactor = this.jsiiGet("parallelizationFactor", java.lang.Number.class);
            this.retryAttempts = this.jsiiGet("retryAttempts", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.lambda.StartingPosition startingPosition, final java.lang.Number batchSize, final java.lang.Boolean bisectBatchOnError, final software.amazon.awscdk.core.Duration maxBatchingWindow, final software.amazon.awscdk.core.Duration maxRecordAge, final software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure, final java.lang.Number parallelizationFactor, final java.lang.Number retryAttempts) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.startingPosition = java.util.Objects.requireNonNull(startingPosition, "startingPosition is required");
            this.batchSize = batchSize;
            this.bisectBatchOnError = bisectBatchOnError;
            this.maxBatchingWindow = maxBatchingWindow;
            this.maxRecordAge = maxRecordAge;
            this.onFailure = onFailure;
            this.parallelizationFactor = parallelizationFactor;
            this.retryAttempts = retryAttempts;
        }

        @Override
        public software.amazon.awscdk.services.lambda.StartingPosition getStartingPosition() {
            return this.startingPosition;
        }

        @Override
        public java.lang.Number getBatchSize() {
            return this.batchSize;
        }

        @Override
        public java.lang.Boolean getBisectBatchOnError() {
            return this.bisectBatchOnError;
        }

        @Override
        public software.amazon.awscdk.core.Duration getMaxBatchingWindow() {
            return this.maxBatchingWindow;
        }

        @Override
        public software.amazon.awscdk.core.Duration getMaxRecordAge() {
            return this.maxRecordAge;
        }

        @Override
        public software.amazon.awscdk.services.lambda.IEventSourceDlq getOnFailure() {
            return this.onFailure;
        }

        @Override
        public java.lang.Number getParallelizationFactor() {
            return this.parallelizationFactor;
        }

        @Override
        public java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("startingPosition", om.valueToTree(this.getStartingPosition()));
            if (this.getBatchSize() != null) {
                data.set("batchSize", om.valueToTree(this.getBatchSize()));
            }
            if (this.getBisectBatchOnError() != null) {
                data.set("bisectBatchOnError", om.valueToTree(this.getBisectBatchOnError()));
            }
            if (this.getMaxBatchingWindow() != null) {
                data.set("maxBatchingWindow", om.valueToTree(this.getMaxBatchingWindow()));
            }
            if (this.getMaxRecordAge() != null) {
                data.set("maxRecordAge", om.valueToTree(this.getMaxRecordAge()));
            }
            if (this.getOnFailure() != null) {
                data.set("onFailure", om.valueToTree(this.getOnFailure()));
            }
            if (this.getParallelizationFactor() != null) {
                data.set("parallelizationFactor", om.valueToTree(this.getParallelizationFactor()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda-event-sources.KinesisEventSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KinesisEventSourceProps.Jsii$Proxy that = (KinesisEventSourceProps.Jsii$Proxy) o;

            if (!startingPosition.equals(that.startingPosition)) return false;
            if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
            if (this.bisectBatchOnError != null ? !this.bisectBatchOnError.equals(that.bisectBatchOnError) : that.bisectBatchOnError != null) return false;
            if (this.maxBatchingWindow != null ? !this.maxBatchingWindow.equals(that.maxBatchingWindow) : that.maxBatchingWindow != null) return false;
            if (this.maxRecordAge != null ? !this.maxRecordAge.equals(that.maxRecordAge) : that.maxRecordAge != null) return false;
            if (this.onFailure != null ? !this.onFailure.equals(that.onFailure) : that.onFailure != null) return false;
            if (this.parallelizationFactor != null ? !this.parallelizationFactor.equals(that.parallelizationFactor) : that.parallelizationFactor != null) return false;
            return this.retryAttempts != null ? this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts == null;
        }

        @Override
        public int hashCode() {
            int result = this.startingPosition.hashCode();
            result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
            result = 31 * result + (this.bisectBatchOnError != null ? this.bisectBatchOnError.hashCode() : 0);
            result = 31 * result + (this.maxBatchingWindow != null ? this.maxBatchingWindow.hashCode() : 0);
            result = 31 * result + (this.maxRecordAge != null ? this.maxRecordAge.hashCode() : 0);
            result = 31 * result + (this.onFailure != null ? this.onFailure.hashCode() : 0);
            result = 31 * result + (this.parallelizationFactor != null ? this.parallelizationFactor.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            return result;
        }
    }
}
