package software.amazon.awscdk.services.lambda.eventsources;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.5.0 (build 46538f8)", date = "2020-05-08T05:31:31.742Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.eventsources.$Module.class, fqn = "@aws-cdk/aws-lambda-event-sources.S3EventSourceProps")
@software.amazon.jsii.Jsii.Proxy(S3EventSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface S3EventSourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The s3 event types that will trigger the notification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.s3.EventType> getEvents();

    /**
     * S3 object key filter rules to determine which objects trigger this event.
     * <p>
     * Each filter must include a <code>prefix</code> and/or <code>suffix</code> that will be matched
     * against the s3 object key. Refer to the S3 Developer Guide for details
     * about allowed filter rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.NotificationKeyFilter> getFilters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link S3EventSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link S3EventSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.util.List<software.amazon.awscdk.services.s3.EventType> events;
        private java.util.List<software.amazon.awscdk.services.s3.NotificationKeyFilter> filters;

        /**
         * Sets the value of {@link S3EventSourceProps#getEvents}
         * @param events The s3 event types that will trigger the notification. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(java.util.List<software.amazon.awscdk.services.s3.EventType> events) {
            this.events = events;
            return this;
        }

        /**
         * Sets the value of {@link S3EventSourceProps#getFilters}
         * @param filters S3 object key filter rules to determine which objects trigger this event.
         *                Each filter must include a <code>prefix</code> and/or <code>suffix</code> that will be matched
         *                against the s3 object key. Refer to the S3 Developer Guide for details
         *                about allowed filter rules.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filters(java.util.List<software.amazon.awscdk.services.s3.NotificationKeyFilter> filters) {
            this.filters = filters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3EventSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public S3EventSourceProps build() {
            return new Jsii$Proxy(events, filters);
        }
    }

    /**
     * An implementation for {@link S3EventSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3EventSourceProps {
        private final java.util.List<software.amazon.awscdk.services.s3.EventType> events;
        private final java.util.List<software.amazon.awscdk.services.s3.NotificationKeyFilter> filters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.events = this.jsiiGet("events", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.EventType.class)));
            this.filters = this.jsiiGet("filters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.NotificationKeyFilter.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.List<software.amazon.awscdk.services.s3.EventType> events, final java.util.List<software.amazon.awscdk.services.s3.NotificationKeyFilter> filters) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.events = java.util.Objects.requireNonNull(events, "events is required");
            this.filters = filters;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.s3.EventType> getEvents() {
            return this.events;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.s3.NotificationKeyFilter> getFilters() {
            return this.filters;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("events", om.valueToTree(this.getEvents()));
            if (this.getFilters() != null) {
                data.set("filters", om.valueToTree(this.getFilters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda-event-sources.S3EventSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            S3EventSourceProps.Jsii$Proxy that = (S3EventSourceProps.Jsii$Proxy) o;

            if (!events.equals(that.events)) return false;
            return this.filters != null ? this.filters.equals(that.filters) : that.filters == null;
        }

        @Override
        public int hashCode() {
            int result = this.events.hashCode();
            result = 31 * result + (this.filters != null ? this.filters.hashCode() : 0);
            return result;
        }
    }
}
