package software.amazon.awscdk.services.lambda.go.alpha;

/**
 * (experimental) Bundling options.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GoFunction.Builder.create(this, "handler")
 *         .entry("app/cmd/api")
 *         .bundling(BundlingOptions.builder()
 *                 .environment(Map.of(
 *                         "HELLO", "WORLD"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-23T18:57:18.976Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.go.alpha.$Module.class, fqn = "@aws-cdk/aws-lambda-go-alpha.BundlingOptions")
@software.amazon.jsii.Jsii.Proxy(BundlingOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BundlingOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.DockerRunOptions {

    /**
     * (experimental) Specify a custom hash for this asset.
     * <p>
     * If <code>assetHashType</code> is set it must
     * be set to <code>AssetHashType.CUSTOM</code>. For consistency, this custom hash will
     * be SHA256 hashed and encoded as hex. The resulting hash will be the asset
     * hash.
     * <p>
     * NOTE: the hash is used in order to identify a specific revision of the asset, and
     * used for optimizing and caching deployment activities related to this asset such as
     * packaging, uploading to Amazon S3, etc. If you chose to customize the hash, you will
     * need to make sure it is updated every time the asset changes, or otherwise it is
     * possible that some deployments will not be invalidated.
     * <p>
     * Default: - based on `assetHashType`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssetHash() {
        return null;
    }

    /**
     * (experimental) Determines how the asset hash is calculated. Assets will get rebuilt and uploaded only if their hash has changed.
     * <p>
     * If the asset hash is set to <code>OUTPUT</code> (default), the hash is calculated
     * after bundling. This means that any change in the output will cause
     * the asset to be invalidated and uploaded. Bear in mind that the
     * go binary that is output can be different depending on the environment
     * that it was compiled in. If you want to control when the output is changed
     * it is recommended that you use immutable build images such as
     * <code>public.ecr.aws/bitnami/golang:1.16.3-debian-10-r16</code>.
     * <p>
     * If the asset hash is set to <code>SOURCE</code>, then only changes to the source
     * directory will cause the asset to rebuild. If your go project has multiple
     * Lambda functions this means that an update to any one function could cause
     * all the functions to be rebuilt and uploaded.
     * <p>
     * Default: - AssetHashType.OUTPUT. If `assetHash` is also specified,
     * the default is `CUSTOM`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.AssetHashType getAssetHashType() {
        return null;
    }

    /**
     * (experimental) Build arguments to pass when building the bundling image.
     * <p>
     * Default: - no build arguments are passed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getBuildArgs() {
        return null;
    }

    /**
     * (experimental) Whether or not to enable cgo during go build.
     * <p>
     * This will set the CGO_ENABLED environment variable
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCgoEnabled() {
        return null;
    }

    /**
     * (experimental) Command hooks.
     * <p>
     * Default: - do not run additional commands
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.go.alpha.ICommandHooks getCommandHooks() {
        return null;
    }

    /**
     * (experimental) A custom bundling Docker image.
     * <p>
     * Default: - use the Docker image provided by
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.DockerImage getDockerImage() {
        return null;
    }

    /**
     * (experimental) Force bundling in a Docker container even if local bundling is possible.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getForcedDockerBundling() {
        return null;
    }

    /**
     * (experimental) List of additional flags to use while building.
     * <p>
     * For example:
     * ['ldflags "-s -w"']
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGoBuildFlags() {
        return null;
    }

    /**
     * (experimental) What Go proxies to use to fetch the packages involved in the build.
     * <p>
     * Pass a list of proxy addresses in order, and/or the string <code>'direct'</code> to
     * attempt direct access.
     * <p>
     * By default this construct uses no proxies, but a standard Go install would
     * use the Google proxy by default. To recreate that behavior, do the following:
     * <p>
     * <blockquote><pre>
     * GoFunction.Builder.create(this, "GoFunction")
     *         .entry("app/cmd/api")
     *         .bundling(BundlingOptions.builder()
     *                 .goProxies(List.of(GoFunction.GOOGLE_GOPROXY, "direct"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * Default: - Direct access
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGoProxies() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BundlingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BundlingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<BundlingOptions> {
        java.lang.String assetHash;
        software.amazon.awscdk.AssetHashType assetHashType;
        java.util.Map<java.lang.String, java.lang.String> buildArgs;
        java.lang.Boolean cgoEnabled;
        software.amazon.awscdk.services.lambda.go.alpha.ICommandHooks commandHooks;
        software.amazon.awscdk.DockerImage dockerImage;
        java.lang.Boolean forcedDockerBundling;
        java.util.List<java.lang.String> goBuildFlags;
        java.util.List<java.lang.String> goProxies;
        java.util.List<java.lang.String> command;
        java.util.List<java.lang.String> entrypoint;
        java.util.Map<java.lang.String, java.lang.String> environment;
        java.lang.String network;
        java.lang.String securityOpt;
        java.lang.String user;
        java.util.List<software.amazon.awscdk.DockerVolume> volumes;
        java.util.List<java.lang.String> volumesFrom;
        java.lang.String workingDirectory;

        /**
         * Sets the value of {@link BundlingOptions#getAssetHash}
         * @param assetHash Specify a custom hash for this asset.
         *                  If <code>assetHashType</code> is set it must
         *                  be set to <code>AssetHashType.CUSTOM</code>. For consistency, this custom hash will
         *                  be SHA256 hashed and encoded as hex. The resulting hash will be the asset
         *                  hash.
         *                  <p>
         *                  NOTE: the hash is used in order to identify a specific revision of the asset, and
         *                  used for optimizing and caching deployment activities related to this asset such as
         *                  packaging, uploading to Amazon S3, etc. If you chose to customize the hash, you will
         *                  need to make sure it is updated every time the asset changes, or otherwise it is
         *                  possible that some deployments will not be invalidated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assetHash(java.lang.String assetHash) {
            this.assetHash = assetHash;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getAssetHashType}
         * @param assetHashType Determines how the asset hash is calculated. Assets will get rebuilt and uploaded only if their hash has changed.
         *                      If the asset hash is set to <code>OUTPUT</code> (default), the hash is calculated
         *                      after bundling. This means that any change in the output will cause
         *                      the asset to be invalidated and uploaded. Bear in mind that the
         *                      go binary that is output can be different depending on the environment
         *                      that it was compiled in. If you want to control when the output is changed
         *                      it is recommended that you use immutable build images such as
         *                      <code>public.ecr.aws/bitnami/golang:1.16.3-debian-10-r16</code>.
         *                      <p>
         *                      If the asset hash is set to <code>SOURCE</code>, then only changes to the source
         *                      directory will cause the asset to rebuild. If your go project has multiple
         *                      Lambda functions this means that an update to any one function could cause
         *                      all the functions to be rebuilt and uploaded.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assetHashType(software.amazon.awscdk.AssetHashType assetHashType) {
            this.assetHashType = assetHashType;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getBuildArgs}
         * @param buildArgs Build arguments to pass when building the bundling image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildArgs(java.util.Map<java.lang.String, java.lang.String> buildArgs) {
            this.buildArgs = buildArgs;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getCgoEnabled}
         * @param cgoEnabled Whether or not to enable cgo during go build.
         *                   This will set the CGO_ENABLED environment variable
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cgoEnabled(java.lang.Boolean cgoEnabled) {
            this.cgoEnabled = cgoEnabled;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getCommandHooks}
         * @param commandHooks Command hooks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder commandHooks(software.amazon.awscdk.services.lambda.go.alpha.ICommandHooks commandHooks) {
            this.commandHooks = commandHooks;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getDockerImage}
         * @param dockerImage A custom bundling Docker image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dockerImage(software.amazon.awscdk.DockerImage dockerImage) {
            this.dockerImage = dockerImage;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getForcedDockerBundling}
         * @param forcedDockerBundling Force bundling in a Docker container even if local bundling is possible.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder forcedDockerBundling(java.lang.Boolean forcedDockerBundling) {
            this.forcedDockerBundling = forcedDockerBundling;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getGoBuildFlags}
         * @param goBuildFlags List of additional flags to use while building.
         *                     For example:
         *                     ['ldflags "-s -w"']
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder goBuildFlags(java.util.List<java.lang.String> goBuildFlags) {
            this.goBuildFlags = goBuildFlags;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getGoProxies}
         * @param goProxies What Go proxies to use to fetch the packages involved in the build.
         *                  Pass a list of proxy addresses in order, and/or the string <code>'direct'</code> to
         *                  attempt direct access.
         *                  <p>
         *                  By default this construct uses no proxies, but a standard Go install would
         *                  use the Google proxy by default. To recreate that behavior, do the following:
         *                  <p>
         *                  <blockquote><pre>
         *                  GoFunction.Builder.create(this, "GoFunction")
         *                          .entry("app/cmd/api")
         *                          .bundling(BundlingOptions.builder()
         *                                  .goProxies(List.of(GoFunction.GOOGLE_GOPROXY, "direct"))
         *                                  .build())
         *                          .build();
         *                  </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder goProxies(java.util.List<java.lang.String> goProxies) {
            this.goProxies = goProxies;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getCommand}
         * @param command The command to run in the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getEntrypoint}
         * @param entrypoint The entrypoint to run in the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entrypoint(java.util.List<java.lang.String> entrypoint) {
            this.entrypoint = entrypoint;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getEnvironment}
         * @param environment The environment variables to pass to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getNetwork}
         * @param network Docker [Networking options](https://docs.docker.com/engine/reference/commandline/run/#connect-a-container-to-a-network---network).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder network(java.lang.String network) {
            this.network = network;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getSecurityOpt}
         * @param securityOpt [Security configuration](https://docs.docker.com/engine/reference/run/#security-configuration) when running the docker container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityOpt(java.lang.String securityOpt) {
            this.securityOpt = securityOpt;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getUser}
         * @param user The user to use when running the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder user(java.lang.String user) {
            this.user = user;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getVolumes}
         * @param volumes Docker volumes to mount.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder volumes(java.util.List<? extends software.amazon.awscdk.DockerVolume> volumes) {
            this.volumes = (java.util.List<software.amazon.awscdk.DockerVolume>)volumes;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getVolumesFrom}
         * @param volumesFrom Where to mount the specified volumes from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumesFrom(java.util.List<java.lang.String> volumesFrom) {
            this.volumesFrom = volumesFrom;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getWorkingDirectory}
         * @param workingDirectory Working directory inside the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workingDirectory(java.lang.String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BundlingOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public BundlingOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BundlingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BundlingOptions {
        private final java.lang.String assetHash;
        private final software.amazon.awscdk.AssetHashType assetHashType;
        private final java.util.Map<java.lang.String, java.lang.String> buildArgs;
        private final java.lang.Boolean cgoEnabled;
        private final software.amazon.awscdk.services.lambda.go.alpha.ICommandHooks commandHooks;
        private final software.amazon.awscdk.DockerImage dockerImage;
        private final java.lang.Boolean forcedDockerBundling;
        private final java.util.List<java.lang.String> goBuildFlags;
        private final java.util.List<java.lang.String> goProxies;
        private final java.util.List<java.lang.String> command;
        private final java.util.List<java.lang.String> entrypoint;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final java.lang.String network;
        private final java.lang.String securityOpt;
        private final java.lang.String user;
        private final java.util.List<software.amazon.awscdk.DockerVolume> volumes;
        private final java.util.List<java.lang.String> volumesFrom;
        private final java.lang.String workingDirectory;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assetHash = software.amazon.jsii.Kernel.get(this, "assetHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetHashType = software.amazon.jsii.Kernel.get(this, "assetHashType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.AssetHashType.class));
            this.buildArgs = software.amazon.jsii.Kernel.get(this, "buildArgs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cgoEnabled = software.amazon.jsii.Kernel.get(this, "cgoEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.commandHooks = software.amazon.jsii.Kernel.get(this, "commandHooks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.go.alpha.ICommandHooks.class));
            this.dockerImage = software.amazon.jsii.Kernel.get(this, "dockerImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.DockerImage.class));
            this.forcedDockerBundling = software.amazon.jsii.Kernel.get(this, "forcedDockerBundling", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.goBuildFlags = software.amazon.jsii.Kernel.get(this, "goBuildFlags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.goProxies = software.amazon.jsii.Kernel.get(this, "goProxies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.entrypoint = software.amazon.jsii.Kernel.get(this, "entrypoint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.network = software.amazon.jsii.Kernel.get(this, "network", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityOpt = software.amazon.jsii.Kernel.get(this, "securityOpt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.DockerVolume.class)));
            this.volumesFrom = software.amazon.jsii.Kernel.get(this, "volumesFrom", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.workingDirectory = software.amazon.jsii.Kernel.get(this, "workingDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assetHash = builder.assetHash;
            this.assetHashType = builder.assetHashType;
            this.buildArgs = builder.buildArgs;
            this.cgoEnabled = builder.cgoEnabled;
            this.commandHooks = builder.commandHooks;
            this.dockerImage = builder.dockerImage;
            this.forcedDockerBundling = builder.forcedDockerBundling;
            this.goBuildFlags = builder.goBuildFlags;
            this.goProxies = builder.goProxies;
            this.command = builder.command;
            this.entrypoint = builder.entrypoint;
            this.environment = builder.environment;
            this.network = builder.network;
            this.securityOpt = builder.securityOpt;
            this.user = builder.user;
            this.volumes = (java.util.List<software.amazon.awscdk.DockerVolume>)builder.volumes;
            this.volumesFrom = builder.volumesFrom;
            this.workingDirectory = builder.workingDirectory;
        }

        @Override
        public final java.lang.String getAssetHash() {
            return this.assetHash;
        }

        @Override
        public final software.amazon.awscdk.AssetHashType getAssetHashType() {
            return this.assetHashType;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getBuildArgs() {
            return this.buildArgs;
        }

        @Override
        public final java.lang.Boolean getCgoEnabled() {
            return this.cgoEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.go.alpha.ICommandHooks getCommandHooks() {
            return this.commandHooks;
        }

        @Override
        public final software.amazon.awscdk.DockerImage getDockerImage() {
            return this.dockerImage;
        }

        @Override
        public final java.lang.Boolean getForcedDockerBundling() {
            return this.forcedDockerBundling;
        }

        @Override
        public final java.util.List<java.lang.String> getGoBuildFlags() {
            return this.goBuildFlags;
        }

        @Override
        public final java.util.List<java.lang.String> getGoProxies() {
            return this.goProxies;
        }

        @Override
        public final java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public final java.util.List<java.lang.String> getEntrypoint() {
            return this.entrypoint;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.lang.String getNetwork() {
            return this.network;
        }

        @Override
        public final java.lang.String getSecurityOpt() {
            return this.securityOpt;
        }

        @Override
        public final java.lang.String getUser() {
            return this.user;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.DockerVolume> getVolumes() {
            return this.volumes;
        }

        @Override
        public final java.util.List<java.lang.String> getVolumesFrom() {
            return this.volumesFrom;
        }

        @Override
        public final java.lang.String getWorkingDirectory() {
            return this.workingDirectory;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAssetHash() != null) {
                data.set("assetHash", om.valueToTree(this.getAssetHash()));
            }
            if (this.getAssetHashType() != null) {
                data.set("assetHashType", om.valueToTree(this.getAssetHashType()));
            }
            if (this.getBuildArgs() != null) {
                data.set("buildArgs", om.valueToTree(this.getBuildArgs()));
            }
            if (this.getCgoEnabled() != null) {
                data.set("cgoEnabled", om.valueToTree(this.getCgoEnabled()));
            }
            if (this.getCommandHooks() != null) {
                data.set("commandHooks", om.valueToTree(this.getCommandHooks()));
            }
            if (this.getDockerImage() != null) {
                data.set("dockerImage", om.valueToTree(this.getDockerImage()));
            }
            if (this.getForcedDockerBundling() != null) {
                data.set("forcedDockerBundling", om.valueToTree(this.getForcedDockerBundling()));
            }
            if (this.getGoBuildFlags() != null) {
                data.set("goBuildFlags", om.valueToTree(this.getGoBuildFlags()));
            }
            if (this.getGoProxies() != null) {
                data.set("goProxies", om.valueToTree(this.getGoProxies()));
            }
            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getEntrypoint() != null) {
                data.set("entrypoint", om.valueToTree(this.getEntrypoint()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getNetwork() != null) {
                data.set("network", om.valueToTree(this.getNetwork()));
            }
            if (this.getSecurityOpt() != null) {
                data.set("securityOpt", om.valueToTree(this.getSecurityOpt()));
            }
            if (this.getUser() != null) {
                data.set("user", om.valueToTree(this.getUser()));
            }
            if (this.getVolumes() != null) {
                data.set("volumes", om.valueToTree(this.getVolumes()));
            }
            if (this.getVolumesFrom() != null) {
                data.set("volumesFrom", om.valueToTree(this.getVolumesFrom()));
            }
            if (this.getWorkingDirectory() != null) {
                data.set("workingDirectory", om.valueToTree(this.getWorkingDirectory()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda-go-alpha.BundlingOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BundlingOptions.Jsii$Proxy that = (BundlingOptions.Jsii$Proxy) o;

            if (this.assetHash != null ? !this.assetHash.equals(that.assetHash) : that.assetHash != null) return false;
            if (this.assetHashType != null ? !this.assetHashType.equals(that.assetHashType) : that.assetHashType != null) return false;
            if (this.buildArgs != null ? !this.buildArgs.equals(that.buildArgs) : that.buildArgs != null) return false;
            if (this.cgoEnabled != null ? !this.cgoEnabled.equals(that.cgoEnabled) : that.cgoEnabled != null) return false;
            if (this.commandHooks != null ? !this.commandHooks.equals(that.commandHooks) : that.commandHooks != null) return false;
            if (this.dockerImage != null ? !this.dockerImage.equals(that.dockerImage) : that.dockerImage != null) return false;
            if (this.forcedDockerBundling != null ? !this.forcedDockerBundling.equals(that.forcedDockerBundling) : that.forcedDockerBundling != null) return false;
            if (this.goBuildFlags != null ? !this.goBuildFlags.equals(that.goBuildFlags) : that.goBuildFlags != null) return false;
            if (this.goProxies != null ? !this.goProxies.equals(that.goProxies) : that.goProxies != null) return false;
            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.entrypoint != null ? !this.entrypoint.equals(that.entrypoint) : that.entrypoint != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.network != null ? !this.network.equals(that.network) : that.network != null) return false;
            if (this.securityOpt != null ? !this.securityOpt.equals(that.securityOpt) : that.securityOpt != null) return false;
            if (this.user != null ? !this.user.equals(that.user) : that.user != null) return false;
            if (this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null) return false;
            if (this.volumesFrom != null ? !this.volumesFrom.equals(that.volumesFrom) : that.volumesFrom != null) return false;
            return this.workingDirectory != null ? this.workingDirectory.equals(that.workingDirectory) : that.workingDirectory == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assetHash != null ? this.assetHash.hashCode() : 0;
            result = 31 * result + (this.assetHashType != null ? this.assetHashType.hashCode() : 0);
            result = 31 * result + (this.buildArgs != null ? this.buildArgs.hashCode() : 0);
            result = 31 * result + (this.cgoEnabled != null ? this.cgoEnabled.hashCode() : 0);
            result = 31 * result + (this.commandHooks != null ? this.commandHooks.hashCode() : 0);
            result = 31 * result + (this.dockerImage != null ? this.dockerImage.hashCode() : 0);
            result = 31 * result + (this.forcedDockerBundling != null ? this.forcedDockerBundling.hashCode() : 0);
            result = 31 * result + (this.goBuildFlags != null ? this.goBuildFlags.hashCode() : 0);
            result = 31 * result + (this.goProxies != null ? this.goProxies.hashCode() : 0);
            result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
            result = 31 * result + (this.entrypoint != null ? this.entrypoint.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.network != null ? this.network.hashCode() : 0);
            result = 31 * result + (this.securityOpt != null ? this.securityOpt.hashCode() : 0);
            result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            result = 31 * result + (this.volumesFrom != null ? this.volumesFrom.hashCode() : 0);
            result = 31 * result + (this.workingDirectory != null ? this.workingDirectory.hashCode() : 0);
            return result;
        }
    }
}
