/**
 * <h1>Amazon Lambda Golang Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Experimental" src="https://img.shields.io/badge/cdk--constructs-experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * The APIs of higher level constructs in this module are experimental and under active development.
 * They are subject to non-backward compatible changes or removal in any future version. These are
 * not subject to the <a href="https://semver.org/">Semantic Versioning</a> model and breaking changes will be
 * announced in the release notes. This means that while you may use them, you may need to update
 * your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This library provides constructs for Golang Lambda functions.
 * <p>
 * To use this module you will either need to have <code>Go</code> installed (<code>go1.11</code> or later) or <code>Docker</code> installed.
 * See <a href="#local-bundling">Local Bundling</a>/<a href="#docker-bundling">Docker Bundling</a> for more information.
 * <p>
 * This module also requires that your Golang application is
 * using a Go version &gt;= 1.11 and is using <a href="https://golang.org/ref/mod">Go modules</a>.
 * <p>
 * <h2>Go Function</h2>
 * <p>
 * Define a <code>GoFunction</code>:
 * <p>
 * <blockquote><pre>
 * GoFunction.Builder.create(this, "handler")
 *         .entry("app/cmd/api")
 *         .build();
 * </pre></blockquote>
 * <p>
 * By default, if <code>entry</code> points to a directory, then the construct will assume there is a Go entry file (i.e. <code>main.go</code>).
 * Let's look at an example Go project:
 * <p>
 * <blockquote><pre>
 * lamda-app
 * ├── cmd
 * │   └── api
 * │       └── main.go
 * ├── go.mod
 * ├── go.sum
 * ├── pkg
 * │   ├── auth
 * │   │   └── auth.go
 * │   └── middleware
 * │       └── middleware.go
 * └── vendor
 *     ├── github.com
 *     │   └── aws
 *     │       └── aws-lambda-go
 *     └── modules.txt
 * </pre></blockquote>
 * <p>
 * With the above layout I could either provide the <code>entry</code> as <code>lambda-app/cmd/api</code> or <code>lambda-app/cmd/api/main.go</code>, either will work.
 * When the construct builds the golang binary this will be translated <code>go build ./cmd/api</code> &amp; <code>go build ./cmd/api/main.go</code> respectively.
 * The construct will figure out where it needs to run the <code>go build</code> command from, in this example it would be from
 * the <code>lambda-app</code> directory. It does this by determining the <a href="#mod-file-path">mod file path</a>, which is explained in the
 * next section.
 * <p>
 * <h3>mod file path</h3>
 * <p>
 * The <code>GoFunction</code> tries to automatically determine your project root, that is
 * the root of your golang project. This is usually where the top level <code>go.mod</code> file or
 * <code>vendor</code> folder of your project is located. When bundling in a Docker container, the
 * <code>moduleDir</code> is used as the source (<code>/asset-input</code>) for the volume mounted in
 * the container.
 * <p>
 * The CDK will walk up parent folders starting from
 * the current working directory until it finds a folder containing a <code>go.mod</code> file.
 * <p>
 * Alternatively, you can specify the <code>moduleDir</code> prop manually. In this case you
 * need to ensure that this path includes <code>entry</code> and any module/dependencies used
 * by your function. Otherwise bundling will fail.
 * <p>
 * <h2>Runtime</h2>
 * <p>
 * The <code>GoFunction</code> can be used with either the <code>GO_1_X</code> runtime or the provided runtimes (<code>PROVIDED</code>/<code>PROVIDED_AL2</code>).
 * By default it will use the <code>PROVIDED_AL2</code> runtime. The <code>GO_1_X</code> runtime does not support things like
 * <a href="https://docs.aws.amazon.com/lambda/latest/dg/using-extensions.html">Lambda Extensions</a>, whereas the provided runtimes do.
 * The <a href="https://github.com/aws/aws-lambda-go">aws-lambda-go</a> library has built in support for the provided runtime as long as
 * you name the handler <code>bootstrap</code> (which we do by default).
 * <p>
 * <h2>Dependencies</h2>
 * <p>
 * The construct will attempt to figure out how to handle the dependencies for your function. It will
 * do this by determining whether or not you are vendoring your dependencies. It makes this determination
 * by looking to see if there is a <code>vendor</code> folder at the <a href="#mod-file-path">mod file path</a>.
 * <p>
 * With this information the construct can determine what commands to run. You will
 * generally fall into two scenarios:
 * <p>
 * <ol>
 * <li>You are using vendoring (indicated by the presence of a <code>vendor</code> folder)
 * In this case <code>go build</code> will be run with <code>-mod=vendor</code> set</li>
 * <li>You are not using vendoring (indicated by the absence of a <code>vendor</code> folder)
 * If you are not vendoring then <code>go build</code> will be run without <code>-mod=vendor</code>
 * since the default behavior is to download dependencies</li>
 * </ol>
 * <p>
 * All other properties of <code>lambda.Function</code> are supported, see also the <a href="https://github.com/aws/aws-cdk/tree/main/packages/%40aws-cdk/aws-lambda">AWS Lambda construct library</a>.
 * <p>
 * <h2>Environment</h2>
 * <p>
 * By default the following environment variables are set for you:
 * <p>
 * <ul>
 * <li><code>GOOS=linux</code></li>
 * <li><code>GOARCH</code>: based on the target architecture of the Lambda function</li>
 * <li><code>GO111MODULE=on</code></li>
 * </ul>
 * <p>
 * Use the <code>environment</code> prop to define additional environment variables when go runs:
 * <p>
 * <blockquote><pre>
 * GoFunction.Builder.create(this, "handler")
 *         .entry("app/cmd/api")
 *         .bundling(BundlingOptions.builder()
 *                 .environment(Map.of(
 *                         "HELLO", "WORLD"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Local Bundling</h2>
 * <p>
 * If <code>Go</code> is installed locally and the version is &gt;= <code>go1.11</code> then it will be used to bundle your code in your environment. Otherwise, bundling will happen in a <a href="https://gallery.ecr.aws/sam/build-go1.x">Lambda compatible Docker container</a> with the Docker platform based on the target architecture of the Lambda function.
 * <p>
 * For macOS the recommended approach is to install <code>Go</code> as Docker volume performance is really poor.
 * <p>
 * <code>Go</code> can be installed by following the <a href="https://golang.org/doc/install">installation docs</a>.
 * <p>
 * <h2>Docker</h2>
 * <p>
 * To force bundling in a docker container even if <code>Go</code> is available in your environment, set the <code>forceDockerBundling</code> prop to <code>true</code>. This is useful if you want to make sure that your function is built in a consistent Lambda compatible environment.
 * <p>
 * Use the <code>buildArgs</code> prop to pass build arguments when building the bundling image:
 * <p>
 * <blockquote><pre>
 * GoFunction.Builder.create(this, "handler")
 *         .entry("app/cmd/api")
 *         .bundling(BundlingOptions.builder()
 *                 .buildArgs(Map.of(
 *                         "HTTPS_PROXY", "https://127.0.0.1:3001"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * Use the <code>bundling.dockerImage</code> prop to use a custom bundling image:
 * <p>
 * <blockquote><pre>
 * GoFunction.Builder.create(this, "handler")
 *         .entry("app/cmd/api")
 *         .bundling(BundlingOptions.builder()
 *                 .dockerImage(DockerImage.fromBuild("/path/to/Dockerfile"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * Use the <code>bundling.goBuildFlags</code> prop to pass additional build flags to <code>go build</code>:
 * <p>
 * <blockquote><pre>
 * GoFunction.Builder.create(this, "handler")
 *         .entry("app/cmd/api")
 *         .bundling(BundlingOptions.builder()
 *                 .goBuildFlags(List.of("-ldflags \"-s -w\""))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * By default this construct doesn't use any Go module proxies. This is contrary to
 * a standard Go installation, which would use the Google proxy by default. To
 * recreate that behavior, do the following:
 * <p>
 * <blockquote><pre>
 * GoFunction.Builder.create(this, "GoFunction")
 *         .entry("app/cmd/api")
 *         .bundling(BundlingOptions.builder()
 *                 .goProxies(List.of(GoFunction.GOOGLE_GOPROXY, "direct"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * You can set additional Docker options to configure the build environment:
 * <p>
 * <blockquote><pre>
 * GoFunction.Builder.create(this, "GoFunction")
 *         .entry("app/cmd/api")
 *         .bundling(BundlingOptions.builder()
 *                 .network("host")
 *                 .securityOpt("no-new-privileges")
 *                 .user("user:group")
 *                 .volumesFrom(List.of("777f7dc92da7"))
 *                 .volumes(List.of(DockerVolume.builder().hostPath("/host-path").containerPath("/container-path").build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Command hooks</h2>
 * <p>
 * It is  possible to run additional commands by specifying the <code>commandHooks</code> prop:
 * <p>
 * <blockquote><pre>
 * // This example only available in TypeScript
 * // Run additional commands on a GoFunction via `commandHooks` property
 * new go.GoFunction(this, 'handler', {
 *   bundling: {
 *     commandHooks: {
 *       // run tests
 *       beforeBundling(inputDir: string): string[] {
 *         return ['go test ./cmd/api -v'];
 *       },
 *       // ...
 *     },
 *   },
 * });
 * </pre></blockquote>
 * <p>
 * The following hooks are available:
 * <p>
 * <ul>
 * <li><code>beforeBundling</code>: runs before all bundling commands</li>
 * <li><code>afterBundling</code>: runs after all bundling commands</li>
 * </ul>
 * <p>
 * They all receive the directory containing the <code>go.mod</code> file (<code>inputDir</code>) and the
 * directory where the bundled asset will be output (<code>outputDir</code>). They must return
 * an array of commands to run. Commands are chained with <code>&amp;&amp;</code>.
 * <p>
 * The commands will run in the environment in which bundling occurs: inside the
 * container for Docker bundling or on the host OS for local bundling.
 * <p>
 * <h2>Additional considerations</h2>
 * <p>
 * Depending on how you structure your Golang application, you may want to change the <code>assetHashType</code> parameter.
 * By default this parameter is set to <code>AssetHashType.OUTPUT</code> which means that the CDK will calculate the asset hash
 * (and determine whether or not your code has changed) based on the Golang executable that is created.
 * <p>
 * If you specify <code>AssetHashType.SOURCE</code>, the CDK will calculate the asset hash by looking at the folder
 * that contains your <code>go.mod</code> file. If you are deploying a single Lambda function, or you want to redeploy
 * all of your functions if anything changes, then <code>AssetHashType.SOURCE</code> will probably work.
 * <p>
 * For example, if my app looked like this:
 * <p>
 * <blockquote><pre>
 * lamda-app
 * ├── cmd
 * │   └── api
 * │       └── main.go
 * ├── go.mod
 * ├── go.sum
 * └── pkg
 *     └── auth
 *         └── auth.go
 * </pre></blockquote>
 * <p>
 * With this structure I would provide the <code>entry</code> as <code>cmd/api</code> which means that the CDK
 * will determine that the protect root is <code>lambda-app</code> (it contains the <code>go.mod</code> file).
 * Since I only have a single Lambda function, and any update to files within the <code>lambda-app</code> directory
 * should trigger a new deploy, I could specify <code>AssetHashType.SOURCE</code>.
 * <p>
 * On the other hand, if I had a project that deployed multiple Lambda functions, for example:
 * <p>
 * <blockquote><pre>
 * lamda-app
 * ├── cmd
 * │   ├── api
 * │   │   └── main.go
 * │   └── anotherApi
 * │       └── main.go
 * ├── go.mod
 * ├── go.sum
 * └── pkg
 *     ├── auth
 *     │   └── auth.go
 *     └── middleware
 *         └── middleware.go
 * </pre></blockquote>
 * <p>
 * Then I would most likely want <code>AssetHashType.OUTPUT</code>. With <code>OUTPUT</code>
 * the CDK will only recognize changes if the Golang executable has changed,
 * and Go only includes dependencies that are used in the executable. So in this case
 * if <code>cmd/api</code> used the <code>auth</code> &amp; <code>middleware</code> packages, but <code>cmd/anotherApi</code> did not, then
 * an update to <code>auth</code> or <code>middleware</code> would only trigger an update to the <code>cmd/api</code> Lambda
 * Function.
 * <p>
 * <h2>Docker based bundling in complex Docker configurations</h2>
 * <p>
 * By default the input and output of Docker based bundling is handled via bind mounts.
 * In situtations where this does not work, like Docker-in-Docker setups or when using a remote Docker socket, you can configure an alternative, but slower, variant that also works in these situations.
 * <p>
 * <blockquote><pre>
 * GoFunction.Builder.create(this, "GoFunction")
 *         .entry("app/cmd/api")
 *         .bundling(BundlingOptions.builder()
 *                 .bundlingFileAccess(BundlingFileAccess.VOLUME_COPY)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.lambda.go.alpha;
