package software.amazon.awscdk.services.lambda.nodejs;

/**
 * Bundling options.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-07-12T14:11:19.508Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.nodejs.$Module.class, fqn = "@aws-cdk/aws-lambda-nodejs.BundlingOptions")
@software.amazon.jsii.Jsii.Proxy(BundlingOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BundlingOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Use this to insert an arbitrary string at the beginning of generated JavaScript files.
     * <p>
     * This is similar to footer which inserts at the end instead of the beginning.
     * <p>
     * This is commonly used to insert comments:
     * <p>
     * Default: -  no comments are passed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBanner() {
        return null;
    }

    /**
     * Build arguments to pass when building the bundling image.
     * <p>
     * Default: - no build arguments are passed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getBuildArgs() {
        return null;
    }

    /**
     * Command hooks.
     * <p>
     * Default: - do not run additional commands
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.nodejs.ICommandHooks getCommandHooks() {
        return null;
    }

    /**
     * Replace global identifiers with constant expressions.
     * <p>
     * Default: - no replacements are made
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * {"process.env.API_KEY";JSON.stringify("xxx-xxxx-xxx");
     * }}</pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getDefine() {
        return null;
    }

    /**
     * A custom bundling Docker image.
     * <p>
     * This image should have esbuild installed globally. If you plan to use <code>nodeModules</code>
     * it should also have <code>npm</code> or <code>yarn</code> depending on the lock file you're using.
     * <p>
     * See https://github.com/aws/aws-cdk/blob/master/packages/%40aws-cdk/aws-lambda-nodejs/lib/Dockerfile
     * for the default image provided by &#64;aws-cdk/aws-lambda-nodejs.
     * <p>
     * Default: - use the Docker image provided by
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.DockerImage getDockerImage() {
        return null;
    }

    /**
     * Environment variables defined when bundling runs.
     * <p>
     * Default: - no environment variables are defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return null;
    }

    /**
     * The version of esbuild to use when running in a Docker container.
     * <p>
     * Default: - latest v0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEsbuildVersion() {
        return null;
    }

    /**
     * A list of modules that should be considered as externals (already available in the runtime).
     * <p>
     * Default: ['aws-sdk']
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExternalModules() {
        return null;
    }

    /**
     * Use this to insert an arbitrary string at the end of generated JavaScript files.
     * <p>
     * This is similar to banner which inserts at the beginning instead of the end.
     * <p>
     * This is commonly used to insert comments
     * <p>
     * Default: -  no comments are passed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFooter() {
        return null;
    }

    /**
     * Force bundling in a Docker container even if local bundling is possible.
     * <p>
     * This is useful if your function relies on node modules
     * that should be installed (<code>nodeModules</code>) in a Lambda compatible
     * environment.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getForceDockerBundling() {
        return null;
    }

    /**
     * Whether to preserve the original `name` values even in minified code.
     * <p>
     * In JavaScript the <code>name</code> property on functions and classes defaults to a
     * nearby identifier in the source code.
     * <p>
     * However, minification renames symbols to reduce code size and bundling
     * sometimes need to rename symbols to avoid collisions. That changes value of
     * the <code>name</code> property for many of these cases. This is usually fine because
     * the <code>name</code> property is normally only used for debugging. However, some
     * frameworks rely on the <code>name</code> property for registration and binding purposes.
     * If this is the case, you can enable this option to preserve the original
     * <code>name</code> values even in minified code.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getKeepNames() {
        return null;
    }

    /**
     * Use loaders to change how a given input file is interpreted.
     * <p>
     * Configuring a loader for a given file type lets you load that file type with
     * an <code>import</code> statement or a <code>require</code> call.
     * <p>
     * Default: - use esbuild default loaders
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * {".png";"dataurl";
     * }}</pre></blockquote>
     * <p>
     * @see https://esbuild.github.io/api/#loader
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getLoader() {
        return null;
    }

    /**
     * Log level for esbuild.
     * <p>
     * Default: LogLevel.WARNING
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.nodejs.LogLevel getLogLevel() {
        return null;
    }

    /**
     * This option tells esbuild to write out a JSON file relative to output directory with metadata about the build.
     * <p>
     * The metadata in this JSON file follows this schema (specified using TypeScript syntax):
     * <p>
     * <blockquote><pre>
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * {outputs: {
     *               [path: string]: {
     *                 bytes: number
     *                 inputs: {
     *                   [path: string]: { bytesInOutput: number }
     *                 }
     *                 imports: { path: string }[]
     *                 exports: string[]
     *               }
     *             }
     * }
     * </pre></blockquote>
     * <p>
     * This data can then be analyzed by other tools. For example,
     * bundle buddy can consume esbuild's metadata format and generates a treemap visualization
     * of the modules in your bundle and how much space each one takes up.
     * <p>
     * Default: - false
     * <p>
     * @see https://esbuild.github.io/api/#metafile
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMetafile() {
        return null;
    }

    /**
     * Whether to minify files when bundling.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMinify() {
        return null;
    }

    /**
     * A list of modules that should be installed instead of bundled.
     * <p>
     * Modules are
     * installed in a Lambda compatible environment only when bundling runs in
     * Docker.
     * <p>
     * Default: - all modules are bundled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNodeModules() {
        return null;
    }

    /**
     * Whether to include source maps when bundling.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSourceMap() {
        return null;
    }

    /**
     * Target environment for the generated JavaScript code.
     * <p>
     * Default: - the node version of the runtime
     * <p>
     * @see https://esbuild.github.io/api/#target
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTarget() {
        return null;
    }

    /**
     * Normally the esbuild automatically discovers `tsconfig.json` files and reads their contents during a build.
     * <p>
     * However, you can also configure a custom <code>tsconfig.json</code> file to use instead.
     * <p>
     * This is similar to entry path, you need to provide path to your custom <code>tsconfig.json</code>.
     * <p>
     * This can be useful if you need to do multiple builds of the same code with different settings.
     * <p>
     * Default: - automatically discovered by `esbuild`
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * {"tsconfig";"path/custom.tsconfig.json";
     * }}</pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTsconfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BundlingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BundlingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BundlingOptions> {
        private java.lang.String banner;
        private java.util.Map<java.lang.String, java.lang.String> buildArgs;
        private software.amazon.awscdk.services.lambda.nodejs.ICommandHooks commandHooks;
        private java.util.Map<java.lang.String, java.lang.String> define;
        private software.amazon.awscdk.core.DockerImage dockerImage;
        private java.util.Map<java.lang.String, java.lang.String> environment;
        private java.lang.String esbuildVersion;
        private java.util.List<java.lang.String> externalModules;
        private java.lang.String footer;
        private java.lang.Boolean forceDockerBundling;
        private java.lang.Boolean keepNames;
        private java.util.Map<java.lang.String, java.lang.String> loader;
        private software.amazon.awscdk.services.lambda.nodejs.LogLevel logLevel;
        private java.lang.Boolean metafile;
        private java.lang.Boolean minify;
        private java.util.List<java.lang.String> nodeModules;
        private java.lang.Boolean sourceMap;
        private java.lang.String target;
        private java.lang.String tsconfig;

        /**
         * Sets the value of {@link BundlingOptions#getBanner}
         * @param banner Use this to insert an arbitrary string at the beginning of generated JavaScript files.
         *               This is similar to footer which inserts at the end instead of the beginning.
         *               <p>
         *               This is commonly used to insert comments:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder banner(java.lang.String banner) {
            this.banner = banner;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getBuildArgs}
         * @param buildArgs Build arguments to pass when building the bundling image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildArgs(java.util.Map<java.lang.String, java.lang.String> buildArgs) {
            this.buildArgs = buildArgs;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getCommandHooks}
         * @param commandHooks Command hooks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder commandHooks(software.amazon.awscdk.services.lambda.nodejs.ICommandHooks commandHooks) {
            this.commandHooks = commandHooks;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getDefine}
         * @param define Replace global identifiers with constant expressions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder define(java.util.Map<java.lang.String, java.lang.String> define) {
            this.define = define;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getDockerImage}
         * @param dockerImage A custom bundling Docker image.
         *                    This image should have esbuild installed globally. If you plan to use <code>nodeModules</code>
         *                    it should also have <code>npm</code> or <code>yarn</code> depending on the lock file you're using.
         *                    <p>
         *                    See https://github.com/aws/aws-cdk/blob/master/packages/%40aws-cdk/aws-lambda-nodejs/lib/Dockerfile
         *                    for the default image provided by &#64;aws-cdk/aws-lambda-nodejs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerImage(software.amazon.awscdk.core.DockerImage dockerImage) {
            this.dockerImage = dockerImage;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getEnvironment}
         * @param environment Environment variables defined when bundling runs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getEsbuildVersion}
         * @param esbuildVersion The version of esbuild to use when running in a Docker container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder esbuildVersion(java.lang.String esbuildVersion) {
            this.esbuildVersion = esbuildVersion;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getExternalModules}
         * @param externalModules A list of modules that should be considered as externals (already available in the runtime).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder externalModules(java.util.List<java.lang.String> externalModules) {
            this.externalModules = externalModules;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getFooter}
         * @param footer Use this to insert an arbitrary string at the end of generated JavaScript files.
         *               This is similar to banner which inserts at the beginning instead of the end.
         *               <p>
         *               This is commonly used to insert comments
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder footer(java.lang.String footer) {
            this.footer = footer;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getForceDockerBundling}
         * @param forceDockerBundling Force bundling in a Docker container even if local bundling is possible.
         *                            This is useful if your function relies on node modules
         *                            that should be installed (<code>nodeModules</code>) in a Lambda compatible
         *                            environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder forceDockerBundling(java.lang.Boolean forceDockerBundling) {
            this.forceDockerBundling = forceDockerBundling;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getKeepNames}
         * @param keepNames Whether to preserve the original `name` values even in minified code.
         *                  In JavaScript the <code>name</code> property on functions and classes defaults to a
         *                  nearby identifier in the source code.
         *                  <p>
         *                  However, minification renames symbols to reduce code size and bundling
         *                  sometimes need to rename symbols to avoid collisions. That changes value of
         *                  the <code>name</code> property for many of these cases. This is usually fine because
         *                  the <code>name</code> property is normally only used for debugging. However, some
         *                  frameworks rely on the <code>name</code> property for registration and binding purposes.
         *                  If this is the case, you can enable this option to preserve the original
         *                  <code>name</code> values even in minified code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keepNames(java.lang.Boolean keepNames) {
            this.keepNames = keepNames;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getLoader}
         * @param loader Use loaders to change how a given input file is interpreted.
         *               Configuring a loader for a given file type lets you load that file type with
         *               an <code>import</code> statement or a <code>require</code> call.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loader(java.util.Map<java.lang.String, java.lang.String> loader) {
            this.loader = loader;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getLogLevel}
         * @param logLevel Log level for esbuild.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logLevel(software.amazon.awscdk.services.lambda.nodejs.LogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getMetafile}
         * @param metafile This option tells esbuild to write out a JSON file relative to output directory with metadata about the build.
         *                 The metadata in this JSON file follows this schema (specified using TypeScript syntax):
         *                 <p>
         *                 <blockquote><pre>
         *                 // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         *                 {outputs: {
         *                               [path: string]: {
         *                                 bytes: number
         *                                 inputs: {
         *                                   [path: string]: { bytesInOutput: number }
         *                                 }
         *                                 imports: { path: string }[]
         *                                 exports: string[]
         *                               }
         *                             }
         *                 }
         *                 </pre></blockquote>
         *                 <p>
         *                 This data can then be analyzed by other tools. For example,
         *                 bundle buddy can consume esbuild's metadata format and generates a treemap visualization
         *                 of the modules in your bundle and how much space each one takes up.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metafile(java.lang.Boolean metafile) {
            this.metafile = metafile;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getMinify}
         * @param minify Whether to minify files when bundling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minify(java.lang.Boolean minify) {
            this.minify = minify;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getNodeModules}
         * @param nodeModules A list of modules that should be installed instead of bundled.
         *                    Modules are
         *                    installed in a Lambda compatible environment only when bundling runs in
         *                    Docker.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeModules(java.util.List<java.lang.String> nodeModules) {
            this.nodeModules = nodeModules;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getSourceMap}
         * @param sourceMap Whether to include source maps when bundling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceMap(java.lang.Boolean sourceMap) {
            this.sourceMap = sourceMap;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getTarget}
         * @param target Target environment for the generated JavaScript code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(java.lang.String target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link BundlingOptions#getTsconfig}
         * @param tsconfig Normally the esbuild automatically discovers `tsconfig.json` files and reads their contents during a build.
         *                 However, you can also configure a custom <code>tsconfig.json</code> file to use instead.
         *                 <p>
         *                 This is similar to entry path, you need to provide path to your custom <code>tsconfig.json</code>.
         *                 <p>
         *                 This can be useful if you need to do multiple builds of the same code with different settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tsconfig(java.lang.String tsconfig) {
            this.tsconfig = tsconfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BundlingOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BundlingOptions build() {
            return new Jsii$Proxy(banner, buildArgs, commandHooks, define, dockerImage, environment, esbuildVersion, externalModules, footer, forceDockerBundling, keepNames, loader, logLevel, metafile, minify, nodeModules, sourceMap, target, tsconfig);
        }
    }

    /**
     * An implementation for {@link BundlingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BundlingOptions {
        private final java.lang.String banner;
        private final java.util.Map<java.lang.String, java.lang.String> buildArgs;
        private final software.amazon.awscdk.services.lambda.nodejs.ICommandHooks commandHooks;
        private final java.util.Map<java.lang.String, java.lang.String> define;
        private final software.amazon.awscdk.core.DockerImage dockerImage;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final java.lang.String esbuildVersion;
        private final java.util.List<java.lang.String> externalModules;
        private final java.lang.String footer;
        private final java.lang.Boolean forceDockerBundling;
        private final java.lang.Boolean keepNames;
        private final java.util.Map<java.lang.String, java.lang.String> loader;
        private final software.amazon.awscdk.services.lambda.nodejs.LogLevel logLevel;
        private final java.lang.Boolean metafile;
        private final java.lang.Boolean minify;
        private final java.util.List<java.lang.String> nodeModules;
        private final java.lang.Boolean sourceMap;
        private final java.lang.String target;
        private final java.lang.String tsconfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.banner = software.amazon.jsii.Kernel.get(this, "banner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.buildArgs = software.amazon.jsii.Kernel.get(this, "buildArgs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.commandHooks = software.amazon.jsii.Kernel.get(this, "commandHooks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.nodejs.ICommandHooks.class));
            this.define = software.amazon.jsii.Kernel.get(this, "define", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.dockerImage = software.amazon.jsii.Kernel.get(this, "dockerImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.DockerImage.class));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.esbuildVersion = software.amazon.jsii.Kernel.get(this, "esbuildVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.externalModules = software.amazon.jsii.Kernel.get(this, "externalModules", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.footer = software.amazon.jsii.Kernel.get(this, "footer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.forceDockerBundling = software.amazon.jsii.Kernel.get(this, "forceDockerBundling", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.keepNames = software.amazon.jsii.Kernel.get(this, "keepNames", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.loader = software.amazon.jsii.Kernel.get(this, "loader", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.logLevel = software.amazon.jsii.Kernel.get(this, "logLevel", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.nodejs.LogLevel.class));
            this.metafile = software.amazon.jsii.Kernel.get(this, "metafile", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.minify = software.amazon.jsii.Kernel.get(this, "minify", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.nodeModules = software.amazon.jsii.Kernel.get(this, "nodeModules", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.sourceMap = software.amazon.jsii.Kernel.get(this, "sourceMap", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tsconfig = software.amazon.jsii.Kernel.get(this, "tsconfig", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.String banner, final java.util.Map<java.lang.String, java.lang.String> buildArgs, final software.amazon.awscdk.services.lambda.nodejs.ICommandHooks commandHooks, final java.util.Map<java.lang.String, java.lang.String> define, final software.amazon.awscdk.core.DockerImage dockerImage, final java.util.Map<java.lang.String, java.lang.String> environment, final java.lang.String esbuildVersion, final java.util.List<java.lang.String> externalModules, final java.lang.String footer, final java.lang.Boolean forceDockerBundling, final java.lang.Boolean keepNames, final java.util.Map<java.lang.String, java.lang.String> loader, final software.amazon.awscdk.services.lambda.nodejs.LogLevel logLevel, final java.lang.Boolean metafile, final java.lang.Boolean minify, final java.util.List<java.lang.String> nodeModules, final java.lang.Boolean sourceMap, final java.lang.String target, final java.lang.String tsconfig) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.banner = banner;
            this.buildArgs = buildArgs;
            this.commandHooks = commandHooks;
            this.define = define;
            this.dockerImage = dockerImage;
            this.environment = environment;
            this.esbuildVersion = esbuildVersion;
            this.externalModules = externalModules;
            this.footer = footer;
            this.forceDockerBundling = forceDockerBundling;
            this.keepNames = keepNames;
            this.loader = loader;
            this.logLevel = logLevel;
            this.metafile = metafile;
            this.minify = minify;
            this.nodeModules = nodeModules;
            this.sourceMap = sourceMap;
            this.target = target;
            this.tsconfig = tsconfig;
        }

        @Override
        public final java.lang.String getBanner() {
            return this.banner;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getBuildArgs() {
            return this.buildArgs;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.nodejs.ICommandHooks getCommandHooks() {
            return this.commandHooks;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getDefine() {
            return this.define;
        }

        @Override
        public final software.amazon.awscdk.core.DockerImage getDockerImage() {
            return this.dockerImage;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.lang.String getEsbuildVersion() {
            return this.esbuildVersion;
        }

        @Override
        public final java.util.List<java.lang.String> getExternalModules() {
            return this.externalModules;
        }

        @Override
        public final java.lang.String getFooter() {
            return this.footer;
        }

        @Override
        public final java.lang.Boolean getForceDockerBundling() {
            return this.forceDockerBundling;
        }

        @Override
        public final java.lang.Boolean getKeepNames() {
            return this.keepNames;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getLoader() {
            return this.loader;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.nodejs.LogLevel getLogLevel() {
            return this.logLevel;
        }

        @Override
        public final java.lang.Boolean getMetafile() {
            return this.metafile;
        }

        @Override
        public final java.lang.Boolean getMinify() {
            return this.minify;
        }

        @Override
        public final java.util.List<java.lang.String> getNodeModules() {
            return this.nodeModules;
        }

        @Override
        public final java.lang.Boolean getSourceMap() {
            return this.sourceMap;
        }

        @Override
        public final java.lang.String getTarget() {
            return this.target;
        }

        @Override
        public final java.lang.String getTsconfig() {
            return this.tsconfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBanner() != null) {
                data.set("banner", om.valueToTree(this.getBanner()));
            }
            if (this.getBuildArgs() != null) {
                data.set("buildArgs", om.valueToTree(this.getBuildArgs()));
            }
            if (this.getCommandHooks() != null) {
                data.set("commandHooks", om.valueToTree(this.getCommandHooks()));
            }
            if (this.getDefine() != null) {
                data.set("define", om.valueToTree(this.getDefine()));
            }
            if (this.getDockerImage() != null) {
                data.set("dockerImage", om.valueToTree(this.getDockerImage()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getEsbuildVersion() != null) {
                data.set("esbuildVersion", om.valueToTree(this.getEsbuildVersion()));
            }
            if (this.getExternalModules() != null) {
                data.set("externalModules", om.valueToTree(this.getExternalModules()));
            }
            if (this.getFooter() != null) {
                data.set("footer", om.valueToTree(this.getFooter()));
            }
            if (this.getForceDockerBundling() != null) {
                data.set("forceDockerBundling", om.valueToTree(this.getForceDockerBundling()));
            }
            if (this.getKeepNames() != null) {
                data.set("keepNames", om.valueToTree(this.getKeepNames()));
            }
            if (this.getLoader() != null) {
                data.set("loader", om.valueToTree(this.getLoader()));
            }
            if (this.getLogLevel() != null) {
                data.set("logLevel", om.valueToTree(this.getLogLevel()));
            }
            if (this.getMetafile() != null) {
                data.set("metafile", om.valueToTree(this.getMetafile()));
            }
            if (this.getMinify() != null) {
                data.set("minify", om.valueToTree(this.getMinify()));
            }
            if (this.getNodeModules() != null) {
                data.set("nodeModules", om.valueToTree(this.getNodeModules()));
            }
            if (this.getSourceMap() != null) {
                data.set("sourceMap", om.valueToTree(this.getSourceMap()));
            }
            if (this.getTarget() != null) {
                data.set("target", om.valueToTree(this.getTarget()));
            }
            if (this.getTsconfig() != null) {
                data.set("tsconfig", om.valueToTree(this.getTsconfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda-nodejs.BundlingOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BundlingOptions.Jsii$Proxy that = (BundlingOptions.Jsii$Proxy) o;

            if (this.banner != null ? !this.banner.equals(that.banner) : that.banner != null) return false;
            if (this.buildArgs != null ? !this.buildArgs.equals(that.buildArgs) : that.buildArgs != null) return false;
            if (this.commandHooks != null ? !this.commandHooks.equals(that.commandHooks) : that.commandHooks != null) return false;
            if (this.define != null ? !this.define.equals(that.define) : that.define != null) return false;
            if (this.dockerImage != null ? !this.dockerImage.equals(that.dockerImage) : that.dockerImage != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.esbuildVersion != null ? !this.esbuildVersion.equals(that.esbuildVersion) : that.esbuildVersion != null) return false;
            if (this.externalModules != null ? !this.externalModules.equals(that.externalModules) : that.externalModules != null) return false;
            if (this.footer != null ? !this.footer.equals(that.footer) : that.footer != null) return false;
            if (this.forceDockerBundling != null ? !this.forceDockerBundling.equals(that.forceDockerBundling) : that.forceDockerBundling != null) return false;
            if (this.keepNames != null ? !this.keepNames.equals(that.keepNames) : that.keepNames != null) return false;
            if (this.loader != null ? !this.loader.equals(that.loader) : that.loader != null) return false;
            if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) return false;
            if (this.metafile != null ? !this.metafile.equals(that.metafile) : that.metafile != null) return false;
            if (this.minify != null ? !this.minify.equals(that.minify) : that.minify != null) return false;
            if (this.nodeModules != null ? !this.nodeModules.equals(that.nodeModules) : that.nodeModules != null) return false;
            if (this.sourceMap != null ? !this.sourceMap.equals(that.sourceMap) : that.sourceMap != null) return false;
            if (this.target != null ? !this.target.equals(that.target) : that.target != null) return false;
            return this.tsconfig != null ? this.tsconfig.equals(that.tsconfig) : that.tsconfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.banner != null ? this.banner.hashCode() : 0;
            result = 31 * result + (this.buildArgs != null ? this.buildArgs.hashCode() : 0);
            result = 31 * result + (this.commandHooks != null ? this.commandHooks.hashCode() : 0);
            result = 31 * result + (this.define != null ? this.define.hashCode() : 0);
            result = 31 * result + (this.dockerImage != null ? this.dockerImage.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.esbuildVersion != null ? this.esbuildVersion.hashCode() : 0);
            result = 31 * result + (this.externalModules != null ? this.externalModules.hashCode() : 0);
            result = 31 * result + (this.footer != null ? this.footer.hashCode() : 0);
            result = 31 * result + (this.forceDockerBundling != null ? this.forceDockerBundling.hashCode() : 0);
            result = 31 * result + (this.keepNames != null ? this.keepNames.hashCode() : 0);
            result = 31 * result + (this.loader != null ? this.loader.hashCode() : 0);
            result = 31 * result + (this.logLevel != null ? this.logLevel.hashCode() : 0);
            result = 31 * result + (this.metafile != null ? this.metafile.hashCode() : 0);
            result = 31 * result + (this.minify != null ? this.minify.hashCode() : 0);
            result = 31 * result + (this.nodeModules != null ? this.nodeModules.hashCode() : 0);
            result = 31 * result + (this.sourceMap != null ? this.sourceMap.hashCode() : 0);
            result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
            result = 31 * result + (this.tsconfig != null ? this.tsconfig.hashCode() : 0);
            return result;
        }
    }
}
