package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * The action to take when the cluster step fails.
 * <p>
 * Default: CONTINUE
 * <p>
 * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_StepConfig.html
 * Here, they are named as TERMINATE_JOB_FLOW, TERMINATE_CLUSTER, CANCEL_AND_WAIT, and CONTINUE respectively.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-08-05T11:21:23.050Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.ActionOnFailure")
public enum ActionOnFailure {
    /**
     * Terminate the Cluster on Step Failure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TERMINATE_CLUSTER,
    /**
     * Cancel Step execution and enter WAITING state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CANCEL_AND_WAIT,
    /**
     * Continue to the next Step.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CONTINUE,
}
