package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Configuration for running an ECS task on Fargate.
 * <p>
 * @see https://docs.aws.amazon.com/AmazonECS/latest/userguide/launch_types.html#launch-type-fargate
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-08-05T11:21:26.343Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EcsFargateLaunchTarget")
public class EcsFargateLaunchTarget extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.tasks.IEcsLaunchTarget {

    protected EcsFargateLaunchTarget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcsFargateLaunchTarget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EcsFargateLaunchTarget(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EcsFargateLaunchTargetOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { options });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EcsFargateLaunchTarget() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Called when the Fargate launch type configured on RunTask.
     * <p>
     * @param _task This parameter is required.
     * @param launchTargetOptions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EcsLaunchTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EcsRunTask _task, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.LaunchTargetBindOptions launchTargetOptions) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EcsLaunchTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_task, "_task is required"), java.util.Objects.requireNonNull(launchTargetOptions, "launchTargetOptions is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.EcsFargateLaunchTarget}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.tasks.EcsFargateLaunchTarget> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.stepfunctions.tasks.EcsFargateLaunchTargetOptions.Builder options;

        private Builder() {
        }

        /**
         * Refers to a specific runtime environment for Fargate task infrastructure.
         * <p>
         * Fargate platform version is a combination of the kernel and container runtime versions.
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html
         * @param platformVersion Refers to a specific runtime environment for Fargate task infrastructure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformVersion(final software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion) {
            this.options().platformVersion(platformVersion);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.EcsFargateLaunchTarget}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.EcsFargateLaunchTarget build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.EcsFargateLaunchTarget(
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.services.stepfunctions.tasks.EcsFargateLaunchTargetOptions.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.services.stepfunctions.tasks.EcsFargateLaunchTargetOptions.Builder();
            }
            return this.options;
        }
    }
}
