/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import java.util.List;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.PlacementConstraint;
import software.amazon.awscdk.services.ecs.PlacementStrategy;
import software.amazon.awscdk.services.ecs.TaskDefinition;
import software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.tasks.CommonEcsRunTaskProps;
import software.amazon.awscdk.services.stepfunctions.tasks.ContainerOverride;
import software.amazon.awscdk.services.stepfunctions.tasks.RunEcsEc2TaskProps;
import software.amazon.jsii.JsiiSerializable;

public interface RunEcsEc2TaskProps
extends JsiiSerializable,
CommonEcsRunTaskProps {
    public List<PlacementConstraint> getPlacementConstraints();

    public List<PlacementStrategy> getPlacementStrategies();

    public ISecurityGroup getSecurityGroup();

    public SubnetSelection getSubnets();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<PlacementConstraint> placementConstraints;
        private List<PlacementStrategy> placementStrategies;
        private ISecurityGroup securityGroup;
        private SubnetSelection subnets;
        private ICluster cluster;
        private TaskDefinition taskDefinition;
        private List<ContainerOverride> containerOverrides;
        private ServiceIntegrationPattern integrationPattern;

        public Builder placementConstraints(List<PlacementConstraint> placementConstraints) {
            this.placementConstraints = placementConstraints;
            return this;
        }

        public Builder placementStrategies(List<PlacementStrategy> placementStrategies) {
            this.placementStrategies = placementStrategies;
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public Builder subnets(SubnetSelection subnets) {
            this.subnets = subnets;
            return this;
        }

        public Builder cluster(ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder taskDefinition(TaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public Builder containerOverrides(List<ContainerOverride> containerOverrides) {
            this.containerOverrides = containerOverrides;
            return this;
        }

        public Builder integrationPattern(ServiceIntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        public RunEcsEc2TaskProps build() {
            return new Jsii.Proxy(this.placementConstraints, this.placementStrategies, this.securityGroup, this.subnets, this.cluster, this.taskDefinition, this.containerOverrides, this.integrationPattern, null);
        }
    }
}

