package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Task to submits an AWS Batch job from a job definition.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.batch.*;
 * JobDefinition batchJobDefinition;
 * JobQueue batchQueue;
 * BatchSubmitJob task = BatchSubmitJob.Builder.create(this, "Submit Job")
 *         .jobDefinitionArn(batchJobDefinition.getJobDefinitionArn())
 *         .jobName("MyJob")
 *         .jobQueueArn(batchQueue.getJobQueueArn())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-batch.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-03-26T16:25:32.821Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.BatchSubmitJob")
public class BatchSubmitJob extends software.amazon.awscdk.services.stepfunctions.TaskStateBase {

    protected BatchSubmitJob(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BatchSubmitJob(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public BatchSubmitJob(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.BatchSubmitJobProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig getTaskMetrics() {
        return software.amazon.jsii.Kernel.get(this, "taskMetrics", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getTaskPolicies() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)(software.amazon.jsii.Kernel.get(this, "taskPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.BatchSubmitJob}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.tasks.BatchSubmitJob> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.stepfunctions.tasks.BatchSubmitJobProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.stepfunctions.tasks.BatchSubmitJobProps.Builder();
        }

        /**
         * An optional description for this state.
         * <p>
         * Default: - No comment
         * <p>
         * @return {@code this}
         * @param comment An optional description for this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * Timeout for the heartbeat.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param heartbeat Timeout for the heartbeat. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeat(final software.amazon.awscdk.core.Duration heartbeat) {
            this.props.heartbeat(heartbeat);
            return this;
        }

        /**
         * JSONPath expression to select part of the state to be the input to this state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * input to be the empty object {}.
         * <p>
         * Default: - The entire task input (JSON path '$')
         * <p>
         * @return {@code this}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(final java.lang.String inputPath) {
            this.props.inputPath(inputPath);
            return this;
        }

        /**
         * AWS Step Functions integrates with services directly in the Amazon States Language.
         * <p>
         * You can control these AWS services using service integration patterns
         * <p>
         * Default: IntegrationPattern.REQUEST_RESPONSE
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        /**
         * JSONPath expression to select select a portion of the state output to pass to the next state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * output to be the empty object {}.
         * <p>
         * Default: - The entire JSON node determined by the state input, the task result,
         * and resultPath is passed to the next state (JSON path '$')
         * <p>
         * @return {@code this}
         * @param outputPath JSONPath expression to select select a portion of the state output to pass to the next state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(final java.lang.String outputPath) {
            this.props.outputPath(outputPath);
            return this;
        }

        /**
         * JSONPath expression to indicate where to inject the state's output.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the state's
         * input to become its output.
         * <p>
         * Default: - Replaces the entire input with the result (JSON path '$')
         * <p>
         * @return {@code this}
         * @param resultPath JSONPath expression to indicate where to inject the state's output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(final java.lang.String resultPath) {
            this.props.resultPath(resultPath);
            return this;
        }

        /**
         * The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         * <p>
         * You can use ResultSelector to create a payload with values that are static
         * or selected from the state's raw result.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultSelector(final java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.props.resultSelector(resultSelector);
            return this;
        }

        /**
         * Timeout for the state machine.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param timeout Timeout for the state machine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.core.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * The arn of the job definition used by this job.
         * <p>
         * @return {@code this}
         * @param jobDefinitionArn The arn of the job definition used by this job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobDefinitionArn(final java.lang.String jobDefinitionArn) {
            this.props.jobDefinitionArn(jobDefinitionArn);
            return this;
        }

        /**
         * The name of the job.
         * <p>
         * The first character must be alphanumeric, and up to 128 letters (uppercase and lowercase),
         * numbers, hyphens, and underscores are allowed.
         * <p>
         * @return {@code this}
         * @param jobName The name of the job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobName(final java.lang.String jobName) {
            this.props.jobName(jobName);
            return this;
        }

        /**
         * The arn of the job queue into which the job is submitted.
         * <p>
         * @return {@code this}
         * @param jobQueueArn The arn of the job queue into which the job is submitted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobQueueArn(final java.lang.String jobQueueArn) {
            this.props.jobQueueArn(jobQueueArn);
            return this;
        }

        /**
         * The array size can be between 2 and 10,000.
         * <p>
         * If you specify array properties for a job, it becomes an array job.
         * For more information, see Array Jobs in the AWS Batch User Guide.
         * <p>
         * Default: - No array size
         * <p>
         * @return {@code this}
         * @param arraySize The array size can be between 2 and 10,000. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder arraySize(final java.lang.Number arraySize) {
            this.props.arraySize(arraySize);
            return this;
        }

        /**
         * The number of times to move a job to the RUNNABLE status.
         * <p>
         * You may specify between 1 and 10 attempts.
         * If the value of attempts is greater than one,
         * the job is retried on failure the same number of attempts as the value.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param attempts The number of times to move a job to the RUNNABLE status. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attempts(final java.lang.Number attempts) {
            this.props.attempts(attempts);
            return this;
        }

        /**
         * A list of container overrides in JSON format that specify the name of a container in the specified job definition and the overrides it should receive.
         * <p>
         * Default: - No container overrides
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/batch/latest/APIReference/API_SubmitJob.html#Batch-SubmitJob-request-containerOverrides
         * @param containerOverrides A list of container overrides in JSON format that specify the name of a container in the specified job definition and the overrides it should receive. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerOverrides(final software.amazon.awscdk.services.stepfunctions.tasks.BatchContainerOverrides containerOverrides) {
            this.props.containerOverrides(containerOverrides);
            return this;
        }

        /**
         * A list of dependencies for the job.
         * <p>
         * A job can depend upon a maximum of 20 jobs.
         * <p>
         * Default: - No dependencies
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/batch/latest/APIReference/API_SubmitJob.html#Batch-SubmitJob-request-dependsOn
         * @param dependsOn A list of dependencies for the job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dependsOn(final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.BatchJobDependency> dependsOn) {
            this.props.dependsOn(dependsOn);
            return this;
        }

        /**
         * The payload to be passed as parameters to the batch job.
         * <p>
         * Default: - No parameters are passed
         * <p>
         * @return {@code this}
         * @param payload The payload to be passed as parameters to the batch job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder payload(final software.amazon.awscdk.services.stepfunctions.TaskInput payload) {
            this.props.payload(payload);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.BatchSubmitJob}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.BatchSubmitJob build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.BatchSubmitJob(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
