package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * The information about job driver for Spark submit.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EmrContainersStartJobRun.Builder.create(this, "EMR Containers Start Job Run")
 *         .virtualCluster(VirtualClusterInput.fromVirtualClusterId("de92jdei2910fwedz"))
 *         .releaseLabel(ReleaseLabel.EMR_6_2_0)
 *         .jobName("EMR-Containers-Job")
 *         .jobDriver(JobDriver.builder()
 *                 .sparkSubmitJobDriver(SparkSubmitJobDriver.builder()
 *                         .entryPoint(TaskInput.fromText("local:///usr/lib/spark/examples/src/main/python/pi.py"))
 *                         .build())
 *                 .build())
 *         .applicationConfig(List.of(ApplicationConfiguration.builder()
 *                 .classification(Classification.SPARK_DEFAULTS)
 *                 .properties(Map.of(
 *                         "spark.executor.instances", "1",
 *                         "spark.executor.memory", "512M"))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-03-26T16:25:33.097Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.SparkSubmitJobDriver")
@software.amazon.jsii.Jsii.Proxy(SparkSubmitJobDriver.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SparkSubmitJobDriver extends software.amazon.jsii.JsiiSerializable {

    /**
     * The entry point of job application.
     * <p>
     * Length Constraints: Minimum length of 1. Maximum length of 256.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.TaskInput getEntryPoint();

    /**
     * The arguments for a job application in a task input object containing an array of strings.
     * <p>
     * Length Constraints: Minimum length of 1. Maximum length of 10280.
     * <p>
     * Default: - No arguments defined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskInput getEntryPointArguments() {
        return null;
    }

    /**
     * The Spark submit parameters that are used for job runs.
     * <p>
     * Length Constraints: Minimum length of 1. Maximum length of 102400.
     * <p>
     * Default: - No spark submit parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSparkSubmitParameters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SparkSubmitJobDriver}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SparkSubmitJobDriver}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SparkSubmitJobDriver> {
        software.amazon.awscdk.services.stepfunctions.TaskInput entryPoint;
        software.amazon.awscdk.services.stepfunctions.TaskInput entryPointArguments;
        java.lang.String sparkSubmitParameters;

        /**
         * Sets the value of {@link SparkSubmitJobDriver#getEntryPoint}
         * @param entryPoint The entry point of job application. This parameter is required.
         *                   Length Constraints: Minimum length of 1. Maximum length of 256.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entryPoint(software.amazon.awscdk.services.stepfunctions.TaskInput entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        /**
         * Sets the value of {@link SparkSubmitJobDriver#getEntryPointArguments}
         * @param entryPointArguments The arguments for a job application in a task input object containing an array of strings.
         *                            Length Constraints: Minimum length of 1. Maximum length of 10280.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entryPointArguments(software.amazon.awscdk.services.stepfunctions.TaskInput entryPointArguments) {
            this.entryPointArguments = entryPointArguments;
            return this;
        }

        /**
         * Sets the value of {@link SparkSubmitJobDriver#getSparkSubmitParameters}
         * @param sparkSubmitParameters The Spark submit parameters that are used for job runs.
         *                              Length Constraints: Minimum length of 1. Maximum length of 102400.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sparkSubmitParameters(java.lang.String sparkSubmitParameters) {
            this.sparkSubmitParameters = sparkSubmitParameters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SparkSubmitJobDriver}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SparkSubmitJobDriver build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SparkSubmitJobDriver}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SparkSubmitJobDriver {
        private final software.amazon.awscdk.services.stepfunctions.TaskInput entryPoint;
        private final software.amazon.awscdk.services.stepfunctions.TaskInput entryPointArguments;
        private final java.lang.String sparkSubmitParameters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.entryPoint = software.amazon.jsii.Kernel.get(this, "entryPoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class));
            this.entryPointArguments = software.amazon.jsii.Kernel.get(this, "entryPointArguments", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class));
            this.sparkSubmitParameters = software.amazon.jsii.Kernel.get(this, "sparkSubmitParameters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.entryPoint = java.util.Objects.requireNonNull(builder.entryPoint, "entryPoint is required");
            this.entryPointArguments = builder.entryPointArguments;
            this.sparkSubmitParameters = builder.sparkSubmitParameters;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.TaskInput getEntryPoint() {
            return this.entryPoint;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.TaskInput getEntryPointArguments() {
            return this.entryPointArguments;
        }

        @Override
        public final java.lang.String getSparkSubmitParameters() {
            return this.sparkSubmitParameters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("entryPoint", om.valueToTree(this.getEntryPoint()));
            if (this.getEntryPointArguments() != null) {
                data.set("entryPointArguments", om.valueToTree(this.getEntryPointArguments()));
            }
            if (this.getSparkSubmitParameters() != null) {
                data.set("sparkSubmitParameters", om.valueToTree(this.getSparkSubmitParameters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.SparkSubmitJobDriver"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SparkSubmitJobDriver.Jsii$Proxy that = (SparkSubmitJobDriver.Jsii$Proxy) o;

            if (!entryPoint.equals(that.entryPoint)) return false;
            if (this.entryPointArguments != null ? !this.entryPointArguments.equals(that.entryPointArguments) : that.entryPointArguments != null) return false;
            return this.sparkSubmitParameters != null ? this.sparkSubmitParameters.equals(that.sparkSubmitParameters) : that.sparkSubmitParameters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.entryPoint.hashCode();
            result = 31 * result + (this.entryPointArguments != null ? this.entryPointArguments.hashCode() : 0);
            result = 31 * result + (this.sparkSubmitParameters != null ? this.sparkSubmitParameters.hashCode() : 0);
            return result;
        }
    }
}
