package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Encryption Options of the S3 bucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * AthenaStartQueryExecution startQueryExecutionJob = AthenaStartQueryExecution.Builder.create(this, "Athena Start Query")
 *         .queryString(JsonPath.format("select contacts where year={};", JsonPath.stringAt("$.year")))
 *         .queryExecutionContext(QueryExecutionContext.builder()
 *                 .databaseName("interactions")
 *                 .build())
 *         .resultConfiguration(ResultConfiguration.builder()
 *                 .encryptionConfiguration(EncryptionConfiguration.builder()
 *                         .encryptionOption(EncryptionOption.S3_MANAGED)
 *                         .build())
 *                 .outputLocation(Location.builder()
 *                         .bucketName("mybucket")
 *                         .objectKey("myprefix")
 *                         .build())
 *                 .build())
 *         .integrationPattern(IntegrationPattern.RUN_JOB)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see https://docs.aws.amazon.com/athena/latest/APIReference/API_EncryptionConfiguration.html#athena-Type-EncryptionConfiguration-EncryptionOption
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-04-27T23:41:31.737Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EncryptionOption")
public enum EncryptionOption {
    /**
     * Server side encryption (SSE) with an Amazon S3-managed key.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    S3_MANAGED,
    /**
     * Server-side encryption (SSE) with an AWS KMS key managed by the account owner.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KMS,
    /**
     * Client-side encryption (CSE) with an AWS KMS key managed by the account owner.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CLIENT_SIDE_KMS,
}
