package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Specifies how many models the container hosts.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SageMakerCreateModel.Builder.create(this, "Sagemaker")
 *         .modelName("MyModel")
 *         .primaryContainer(ContainerDefinition.Builder.create()
 *                 .image(DockerImage.fromJsonExpression(JsonPath.stringAt("$.Model.imageName")))
 *                 .mode(Mode.SINGLE_MODEL)
 *                 .modelS3Location(S3Location.fromJsonExpression("$.TrainingJob.ModelArtifacts.S3ModelArtifacts"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-04-27T23:41:31.791Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.Mode")
public enum Mode {
    /**
     * Container hosts a single model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SINGLE_MODEL,
    /**
     * Container hosts multiple models.
     * <p>
     * @see https://docs.aws.amazon.com/sagemaker/latest/dg/multi-model-endpoints.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MULTI_MODEL,
}
