package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Configuration setting for monitoring.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EmrContainersStartJobRun.Builder.create(this, "EMR Containers Start Job Run")
 *         .virtualCluster(VirtualClusterInput.fromVirtualClusterId("de92jdei2910fwedz"))
 *         .releaseLabel(ReleaseLabel.EMR_6_2_0)
 *         .jobDriver(JobDriver.builder()
 *                 .sparkSubmitJobDriver(SparkSubmitJobDriver.builder()
 *                         .entryPoint(TaskInput.fromText("local:///usr/lib/spark/examples/src/main/python/pi.py"))
 *                         .sparkSubmitParameters("--conf spark.executor.instances=2 --conf spark.executor.memory=2G --conf spark.executor.cores=2 --conf spark.driver.cores=1")
 *                         .build())
 *                 .build())
 *         .monitoring(Monitoring.builder()
 *                 .logging(true)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-04-27T23:41:31.794Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.Monitoring")
@software.amazon.jsii.Jsii.Proxy(Monitoring.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Monitoring extends software.amazon.jsii.JsiiSerializable {

    /**
     * Amazon S3 Bucket for monitoring log publishing.
     * <p>
     * You can configure your jobs to send log information to Amazon S3.
     * <p>
     * Default: - if `logging` is manually set to `true` and a `logBucket` is not provided, a `logBucket` will be automatically generated`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getLogBucket() {
        return null;
    }

    /**
     * Enable logging for this job.
     * <p>
     * If set to true, will automatically create a Cloudwatch Log Group and S3 bucket.
     * This will be set to <code>true</code> implicitly if values are provided for <code>logGroup</code> or <code>logBucket</code>.
     * <p>
     * Default: true - true if values are provided for `logGroup` or `logBucket`, false otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getLogging() {
        return null;
    }

    /**
     * A log group for CloudWatch monitoring.
     * <p>
     * You can configure your jobs to send log information to CloudWatch Logs.
     * <p>
     * Default: - if `logging` is manually set to `true` and a `logGroup` is not provided, a `logGroup` will be automatically generated`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
        return null;
    }

    /**
     * A log stream name prefix for Cloudwatch monitoring.
     * <p>
     * Default: - Log streams created in this log group have no default prefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogStreamNamePrefix() {
        return null;
    }

    /**
     * Monitoring configurations for the persistent application UI.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPersistentAppUI() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Monitoring}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Monitoring}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<Monitoring> {
        software.amazon.awscdk.services.s3.IBucket logBucket;
        java.lang.Boolean logging;
        software.amazon.awscdk.services.logs.ILogGroup logGroup;
        java.lang.String logStreamNamePrefix;
        java.lang.Boolean persistentAppUi;

        /**
         * Sets the value of {@link Monitoring#getLogBucket}
         * @param logBucket Amazon S3 Bucket for monitoring log publishing.
         *                  You can configure your jobs to send log information to Amazon S3.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logBucket(software.amazon.awscdk.services.s3.IBucket logBucket) {
            this.logBucket = logBucket;
            return this;
        }

        /**
         * Sets the value of {@link Monitoring#getLogging}
         * @param logging Enable logging for this job.
         *                If set to true, will automatically create a Cloudwatch Log Group and S3 bucket.
         *                This will be set to <code>true</code> implicitly if values are provided for <code>logGroup</code> or <code>logBucket</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(java.lang.Boolean logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Sets the value of {@link Monitoring#getLogGroup}
         * @param logGroup A log group for CloudWatch monitoring.
         *                 You can configure your jobs to send log information to CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroup(software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        /**
         * Sets the value of {@link Monitoring#getLogStreamNamePrefix}
         * @param logStreamNamePrefix A log stream name prefix for Cloudwatch monitoring.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logStreamNamePrefix(java.lang.String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
            return this;
        }

        /**
         * Sets the value of {@link Monitoring#getPersistentAppUi}
         * @param persistentAppUi Monitoring configurations for the persistent application UI.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder persistentAppUi(java.lang.Boolean persistentAppUi) {
            this.persistentAppUi = persistentAppUi;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Monitoring}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public Monitoring build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Monitoring}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Monitoring {
        private final software.amazon.awscdk.services.s3.IBucket logBucket;
        private final java.lang.Boolean logging;
        private final software.amazon.awscdk.services.logs.ILogGroup logGroup;
        private final java.lang.String logStreamNamePrefix;
        private final java.lang.Boolean persistentAppUi;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.logBucket = software.amazon.jsii.Kernel.get(this, "logBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.logGroup = software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
            this.logStreamNamePrefix = software.amazon.jsii.Kernel.get(this, "logStreamNamePrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.persistentAppUi = software.amazon.jsii.Kernel.get(this, "persistentAppUI", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.logBucket = builder.logBucket;
            this.logging = builder.logging;
            this.logGroup = builder.logGroup;
            this.logStreamNamePrefix = builder.logStreamNamePrefix;
            this.persistentAppUi = builder.persistentAppUi;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getLogBucket() {
            return this.logBucket;
        }

        @Override
        public final java.lang.Boolean getLogging() {
            return this.logging;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
            return this.logGroup;
        }

        @Override
        public final java.lang.String getLogStreamNamePrefix() {
            return this.logStreamNamePrefix;
        }

        @Override
        public final java.lang.Boolean getPersistentAppUI() {
            return this.persistentAppUi;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getLogBucket() != null) {
                data.set("logBucket", om.valueToTree(this.getLogBucket()));
            }
            if (this.getLogging() != null) {
                data.set("logging", om.valueToTree(this.getLogging()));
            }
            if (this.getLogGroup() != null) {
                data.set("logGroup", om.valueToTree(this.getLogGroup()));
            }
            if (this.getLogStreamNamePrefix() != null) {
                data.set("logStreamNamePrefix", om.valueToTree(this.getLogStreamNamePrefix()));
            }
            if (this.getPersistentAppUI() != null) {
                data.set("persistentAppUI", om.valueToTree(this.getPersistentAppUI()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.Monitoring"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Monitoring.Jsii$Proxy that = (Monitoring.Jsii$Proxy) o;

            if (this.logBucket != null ? !this.logBucket.equals(that.logBucket) : that.logBucket != null) return false;
            if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
            if (this.logGroup != null ? !this.logGroup.equals(that.logGroup) : that.logGroup != null) return false;
            if (this.logStreamNamePrefix != null ? !this.logStreamNamePrefix.equals(that.logStreamNamePrefix) : that.logStreamNamePrefix != null) return false;
            return this.persistentAppUi != null ? this.persistentAppUi.equals(that.persistentAppUi) : that.persistentAppUi == null;
        }

        @Override
        public final int hashCode() {
            int result = this.logBucket != null ? this.logBucket.hashCode() : 0;
            result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
            result = 31 * result + (this.logGroup != null ? this.logGroup.hashCode() : 0);
            result = 31 * result + (this.logStreamNamePrefix != null ? this.logStreamNamePrefix.hashCode() : 0);
            result = 31 * result + (this.persistentAppUi != null ? this.persistentAppUi.hashCode() : 0);
            return result;
        }
    }
}
