package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * S3 location of the channel data.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SageMakerCreateTrainingJob.Builder.create(this, "TrainSagemaker")
 *         .trainingJobName(JsonPath.stringAt("$.JobName"))
 *         .algorithmSpecification(AlgorithmSpecification.builder()
 *                 .algorithmName("BlazingText")
 *                 .trainingInputMode(InputMode.FILE)
 *                 .build())
 *         .inputDataConfig(List.of(Channel.builder()
 *                 .channelName("train")
 *                 .dataSource(DataSource.builder()
 *                         .s3DataSource(S3DataSource.builder()
 *                                 .s3DataType(S3DataType.S3_PREFIX)
 *                                 .s3Location(S3Location.fromJsonExpression("$.S3Bucket"))
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .outputDataConfig(OutputDataConfig.builder()
 *                 .s3OutputLocation(S3Location.fromBucket(Bucket.fromBucketName(this, "Bucket", "mybucket"), "myoutputpath"))
 *                 .build())
 *         .resourceConfig(ResourceConfig.builder()
 *                 .instanceCount(1)
 *                 .instanceType(new InstanceType(JsonPath.stringAt("$.InstanceType")))
 *                 .volumeSize(Size.gibibytes(50))
 *                 .build()) // optional: default is 1 instance of EC2 `M4.XLarge` with `10GB` volume
 *         .stoppingCondition(StoppingCondition.builder()
 *                 .maxRuntime(Duration.hours(2))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_S3DataSource.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-04-27T23:41:31.824Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.S3DataSource")
@software.amazon.jsii.Jsii.Proxy(S3DataSource.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface S3DataSource extends software.amazon.jsii.JsiiSerializable {

    /**
     * S3 Uri.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.S3Location getS3Location();

    /**
     * List of one or more attribute names to use that are found in a specified augmented manifest file.
     * <p>
     * Default: - No attribute names
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAttributeNames() {
        return null;
    }

    /**
     * S3 Data Distribution Type.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.S3DataDistributionType getS3DataDistributionType() {
        return null;
    }

    /**
     * S3 Data Type.
     * <p>
     * Default: S3_PREFIX
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.S3DataType getS3DataType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link S3DataSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link S3DataSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<S3DataSource> {
        software.amazon.awscdk.services.stepfunctions.tasks.S3Location s3Location;
        java.util.List<java.lang.String> attributeNames;
        software.amazon.awscdk.services.stepfunctions.tasks.S3DataDistributionType s3DataDistributionType;
        software.amazon.awscdk.services.stepfunctions.tasks.S3DataType s3DataType;

        /**
         * Sets the value of {@link S3DataSource#getS3Location}
         * @param s3Location S3 Uri. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Location(software.amazon.awscdk.services.stepfunctions.tasks.S3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        /**
         * Sets the value of {@link S3DataSource#getAttributeNames}
         * @param attributeNames List of one or more attribute names to use that are found in a specified augmented manifest file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributeNames(java.util.List<java.lang.String> attributeNames) {
            this.attributeNames = attributeNames;
            return this;
        }

        /**
         * Sets the value of {@link S3DataSource#getS3DataDistributionType}
         * @param s3DataDistributionType S3 Data Distribution Type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3DataDistributionType(software.amazon.awscdk.services.stepfunctions.tasks.S3DataDistributionType s3DataDistributionType) {
            this.s3DataDistributionType = s3DataDistributionType;
            return this;
        }

        /**
         * Sets the value of {@link S3DataSource#getS3DataType}
         * @param s3DataType S3 Data Type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3DataType(software.amazon.awscdk.services.stepfunctions.tasks.S3DataType s3DataType) {
            this.s3DataType = s3DataType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3DataSource}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public S3DataSource build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link S3DataSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3DataSource {
        private final software.amazon.awscdk.services.stepfunctions.tasks.S3Location s3Location;
        private final java.util.List<java.lang.String> attributeNames;
        private final software.amazon.awscdk.services.stepfunctions.tasks.S3DataDistributionType s3DataDistributionType;
        private final software.amazon.awscdk.services.stepfunctions.tasks.S3DataType s3DataType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.s3Location = software.amazon.jsii.Kernel.get(this, "s3Location", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.S3Location.class));
            this.attributeNames = software.amazon.jsii.Kernel.get(this, "attributeNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.s3DataDistributionType = software.amazon.jsii.Kernel.get(this, "s3DataDistributionType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.S3DataDistributionType.class));
            this.s3DataType = software.amazon.jsii.Kernel.get(this, "s3DataType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.S3DataType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.s3Location = java.util.Objects.requireNonNull(builder.s3Location, "s3Location is required");
            this.attributeNames = builder.attributeNames;
            this.s3DataDistributionType = builder.s3DataDistributionType;
            this.s3DataType = builder.s3DataType;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.S3Location getS3Location() {
            return this.s3Location;
        }

        @Override
        public final java.util.List<java.lang.String> getAttributeNames() {
            return this.attributeNames;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.S3DataDistributionType getS3DataDistributionType() {
            return this.s3DataDistributionType;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.S3DataType getS3DataType() {
            return this.s3DataType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("s3Location", om.valueToTree(this.getS3Location()));
            if (this.getAttributeNames() != null) {
                data.set("attributeNames", om.valueToTree(this.getAttributeNames()));
            }
            if (this.getS3DataDistributionType() != null) {
                data.set("s3DataDistributionType", om.valueToTree(this.getS3DataDistributionType()));
            }
            if (this.getS3DataType() != null) {
                data.set("s3DataType", om.valueToTree(this.getS3DataType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.S3DataSource"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            S3DataSource.Jsii$Proxy that = (S3DataSource.Jsii$Proxy) o;

            if (!s3Location.equals(that.s3Location)) return false;
            if (this.attributeNames != null ? !this.attributeNames.equals(that.attributeNames) : that.attributeNames != null) return false;
            if (this.s3DataDistributionType != null ? !this.s3DataDistributionType.equals(that.s3DataDistributionType) : that.s3DataDistributionType != null) return false;
            return this.s3DataType != null ? this.s3DataType.equals(that.s3DataType) : that.s3DataType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.s3Location.hashCode();
            result = 31 * result + (this.attributeNames != null ? this.attributeNames.hashCode() : 0);
            result = 31 * result + (this.s3DataDistributionType != null ? this.s3DataDistributionType.hashCode() : 0);
            result = 31 * result + (this.s3DataType != null ? this.s3DataType.hashCode() : 0);
            return result;
        }
    }
}
