package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Method type of a EKS call.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.eks.*;
 * Cluster myEksCluster = Cluster.Builder.create(this, "my sample cluster")
 *         .version(KubernetesVersion.V1_18)
 *         .clusterName("myEksCluster")
 *         .build();
 * EksCall.Builder.create(this, "Call a EKS Endpoint")
 *         .cluster(myEksCluster)
 *         .httpMethod(HttpMethods.GET)
 *         .httpPath("/api/v1/namespaces/default/pods")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.62.0 (build 293ac17)", date = "2022-07-19T19:24:34.400Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.HttpMethods")
public enum HttpMethods {
    /**
     * Retrieve data from a server at the specified resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GET,
    /**
     * Send data to the API endpoint to create or update a resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    POST,
    /**
     * Send data to the API endpoint to update or create a resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PUT,
    /**
     * Delete the resource at the specified endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DELETE,
    /**
     * Apply partial modifications to the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PATCH,
    /**
     * Retrieve data from a server at the specified resource without the response body.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HEAD,
}
