package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Describes the training, validation or test dataset and the Amazon S3 location where it is stored.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:25.749Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.Channel")
@software.amazon.jsii.Jsii.Proxy(Channel.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface Channel extends software.amazon.jsii.JsiiSerializable {

    /**
     * Name of the channel.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getChannelName();

    /**
     * Location of the data channel.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.stepfunctions.tasks.DataSource getDataSource();

    /**
     * Compression type if training data is compressed.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default software.amazon.awscdk.services.stepfunctions.tasks.CompressionType getCompressionType() {
        return null;
    }

    /**
     * Content type.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default java.lang.String getContentType() {
        return null;
    }

    /**
     * Input mode to use for the data channel in a training job.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default software.amazon.awscdk.services.stepfunctions.tasks.InputMode getInputMode() {
        return null;
    }

    /**
     * Record wrapper type.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default software.amazon.awscdk.services.stepfunctions.tasks.RecordWrapperType getRecordWrapperType() {
        return null;
    }

    /**
     * Shuffle config option for input data in a channel.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default software.amazon.awscdk.services.stepfunctions.tasks.ShuffleConfig getShuffleConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Channel}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Channel}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private java.lang.String channelName;
        private software.amazon.awscdk.services.stepfunctions.tasks.DataSource dataSource;
        private software.amazon.awscdk.services.stepfunctions.tasks.CompressionType compressionType;
        private java.lang.String contentType;
        private software.amazon.awscdk.services.stepfunctions.tasks.InputMode inputMode;
        private software.amazon.awscdk.services.stepfunctions.tasks.RecordWrapperType recordWrapperType;
        private software.amazon.awscdk.services.stepfunctions.tasks.ShuffleConfig shuffleConfig;

        /**
         * Sets the value of ChannelName
         * @param channelName Name of the channel. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder channelName(java.lang.String channelName) {
            this.channelName = channelName;
            return this;
        }

        /**
         * Sets the value of DataSource
         * @param dataSource Location of the data channel. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dataSource(software.amazon.awscdk.services.stepfunctions.tasks.DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        /**
         * Sets the value of CompressionType
         * @param compressionType Compression type if training data is compressed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder compressionType(software.amazon.awscdk.services.stepfunctions.tasks.CompressionType compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        /**
         * Sets the value of ContentType
         * @param contentType Content type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder contentType(java.lang.String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Sets the value of InputMode
         * @param inputMode Input mode to use for the data channel in a training job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder inputMode(software.amazon.awscdk.services.stepfunctions.tasks.InputMode inputMode) {
            this.inputMode = inputMode;
            return this;
        }

        /**
         * Sets the value of RecordWrapperType
         * @param recordWrapperType Record wrapper type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder recordWrapperType(software.amazon.awscdk.services.stepfunctions.tasks.RecordWrapperType recordWrapperType) {
            this.recordWrapperType = recordWrapperType;
            return this;
        }

        /**
         * Sets the value of ShuffleConfig
         * @param shuffleConfig Shuffle config option for input data in a channel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder shuffleConfig(software.amazon.awscdk.services.stepfunctions.tasks.ShuffleConfig shuffleConfig) {
            this.shuffleConfig = shuffleConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Channel}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Channel build() {
            return new Jsii$Proxy(channelName, dataSource, compressionType, contentType, inputMode, recordWrapperType, shuffleConfig);
        }
    }

    /**
     * An implementation for {@link Channel}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Channel {
        private final java.lang.String channelName;
        private final software.amazon.awscdk.services.stepfunctions.tasks.DataSource dataSource;
        private final software.amazon.awscdk.services.stepfunctions.tasks.CompressionType compressionType;
        private final java.lang.String contentType;
        private final software.amazon.awscdk.services.stepfunctions.tasks.InputMode inputMode;
        private final software.amazon.awscdk.services.stepfunctions.tasks.RecordWrapperType recordWrapperType;
        private final software.amazon.awscdk.services.stepfunctions.tasks.ShuffleConfig shuffleConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.channelName = this.jsiiGet("channelName", java.lang.String.class);
            this.dataSource = this.jsiiGet("dataSource", software.amazon.awscdk.services.stepfunctions.tasks.DataSource.class);
            this.compressionType = this.jsiiGet("compressionType", software.amazon.awscdk.services.stepfunctions.tasks.CompressionType.class);
            this.contentType = this.jsiiGet("contentType", java.lang.String.class);
            this.inputMode = this.jsiiGet("inputMode", software.amazon.awscdk.services.stepfunctions.tasks.InputMode.class);
            this.recordWrapperType = this.jsiiGet("recordWrapperType", software.amazon.awscdk.services.stepfunctions.tasks.RecordWrapperType.class);
            this.shuffleConfig = this.jsiiGet("shuffleConfig", software.amazon.awscdk.services.stepfunctions.tasks.ShuffleConfig.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String channelName, final software.amazon.awscdk.services.stepfunctions.tasks.DataSource dataSource, final software.amazon.awscdk.services.stepfunctions.tasks.CompressionType compressionType, final java.lang.String contentType, final software.amazon.awscdk.services.stepfunctions.tasks.InputMode inputMode, final software.amazon.awscdk.services.stepfunctions.tasks.RecordWrapperType recordWrapperType, final software.amazon.awscdk.services.stepfunctions.tasks.ShuffleConfig shuffleConfig) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.channelName = java.util.Objects.requireNonNull(channelName, "channelName is required");
            this.dataSource = java.util.Objects.requireNonNull(dataSource, "dataSource is required");
            this.compressionType = compressionType;
            this.contentType = contentType;
            this.inputMode = inputMode;
            this.recordWrapperType = recordWrapperType;
            this.shuffleConfig = shuffleConfig;
        }

        @Override
        public java.lang.String getChannelName() {
            return this.channelName;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.DataSource getDataSource() {
            return this.dataSource;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.CompressionType getCompressionType() {
            return this.compressionType;
        }

        @Override
        public java.lang.String getContentType() {
            return this.contentType;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.InputMode getInputMode() {
            return this.inputMode;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.RecordWrapperType getRecordWrapperType() {
            return this.recordWrapperType;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.ShuffleConfig getShuffleConfig() {
            return this.shuffleConfig;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("channelName", om.valueToTree(this.getChannelName()));
            data.set("dataSource", om.valueToTree(this.getDataSource()));
            if (this.getCompressionType() != null) {
                data.set("compressionType", om.valueToTree(this.getCompressionType()));
            }
            if (this.getContentType() != null) {
                data.set("contentType", om.valueToTree(this.getContentType()));
            }
            if (this.getInputMode() != null) {
                data.set("inputMode", om.valueToTree(this.getInputMode()));
            }
            if (this.getRecordWrapperType() != null) {
                data.set("recordWrapperType", om.valueToTree(this.getRecordWrapperType()));
            }
            if (this.getShuffleConfig() != null) {
                data.set("shuffleConfig", om.valueToTree(this.getShuffleConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.Channel"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Channel.Jsii$Proxy that = (Channel.Jsii$Proxy) o;

            if (!channelName.equals(that.channelName)) return false;
            if (!dataSource.equals(that.dataSource)) return false;
            if (this.compressionType != null ? !this.compressionType.equals(that.compressionType) : that.compressionType != null) return false;
            if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) return false;
            if (this.inputMode != null ? !this.inputMode.equals(that.inputMode) : that.inputMode != null) return false;
            if (this.recordWrapperType != null ? !this.recordWrapperType.equals(that.recordWrapperType) : that.recordWrapperType != null) return false;
            return this.shuffleConfig != null ? this.shuffleConfig.equals(that.shuffleConfig) : that.shuffleConfig == null;
        }

        @Override
        public int hashCode() {
            int result = this.channelName.hashCode();
            result = 31 * result + (this.dataSource.hashCode());
            result = 31 * result + (this.compressionType != null ? this.compressionType.hashCode() : 0);
            result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
            result = 31 * result + (this.inputMode != null ? this.inputMode.hashCode() : 0);
            result = 31 * result + (this.recordWrapperType != null ? this.recordWrapperType.hashCode() : 0);
            result = 31 * result + (this.shuffleConfig != null ? this.shuffleConfig.hashCode() : 0);
            return result;
        }
    }
}
