package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * A Step Functions Task to invoke a Lambda function.
 * 
 * <p>The Lambda function Arn is defined as Resource in the state machine definition.</p>
 * <p>OUTPUT: the output of this task is the return value of the Lambda Function.</p>
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:25.750Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.InvokeFunction")
public class InvokeFunction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.IStepFunctionsTask {

    protected InvokeFunction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InvokeFunction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * 
     * @param lambdaFunction This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public InvokeFunction(final software.amazon.awscdk.services.lambda.IFunction lambdaFunction, final software.amazon.awscdk.services.stepfunctions.tasks.InvokeFunctionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(lambdaFunction, "lambdaFunction is required"), props });
    }

    /**
     * EXPERIMENTAL
     * 
     * @param lambdaFunction This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public InvokeFunction(final software.amazon.awscdk.services.lambda.IFunction lambdaFunction) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(lambdaFunction, "lambdaFunction is required") });
    }

    /**
     * Called when the task object is used in a workflow.
     * 
     * EXPERIMENTAL
     * 
     * @param _task This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig bind(final software.amazon.awscdk.services.stepfunctions.Task _task) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig.class, new Object[] { java.util.Objects.requireNonNull(_task, "_task is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.InvokeFunction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        /**
         * EXPERIMENTAL
         * 
         * @return a new instance of {@link Builder}.
         * @param lambdaFunction This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.services.lambda.IFunction lambdaFunction) {
            return new Builder(lambdaFunction);
        }

        private final software.amazon.awscdk.services.lambda.IFunction lambdaFunction;
        private software.amazon.awscdk.services.stepfunctions.tasks.InvokeFunctionProps.Builder props;

        private Builder(final software.amazon.awscdk.services.lambda.IFunction lambdaFunction) {
            this.lambdaFunction = lambdaFunction;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param payload The JSON that you want to provide to your Lambda function as input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder payload(final java.util.Map<java.lang.String, java.lang.Object> payload) {
            this.props().payload(payload);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.InvokeFunction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.stepfunctions.tasks.InvokeFunction build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.InvokeFunction(
                this.lambdaFunction,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.stepfunctions.tasks.InvokeFunctionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.stepfunctions.tasks.InvokeFunctionProps.Builder();
            }
            return this.props;
        }
    }
}
