package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * A Step Functions Task to publish messages to SNS topic.
 * 
 * <p>A Function can be used directly as a Resource, but this class mirrors
 * integration with other AWS services via a specific class instance.</p>
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:25.751Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.PublishToTopic")
public class PublishToTopic extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.IStepFunctionsTask {

    protected PublishToTopic(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PublishToTopic(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * 
     * @param topic This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public PublishToTopic(final software.amazon.awscdk.services.sns.ITopic topic, final software.amazon.awscdk.services.stepfunctions.tasks.PublishToTopicProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(topic, "topic is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Called when the task object is used in a workflow.
     * 
     * EXPERIMENTAL
     * 
     * @param _task This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig bind(final software.amazon.awscdk.services.stepfunctions.Task _task) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig.class, new Object[] { java.util.Objects.requireNonNull(_task, "_task is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.PublishToTopic}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        /**
         * EXPERIMENTAL
         * 
         * @return a new instance of {@link Builder}.
         * @param topic This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.services.sns.ITopic topic) {
            return new Builder(topic);
        }

        private final software.amazon.awscdk.services.sns.ITopic topic;
        private final software.amazon.awscdk.services.stepfunctions.tasks.PublishToTopicProps.Builder props;

        private Builder(final software.amazon.awscdk.services.sns.ITopic topic) {
            this.topic = topic;
            this.props = new software.amazon.awscdk.services.stepfunctions.tasks.PublishToTopicProps.Builder();
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param message The text message to send to the topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder message(final software.amazon.awscdk.services.stepfunctions.TaskInput message) {
            this.props.message(message);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param integrationPattern The service integration pattern indicates different ways to call Publish to SNS. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integrationPattern(final software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param messagePerSubscriptionType If true, send a different message to every subscription type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder messagePerSubscriptionType(final java.lang.Boolean messagePerSubscriptionType) {
            this.props.messagePerSubscriptionType(messagePerSubscriptionType);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param subject Message subject. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subject(final java.lang.String subject) {
            this.props.subject(subject);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.PublishToTopic}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.stepfunctions.tasks.PublishToTopic build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.PublishToTopic(
                this.topic,
                this.props.build()
            );
        }
    }
}
