package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Invoke a Lambda function as a Task.
 * 
 * <p>OUTPUT: the output of this task is either the return value of Lambda's
 * Invoke call, or whatever the Lambda Function posted back using
 * <code>SendTaskSuccess/SendTaskFailure</code> in <code>waitForTaskToken</code> mode.</p>
 * 
 * EXPERIMENTAL
 * 
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-lambda.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:25.752Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.RunLambdaTask")
public class RunLambdaTask extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.IStepFunctionsTask {

    protected RunLambdaTask(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RunLambdaTask(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * 
     * @param lambdaFunction This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public RunLambdaTask(final software.amazon.awscdk.services.lambda.IFunction lambdaFunction, final software.amazon.awscdk.services.stepfunctions.tasks.RunLambdaTaskProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(lambdaFunction, "lambdaFunction is required"), props });
    }

    /**
     * EXPERIMENTAL
     * 
     * @param lambdaFunction This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public RunLambdaTask(final software.amazon.awscdk.services.lambda.IFunction lambdaFunction) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(lambdaFunction, "lambdaFunction is required") });
    }

    /**
     * Called when the task object is used in a workflow.
     * 
     * EXPERIMENTAL
     * 
     * @param _task This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig bind(final software.amazon.awscdk.services.stepfunctions.Task _task) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig.class, new Object[] { java.util.Objects.requireNonNull(_task, "_task is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.RunLambdaTask}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        /**
         * EXPERIMENTAL
         * 
         * @return a new instance of {@link Builder}.
         * @param lambdaFunction This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.services.lambda.IFunction lambdaFunction) {
            return new Builder(lambdaFunction);
        }

        private final software.amazon.awscdk.services.lambda.IFunction lambdaFunction;
        private software.amazon.awscdk.services.stepfunctions.tasks.RunLambdaTaskProps.Builder props;

        private Builder(final software.amazon.awscdk.services.lambda.IFunction lambdaFunction) {
            this.lambdaFunction = lambdaFunction;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param clientContext Client context to pass to the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clientContext(final java.lang.String clientContext) {
            this.props().clientContext(clientContext);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param integrationPattern The service integration pattern indicates different ways to invoke Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integrationPattern(final software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern) {
            this.props().integrationPattern(integrationPattern);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param invocationType Invocation type of the Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder invocationType(final software.amazon.awscdk.services.stepfunctions.tasks.InvocationType invocationType) {
            this.props().invocationType(invocationType);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param payload The JSON that you want to provide to your Lambda function as input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder payload(final java.util.Map<java.lang.String, java.lang.Object> payload) {
            this.props().payload(payload);
            return this;
        }

        /**
         * EXPERIMENTAL
         * 
         * @return {@code this}
         * @param qualifier Version or alias of the function to be invoked. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder qualifier(final java.lang.String qualifier) {
            this.props().qualifier(qualifier);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.RunLambdaTask}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.stepfunctions.tasks.RunLambdaTask build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.RunLambdaTask(
                this.lambdaFunction,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.stepfunctions.tasks.RunLambdaTaskProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.stepfunctions.tasks.RunLambdaTaskProps.Builder();
            }
            return this.props;
        }
    }
}
