package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Dataset to be transformed and the Amazon S3 location where it is stored.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:25.755Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.TransformInput")
@software.amazon.jsii.Jsii.Proxy(TransformInput.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface TransformInput extends software.amazon.jsii.JsiiSerializable {

    /**
     * S3 location of the channel data.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource getTransformDataSource();

    /**
     * The compression type of the transform data.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default software.amazon.awscdk.services.stepfunctions.tasks.CompressionType getCompressionType() {
        return null;
    }

    /**
     * Multipurpose internet mail extension (MIME) type of the data.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default java.lang.String getContentType() {
        return null;
    }

    /**
     * Method to use to split the transform job's data files into smaller batches.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default software.amazon.awscdk.services.stepfunctions.tasks.SplitType getSplitType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TransformInput}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TransformInput}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource transformDataSource;
        private software.amazon.awscdk.services.stepfunctions.tasks.CompressionType compressionType;
        private java.lang.String contentType;
        private software.amazon.awscdk.services.stepfunctions.tasks.SplitType splitType;

        /**
         * Sets the value of TransformDataSource
         * @param transformDataSource S3 location of the channel data. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder transformDataSource(software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource transformDataSource) {
            this.transformDataSource = transformDataSource;
            return this;
        }

        /**
         * Sets the value of CompressionType
         * @param compressionType The compression type of the transform data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder compressionType(software.amazon.awscdk.services.stepfunctions.tasks.CompressionType compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        /**
         * Sets the value of ContentType
         * @param contentType Multipurpose internet mail extension (MIME) type of the data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder contentType(java.lang.String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Sets the value of SplitType
         * @param splitType Method to use to split the transform job's data files into smaller batches.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder splitType(software.amazon.awscdk.services.stepfunctions.tasks.SplitType splitType) {
            this.splitType = splitType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TransformInput}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public TransformInput build() {
            return new Jsii$Proxy(transformDataSource, compressionType, contentType, splitType);
        }
    }

    /**
     * An implementation for {@link TransformInput}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransformInput {
        private final software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource transformDataSource;
        private final software.amazon.awscdk.services.stepfunctions.tasks.CompressionType compressionType;
        private final java.lang.String contentType;
        private final software.amazon.awscdk.services.stepfunctions.tasks.SplitType splitType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.transformDataSource = this.jsiiGet("transformDataSource", software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource.class);
            this.compressionType = this.jsiiGet("compressionType", software.amazon.awscdk.services.stepfunctions.tasks.CompressionType.class);
            this.contentType = this.jsiiGet("contentType", java.lang.String.class);
            this.splitType = this.jsiiGet("splitType", software.amazon.awscdk.services.stepfunctions.tasks.SplitType.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource transformDataSource, final software.amazon.awscdk.services.stepfunctions.tasks.CompressionType compressionType, final java.lang.String contentType, final software.amazon.awscdk.services.stepfunctions.tasks.SplitType splitType) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.transformDataSource = java.util.Objects.requireNonNull(transformDataSource, "transformDataSource is required");
            this.compressionType = compressionType;
            this.contentType = contentType;
            this.splitType = splitType;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource getTransformDataSource() {
            return this.transformDataSource;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.CompressionType getCompressionType() {
            return this.compressionType;
        }

        @Override
        public java.lang.String getContentType() {
            return this.contentType;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.SplitType getSplitType() {
            return this.splitType;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("transformDataSource", om.valueToTree(this.getTransformDataSource()));
            if (this.getCompressionType() != null) {
                data.set("compressionType", om.valueToTree(this.getCompressionType()));
            }
            if (this.getContentType() != null) {
                data.set("contentType", om.valueToTree(this.getContentType()));
            }
            if (this.getSplitType() != null) {
                data.set("splitType", om.valueToTree(this.getSplitType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.TransformInput"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TransformInput.Jsii$Proxy that = (TransformInput.Jsii$Proxy) o;

            if (!transformDataSource.equals(that.transformDataSource)) return false;
            if (this.compressionType != null ? !this.compressionType.equals(that.compressionType) : that.compressionType != null) return false;
            if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) return false;
            return this.splitType != null ? this.splitType.equals(that.splitType) : that.splitType == null;
        }

        @Override
        public int hashCode() {
            int result = this.transformDataSource.hashCode();
            result = 31 * result + (this.compressionType != null ? this.compressionType.hashCode() : 0);
            result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
            result = 31 * result + (this.splitType != null ? this.splitType.hashCode() : 0);
            return result;
        }
    }
}
