package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * S3 location where you want Amazon SageMaker to save the results from the transform job.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.8 (build bd5ef4d)", date = "2019-11-25T14:22:25.755Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.TransformOutput")
@software.amazon.jsii.Jsii.Proxy(TransformOutput.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface TransformOutput extends software.amazon.jsii.JsiiSerializable {

    /**
     * S3 path where you want Amazon SageMaker to store the results of the transform job.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getS3OutputPath();

    /**
     * MIME type used to specify the output data.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default java.lang.String getAccept() {
        return null;
    }

    /**
     * Defines how to assemble the results of the transform job as a single S3 object.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default software.amazon.awscdk.services.stepfunctions.tasks.AssembleWith getAssembleWith() {
        return null;
    }

    /**
     * AWS KMS key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default software.amazon.awscdk.services.kms.Key getEncryptionKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TransformOutput}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TransformOutput}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private java.lang.String s3OutputPath;
        private java.lang.String accept;
        private software.amazon.awscdk.services.stepfunctions.tasks.AssembleWith assembleWith;
        private software.amazon.awscdk.services.kms.Key encryptionKey;

        /**
         * Sets the value of S3OutputPath
         * @param s3OutputPath S3 path where you want Amazon SageMaker to store the results of the transform job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3OutputPath(java.lang.String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
            return this;
        }

        /**
         * Sets the value of Accept
         * @param accept MIME type used to specify the output data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accept(java.lang.String accept) {
            this.accept = accept;
            return this;
        }

        /**
         * Sets the value of AssembleWith
         * @param assembleWith Defines how to assemble the results of the transform job as a single S3 object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assembleWith(software.amazon.awscdk.services.stepfunctions.tasks.AssembleWith assembleWith) {
            this.assembleWith = assembleWith;
            return this;
        }

        /**
         * Sets the value of EncryptionKey
         * @param encryptionKey AWS KMS key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.Key encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TransformOutput}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public TransformOutput build() {
            return new Jsii$Proxy(s3OutputPath, accept, assembleWith, encryptionKey);
        }
    }

    /**
     * An implementation for {@link TransformOutput}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransformOutput {
        private final java.lang.String s3OutputPath;
        private final java.lang.String accept;
        private final software.amazon.awscdk.services.stepfunctions.tasks.AssembleWith assembleWith;
        private final software.amazon.awscdk.services.kms.Key encryptionKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.s3OutputPath = this.jsiiGet("s3OutputPath", java.lang.String.class);
            this.accept = this.jsiiGet("accept", java.lang.String.class);
            this.assembleWith = this.jsiiGet("assembleWith", software.amazon.awscdk.services.stepfunctions.tasks.AssembleWith.class);
            this.encryptionKey = this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.Key.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String s3OutputPath, final java.lang.String accept, final software.amazon.awscdk.services.stepfunctions.tasks.AssembleWith assembleWith, final software.amazon.awscdk.services.kms.Key encryptionKey) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.s3OutputPath = java.util.Objects.requireNonNull(s3OutputPath, "s3OutputPath is required");
            this.accept = accept;
            this.assembleWith = assembleWith;
            this.encryptionKey = encryptionKey;
        }

        @Override
        public java.lang.String getS3OutputPath() {
            return this.s3OutputPath;
        }

        @Override
        public java.lang.String getAccept() {
            return this.accept;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.AssembleWith getAssembleWith() {
            return this.assembleWith;
        }

        @Override
        public software.amazon.awscdk.services.kms.Key getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("s3OutputPath", om.valueToTree(this.getS3OutputPath()));
            if (this.getAccept() != null) {
                data.set("accept", om.valueToTree(this.getAccept()));
            }
            if (this.getAssembleWith() != null) {
                data.set("assembleWith", om.valueToTree(this.getAssembleWith()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.TransformOutput"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TransformOutput.Jsii$Proxy that = (TransformOutput.Jsii$Proxy) o;

            if (!s3OutputPath.equals(that.s3OutputPath)) return false;
            if (this.accept != null ? !this.accept.equals(that.accept) : that.accept != null) return false;
            if (this.assembleWith != null ? !this.assembleWith.equals(that.assembleWith) : that.assembleWith != null) return false;
            return this.encryptionKey != null ? this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey == null;
        }

        @Override
        public int hashCode() {
            int result = this.s3OutputPath.hashCode();
            result = 31 * result + (this.accept != null ? this.accept.hashCode() : 0);
            result = 31 * result + (this.assembleWith != null ? this.assembleWith.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            return result;
        }
    }
}
