/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import java.util.Objects;
import software.amazon.awscdk.services.sns.ITopic;
import software.amazon.awscdk.services.stepfunctions.IStepFunctionsTask;
import software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig;
import software.amazon.awscdk.services.stepfunctions.Task;
import software.amazon.awscdk.services.stepfunctions.TaskInput;
import software.amazon.awscdk.services.stepfunctions.tasks.;
import software.amazon.awscdk.services.stepfunctions.tasks.PublishToTopicProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.PublishToTopic")
public class PublishToTopic
extends JsiiObject
implements IStepFunctionsTask {
    protected PublishToTopic(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PublishToTopic(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public PublishToTopic(ITopic topic, PublishToTopicProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(topic, "topic is required"), Objects.requireNonNull(props, "props is required")});
    }

    public StepFunctionsTaskConfig bind(Task _task) {
        return (StepFunctionsTaskConfig)this.jsiiCall("bind", StepFunctionsTaskConfig.class, new Object[]{Objects.requireNonNull(_task, "_task is required")});
    }

    public static final class Builder {
        private final ITopic topic;
        private final PublishToTopicProps.Builder props;

        public static Builder create(ITopic topic) {
            return new Builder(topic);
        }

        private Builder(ITopic topic) {
            this.topic = topic;
            this.props = new PublishToTopicProps.Builder();
        }

        public Builder message(TaskInput message) {
            this.props.message(message);
            return this;
        }

        public Builder integrationPattern(ServiceIntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        public Builder messagePerSubscriptionType(Boolean messagePerSubscriptionType) {
            this.props.messagePerSubscriptionType(messagePerSubscriptionType);
            return this;
        }

        public Builder subject(String subject) {
            this.props.subject(subject);
            return this;
        }

        public PublishToTopic build() {
            return new PublishToTopic(this.topic, this.props.build());
        }
    }
}

