package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * The overrides that should be sent to a container.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.3.0 (build 8ae966b)", date = "2020-04-17T19:11:37.877Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.ContainerOverrides")
@software.amazon.jsii.Jsii.Proxy(ContainerOverrides.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ContainerOverrides extends software.amazon.jsii.JsiiSerializable {

    /**
     * The command to send to the container that overrides the default command from the Docker image or the job definition.
     * <p>
     * Default: - No command overrides
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
        return null;
    }

    /**
     * The environment variables to send to the container.
     * <p>
     * You can add new environment variables, which are added to the container
     * at launch, or you can override the existing environment variables from
     * the Docker image or the job definition.
     * <p>
     * Default: - No environment overrides
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return null;
    }

    /**
     * The number of physical GPUs to reserve for the container.
     * <p>
     * The number of GPUs reserved for all containers in a job
     * should not exceed the number of available GPUs on the compute
     * resource that the job is launched on.
     * <p>
     * Default: - No GPU reservation
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getGpuCount() {
        return null;
    }

    /**
     * The instance type to use for a multi-node parallel job.
     * <p>
     * This parameter is not valid for single-node container jobs.
     * <p>
     * Default: - No instance type overrides
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
        return null;
    }

    /**
     * The number of MiB of memory reserved for the job.
     * <p>
     * This value overrides the value set in the job definition.
     * <p>
     * Default: - No memory overrides
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMemory() {
        return null;
    }

    /**
     * The number of vCPUs to reserve for the container.
     * <p>
     * This value overrides the value set in the job definition.
     * <p>
     * Default: - No vCPUs overrides
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getVcpus() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ContainerOverrides}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ContainerOverrides}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private java.util.List<java.lang.String> command;
        private java.util.Map<java.lang.String, java.lang.String> environment;
        private java.lang.Number gpuCount;
        private software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private java.lang.Number memory;
        private java.lang.Number vcpus;

        /**
         * Sets the value of {@link ContainerOverrides#getCommand}
         * @param command The command to send to the container that overrides the default command from the Docker image or the job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link ContainerOverrides#getEnvironment}
         * @param environment The environment variables to send to the container.
         *                    You can add new environment variables, which are added to the container
         *                    at launch, or you can override the existing environment variables from
         *                    the Docker image or the job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link ContainerOverrides#getGpuCount}
         * @param gpuCount The number of physical GPUs to reserve for the container.
         *                 The number of GPUs reserved for all containers in a job
         *                 should not exceed the number of available GPUs on the compute
         *                 resource that the job is launched on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder gpuCount(java.lang.Number gpuCount) {
            this.gpuCount = gpuCount;
            return this;
        }

        /**
         * Sets the value of {@link ContainerOverrides#getInstanceType}
         * @param instanceType The instance type to use for a multi-node parallel job.
         *                     This parameter is not valid for single-node container jobs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link ContainerOverrides#getMemory}
         * @param memory The number of MiB of memory reserved for the job.
         *               This value overrides the value set in the job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder memory(java.lang.Number memory) {
            this.memory = memory;
            return this;
        }

        /**
         * Sets the value of {@link ContainerOverrides#getVcpus}
         * @param vcpus The number of vCPUs to reserve for the container.
         *              This value overrides the value set in the job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vcpus(java.lang.Number vcpus) {
            this.vcpus = vcpus;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ContainerOverrides}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public ContainerOverrides build() {
            return new Jsii$Proxy(command, environment, gpuCount, instanceType, memory, vcpus);
        }
    }

    /**
     * An implementation for {@link ContainerOverrides}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerOverrides {
        private final java.util.List<java.lang.String> command;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final java.lang.Number gpuCount;
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final java.lang.Number memory;
        private final java.lang.Number vcpus;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.command = this.jsiiGet("command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environment = this.jsiiGet("environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.gpuCount = this.jsiiGet("gpuCount", java.lang.Number.class);
            this.instanceType = this.jsiiGet("instanceType", software.amazon.awscdk.services.ec2.InstanceType.class);
            this.memory = this.jsiiGet("memory", java.lang.Number.class);
            this.vcpus = this.jsiiGet("vcpus", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.List<java.lang.String> command, final java.util.Map<java.lang.String, java.lang.String> environment, final java.lang.Number gpuCount, final software.amazon.awscdk.services.ec2.InstanceType instanceType, final java.lang.Number memory, final java.lang.Number vcpus) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.command = command;
            this.environment = environment;
            this.gpuCount = gpuCount;
            this.instanceType = instanceType;
            this.memory = memory;
            this.vcpus = vcpus;
        }

        @Override
        public java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public java.lang.Number getGpuCount() {
            return this.gpuCount;
        }

        @Override
        public software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public java.lang.Number getMemory() {
            return this.memory;
        }

        @Override
        public java.lang.Number getVcpus() {
            return this.vcpus;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getGpuCount() != null) {
                data.set("gpuCount", om.valueToTree(this.getGpuCount()));
            }
            if (this.getInstanceType() != null) {
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
            }
            if (this.getMemory() != null) {
                data.set("memory", om.valueToTree(this.getMemory()));
            }
            if (this.getVcpus() != null) {
                data.set("vcpus", om.valueToTree(this.getVcpus()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.ContainerOverrides"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ContainerOverrides.Jsii$Proxy that = (ContainerOverrides.Jsii$Proxy) o;

            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.gpuCount != null ? !this.gpuCount.equals(that.gpuCount) : that.gpuCount != null) return false;
            if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
            if (this.memory != null ? !this.memory.equals(that.memory) : that.memory != null) return false;
            return this.vcpus != null ? this.vcpus.equals(that.vcpus) : that.vcpus == null;
        }

        @Override
        public int hashCode() {
            int result = this.command != null ? this.command.hashCode() : 0;
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.gpuCount != null ? this.gpuCount.hashCode() : 0);
            result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
            result = 31 * result + (this.memory != null ? this.memory.hashCode() : 0);
            result = 31 * result + (this.vcpus != null ? this.vcpus.hashCode() : 0);
            return result;
        }
    }
}
