package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for DynamoGetItem Task.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.3.0 (build 8ae966b)", date = "2020-04-17T19:11:37.881Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.DynamoGetItemProps")
@software.amazon.jsii.Jsii.Proxy(DynamoGetItemProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DynamoGetItemProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A attribute representing the partition key of the item to retrieve.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_GetItem.html#DDB-GetItem-request-Key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute getPartitionKey();

    /**
     * The name of the table containing the requested item.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getTableName();

    /**
     * Determines the read consistency model: If set to true, then the operation uses strongly consistent reads;
     * <p>
     * otherwise, the operation uses eventually consistent reads.
     * <p>
     * Default: false
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getConsistentRead() {
        return null;
    }

    /**
     * One or more substitution tokens for attribute names in an expression.
     * <p>
     * Default: - No expression attributes
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_GetItem.html#DDB-GetItem-request-ExpressionAttributeNames
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getExpressionAttributeNames() {
        return null;
    }

    /**
     * An array of DynamoProjectionExpression that identifies one or more attributes to retrieve from the table.
     * <p>
     * These attributes can include scalars, sets, or elements of a JSON document.
     * <p>
     * Default: - No projection expression
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_GetItem.html#DDB-GetItem-request-ProjectionExpression
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.DynamoProjectionExpression> getProjectionExpression() {
        return null;
    }

    /**
     * Determines the level of detail about provisioned throughput consumption that is returned in the response.
     * <p>
     * Default: DynamoConsumedCapacity.NONE
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_GetItem.html#DDB-GetItem-request-ReturnConsumedCapacity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity getReturnConsumedCapacity() {
        return null;
    }

    /**
     * A attribute representing the sort key of the item to retrieve.
     * <p>
     * Default: - No sort key
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_GetItem.html#DDB-GetItem-request-Key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute getSortKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DynamoGetItemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DynamoGetItemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute partitionKey;
        private java.lang.String tableName;
        private java.lang.Boolean consistentRead;
        private java.util.Map<java.lang.String, java.lang.String> expressionAttributeNames;
        private java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.DynamoProjectionExpression> projectionExpression;
        private software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity returnConsumedCapacity;
        private software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute sortKey;

        /**
         * Sets the value of {@link DynamoGetItemProps#getPartitionKey}
         * @param partitionKey A attribute representing the partition key of the item to retrieve. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder partitionKey(software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        /**
         * Sets the value of {@link DynamoGetItemProps#getTableName}
         * @param tableName The name of the table containing the requested item. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Sets the value of {@link DynamoGetItemProps#getConsistentRead}
         * @param consistentRead Determines the read consistency model: If set to true, then the operation uses strongly consistent reads;.
         *                       otherwise, the operation uses eventually consistent reads.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder consistentRead(java.lang.Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        /**
         * Sets the value of {@link DynamoGetItemProps#getExpressionAttributeNames}
         * @param expressionAttributeNames One or more substitution tokens for attribute names in an expression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder expressionAttributeNames(java.util.Map<java.lang.String, java.lang.String> expressionAttributeNames) {
            this.expressionAttributeNames = expressionAttributeNames;
            return this;
        }

        /**
         * Sets the value of {@link DynamoGetItemProps#getProjectionExpression}
         * @param projectionExpression An array of DynamoProjectionExpression that identifies one or more attributes to retrieve from the table.
         *                             These attributes can include scalars, sets, or elements of a JSON document.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder projectionExpression(java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.DynamoProjectionExpression> projectionExpression) {
            this.projectionExpression = projectionExpression;
            return this;
        }

        /**
         * Sets the value of {@link DynamoGetItemProps#getReturnConsumedCapacity}
         * @param returnConsumedCapacity Determines the level of detail about provisioned throughput consumption that is returned in the response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder returnConsumedCapacity(software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        /**
         * Sets the value of {@link DynamoGetItemProps#getSortKey}
         * @param sortKey A attribute representing the sort key of the item to retrieve.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sortKey(software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute sortKey) {
            this.sortKey = sortKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DynamoGetItemProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public DynamoGetItemProps build() {
            return new Jsii$Proxy(partitionKey, tableName, consistentRead, expressionAttributeNames, projectionExpression, returnConsumedCapacity, sortKey);
        }
    }

    /**
     * An implementation for {@link DynamoGetItemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamoGetItemProps {
        private final software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute partitionKey;
        private final java.lang.String tableName;
        private final java.lang.Boolean consistentRead;
        private final java.util.Map<java.lang.String, java.lang.String> expressionAttributeNames;
        private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.DynamoProjectionExpression> projectionExpression;
        private final software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity returnConsumedCapacity;
        private final software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute sortKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.partitionKey = this.jsiiGet("partitionKey", software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute.class);
            this.tableName = this.jsiiGet("tableName", java.lang.String.class);
            this.consistentRead = this.jsiiGet("consistentRead", java.lang.Boolean.class);
            this.expressionAttributeNames = this.jsiiGet("expressionAttributeNames", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.projectionExpression = this.jsiiGet("projectionExpression", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DynamoProjectionExpression.class)));
            this.returnConsumedCapacity = this.jsiiGet("returnConsumedCapacity", software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity.class);
            this.sortKey = this.jsiiGet("sortKey", software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute partitionKey, final java.lang.String tableName, final java.lang.Boolean consistentRead, final java.util.Map<java.lang.String, java.lang.String> expressionAttributeNames, final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.DynamoProjectionExpression> projectionExpression, final software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity returnConsumedCapacity, final software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute sortKey) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.partitionKey = java.util.Objects.requireNonNull(partitionKey, "partitionKey is required");
            this.tableName = java.util.Objects.requireNonNull(tableName, "tableName is required");
            this.consistentRead = consistentRead;
            this.expressionAttributeNames = expressionAttributeNames;
            this.projectionExpression = projectionExpression;
            this.returnConsumedCapacity = returnConsumedCapacity;
            this.sortKey = sortKey;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute getPartitionKey() {
            return this.partitionKey;
        }

        @Override
        public java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        public java.lang.Boolean getConsistentRead() {
            return this.consistentRead;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getExpressionAttributeNames() {
            return this.expressionAttributeNames;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.DynamoProjectionExpression> getProjectionExpression() {
            return this.projectionExpression;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute getSortKey() {
            return this.sortKey;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("partitionKey", om.valueToTree(this.getPartitionKey()));
            data.set("tableName", om.valueToTree(this.getTableName()));
            if (this.getConsistentRead() != null) {
                data.set("consistentRead", om.valueToTree(this.getConsistentRead()));
            }
            if (this.getExpressionAttributeNames() != null) {
                data.set("expressionAttributeNames", om.valueToTree(this.getExpressionAttributeNames()));
            }
            if (this.getProjectionExpression() != null) {
                data.set("projectionExpression", om.valueToTree(this.getProjectionExpression()));
            }
            if (this.getReturnConsumedCapacity() != null) {
                data.set("returnConsumedCapacity", om.valueToTree(this.getReturnConsumedCapacity()));
            }
            if (this.getSortKey() != null) {
                data.set("sortKey", om.valueToTree(this.getSortKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.DynamoGetItemProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DynamoGetItemProps.Jsii$Proxy that = (DynamoGetItemProps.Jsii$Proxy) o;

            if (!partitionKey.equals(that.partitionKey)) return false;
            if (!tableName.equals(that.tableName)) return false;
            if (this.consistentRead != null ? !this.consistentRead.equals(that.consistentRead) : that.consistentRead != null) return false;
            if (this.expressionAttributeNames != null ? !this.expressionAttributeNames.equals(that.expressionAttributeNames) : that.expressionAttributeNames != null) return false;
            if (this.projectionExpression != null ? !this.projectionExpression.equals(that.projectionExpression) : that.projectionExpression != null) return false;
            if (this.returnConsumedCapacity != null ? !this.returnConsumedCapacity.equals(that.returnConsumedCapacity) : that.returnConsumedCapacity != null) return false;
            return this.sortKey != null ? this.sortKey.equals(that.sortKey) : that.sortKey == null;
        }

        @Override
        public int hashCode() {
            int result = this.partitionKey.hashCode();
            result = 31 * result + (this.tableName.hashCode());
            result = 31 * result + (this.consistentRead != null ? this.consistentRead.hashCode() : 0);
            result = 31 * result + (this.expressionAttributeNames != null ? this.expressionAttributeNames.hashCode() : 0);
            result = 31 * result + (this.projectionExpression != null ? this.projectionExpression.hashCode() : 0);
            result = 31 * result + (this.returnConsumedCapacity != null ? this.returnConsumedCapacity.hashCode() : 0);
            result = 31 * result + (this.sortKey != null ? this.sortKey.hashCode() : 0);
            return result;
        }
    }
}
