package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for DynamoUpdateItem Task.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.3.0 (build 8ae966b)", date = "2020-04-17T19:11:37.883Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.DynamoUpdateItemProps")
@software.amazon.jsii.Jsii.Proxy(DynamoUpdateItemProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DynamoUpdateItemProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The partition key of the item to be updated.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateItem.html#DDB-UpdateItem-request-Key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute getPartitionKey();

    /**
     * The name of the table containing the requested item.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getTableName();

    /**
     * A condition that must be satisfied in order for a conditional DeleteItem to succeed.
     * <p>
     * Default: - No condition expression
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateItem.html#DDB-UpdateItem-request-ConditionExpression
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getConditionExpression() {
        return null;
    }

    /**
     * One or more substitution tokens for attribute names in an expression.
     * <p>
     * Default: - No expression attribute names
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateItem.html#DDB-UpdateItem-request-ExpressionAttributeNames
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getExpressionAttributeNames() {
        return null;
    }

    /**
     * One or more values that can be substituted in an expression.
     * <p>
     * Default: - No expression attribute values
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateItem.html#DDB-UpdateItem-request-ExpressionAttributeValues
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValueMap getExpressionAttributeValues() {
        return null;
    }

    /**
     * Determines the level of detail about provisioned throughput consumption that is returned in the response.
     * <p>
     * Default: DynamoConsumedCapacity.NONE
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateItem.html#DDB-UpdateItem-request-ReturnConsumedCapacity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity getReturnConsumedCapacity() {
        return null;
    }

    /**
     * Determines whether item collection metrics are returned.
     * <p>
     * If set to SIZE, the response includes statistics about item collections, if any,
     * that were modified during the operation are returned in the response.
     * If set to NONE (the default), no statistics are returned.
     * <p>
     * Default: DynamoItemCollectionMetrics.NONE
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics getReturnItemCollectionMetrics() {
        return null;
    }

    /**
     * Use ReturnValues if you want to get the item attributes as they appeared before they were deleted.
     * <p>
     * Default: DynamoReturnValues.NONE
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateItem.html#DDB-UpdateItem-request-ReturnValues
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues getReturnValues() {
        return null;
    }

    /**
     * The sort key of the item to be updated.
     * <p>
     * Default: - No sort key
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateItem.html#DDB-UpdateItem-request-Key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute getSortKey() {
        return null;
    }

    /**
     * An expression that defines one or more attributes to be updated, the action to be performed on them, and new values for them.
     * <p>
     * Default: - No update expression
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_UpdateItem.html#DDB-UpdateItem-request-UpdateExpression
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getUpdateExpression() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DynamoUpdateItemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DynamoUpdateItemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute partitionKey;
        private java.lang.String tableName;
        private java.lang.String conditionExpression;
        private java.util.Map<java.lang.String, java.lang.String> expressionAttributeNames;
        private software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValueMap expressionAttributeValues;
        private software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity returnConsumedCapacity;
        private software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics returnItemCollectionMetrics;
        private software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues returnValues;
        private software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute sortKey;
        private java.lang.String updateExpression;

        /**
         * Sets the value of {@link DynamoUpdateItemProps#getPartitionKey}
         * @param partitionKey The partition key of the item to be updated. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder partitionKey(software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        /**
         * Sets the value of {@link DynamoUpdateItemProps#getTableName}
         * @param tableName The name of the table containing the requested item. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Sets the value of {@link DynamoUpdateItemProps#getConditionExpression}
         * @param conditionExpression A condition that must be satisfied in order for a conditional DeleteItem to succeed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder conditionExpression(java.lang.String conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        /**
         * Sets the value of {@link DynamoUpdateItemProps#getExpressionAttributeNames}
         * @param expressionAttributeNames One or more substitution tokens for attribute names in an expression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder expressionAttributeNames(java.util.Map<java.lang.String, java.lang.String> expressionAttributeNames) {
            this.expressionAttributeNames = expressionAttributeNames;
            return this;
        }

        /**
         * Sets the value of {@link DynamoUpdateItemProps#getExpressionAttributeValues}
         * @param expressionAttributeValues One or more values that can be substituted in an expression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder expressionAttributeValues(software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValueMap expressionAttributeValues) {
            this.expressionAttributeValues = expressionAttributeValues;
            return this;
        }

        /**
         * Sets the value of {@link DynamoUpdateItemProps#getReturnConsumedCapacity}
         * @param returnConsumedCapacity Determines the level of detail about provisioned throughput consumption that is returned in the response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder returnConsumedCapacity(software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        /**
         * Sets the value of {@link DynamoUpdateItemProps#getReturnItemCollectionMetrics}
         * @param returnItemCollectionMetrics Determines whether item collection metrics are returned.
         *                                    If set to SIZE, the response includes statistics about item collections, if any,
         *                                    that were modified during the operation are returned in the response.
         *                                    If set to NONE (the default), no statistics are returned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder returnItemCollectionMetrics(software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            return this;
        }

        /**
         * Sets the value of {@link DynamoUpdateItemProps#getReturnValues}
         * @param returnValues Use ReturnValues if you want to get the item attributes as they appeared before they were deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder returnValues(software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues returnValues) {
            this.returnValues = returnValues;
            return this;
        }

        /**
         * Sets the value of {@link DynamoUpdateItemProps#getSortKey}
         * @param sortKey The sort key of the item to be updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sortKey(software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute sortKey) {
            this.sortKey = sortKey;
            return this;
        }

        /**
         * Sets the value of {@link DynamoUpdateItemProps#getUpdateExpression}
         * @param updateExpression An expression that defines one or more attributes to be updated, the action to be performed on them, and new values for them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder updateExpression(java.lang.String updateExpression) {
            this.updateExpression = updateExpression;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DynamoUpdateItemProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public DynamoUpdateItemProps build() {
            return new Jsii$Proxy(partitionKey, tableName, conditionExpression, expressionAttributeNames, expressionAttributeValues, returnConsumedCapacity, returnItemCollectionMetrics, returnValues, sortKey, updateExpression);
        }
    }

    /**
     * An implementation for {@link DynamoUpdateItemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamoUpdateItemProps {
        private final software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute partitionKey;
        private final java.lang.String tableName;
        private final java.lang.String conditionExpression;
        private final java.util.Map<java.lang.String, java.lang.String> expressionAttributeNames;
        private final software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValueMap expressionAttributeValues;
        private final software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity returnConsumedCapacity;
        private final software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics returnItemCollectionMetrics;
        private final software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues returnValues;
        private final software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute sortKey;
        private final java.lang.String updateExpression;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.partitionKey = this.jsiiGet("partitionKey", software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute.class);
            this.tableName = this.jsiiGet("tableName", java.lang.String.class);
            this.conditionExpression = this.jsiiGet("conditionExpression", java.lang.String.class);
            this.expressionAttributeNames = this.jsiiGet("expressionAttributeNames", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.expressionAttributeValues = this.jsiiGet("expressionAttributeValues", software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValueMap.class);
            this.returnConsumedCapacity = this.jsiiGet("returnConsumedCapacity", software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity.class);
            this.returnItemCollectionMetrics = this.jsiiGet("returnItemCollectionMetrics", software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics.class);
            this.returnValues = this.jsiiGet("returnValues", software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues.class);
            this.sortKey = this.jsiiGet("sortKey", software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute.class);
            this.updateExpression = this.jsiiGet("updateExpression", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute partitionKey, final java.lang.String tableName, final java.lang.String conditionExpression, final java.util.Map<java.lang.String, java.lang.String> expressionAttributeNames, final software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValueMap expressionAttributeValues, final software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity returnConsumedCapacity, final software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics returnItemCollectionMetrics, final software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues returnValues, final software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute sortKey, final java.lang.String updateExpression) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.partitionKey = java.util.Objects.requireNonNull(partitionKey, "partitionKey is required");
            this.tableName = java.util.Objects.requireNonNull(tableName, "tableName is required");
            this.conditionExpression = conditionExpression;
            this.expressionAttributeNames = expressionAttributeNames;
            this.expressionAttributeValues = expressionAttributeValues;
            this.returnConsumedCapacity = returnConsumedCapacity;
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            this.returnValues = returnValues;
            this.sortKey = sortKey;
            this.updateExpression = updateExpression;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute getPartitionKey() {
            return this.partitionKey;
        }

        @Override
        public java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        public java.lang.String getConditionExpression() {
            return this.conditionExpression;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getExpressionAttributeNames() {
            return this.expressionAttributeNames;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValueMap getExpressionAttributeValues() {
            return this.expressionAttributeValues;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics getReturnItemCollectionMetrics() {
            return this.returnItemCollectionMetrics;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues getReturnValues() {
            return this.returnValues;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttribute getSortKey() {
            return this.sortKey;
        }

        @Override
        public java.lang.String getUpdateExpression() {
            return this.updateExpression;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("partitionKey", om.valueToTree(this.getPartitionKey()));
            data.set("tableName", om.valueToTree(this.getTableName()));
            if (this.getConditionExpression() != null) {
                data.set("conditionExpression", om.valueToTree(this.getConditionExpression()));
            }
            if (this.getExpressionAttributeNames() != null) {
                data.set("expressionAttributeNames", om.valueToTree(this.getExpressionAttributeNames()));
            }
            if (this.getExpressionAttributeValues() != null) {
                data.set("expressionAttributeValues", om.valueToTree(this.getExpressionAttributeValues()));
            }
            if (this.getReturnConsumedCapacity() != null) {
                data.set("returnConsumedCapacity", om.valueToTree(this.getReturnConsumedCapacity()));
            }
            if (this.getReturnItemCollectionMetrics() != null) {
                data.set("returnItemCollectionMetrics", om.valueToTree(this.getReturnItemCollectionMetrics()));
            }
            if (this.getReturnValues() != null) {
                data.set("returnValues", om.valueToTree(this.getReturnValues()));
            }
            if (this.getSortKey() != null) {
                data.set("sortKey", om.valueToTree(this.getSortKey()));
            }
            if (this.getUpdateExpression() != null) {
                data.set("updateExpression", om.valueToTree(this.getUpdateExpression()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.DynamoUpdateItemProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DynamoUpdateItemProps.Jsii$Proxy that = (DynamoUpdateItemProps.Jsii$Proxy) o;

            if (!partitionKey.equals(that.partitionKey)) return false;
            if (!tableName.equals(that.tableName)) return false;
            if (this.conditionExpression != null ? !this.conditionExpression.equals(that.conditionExpression) : that.conditionExpression != null) return false;
            if (this.expressionAttributeNames != null ? !this.expressionAttributeNames.equals(that.expressionAttributeNames) : that.expressionAttributeNames != null) return false;
            if (this.expressionAttributeValues != null ? !this.expressionAttributeValues.equals(that.expressionAttributeValues) : that.expressionAttributeValues != null) return false;
            if (this.returnConsumedCapacity != null ? !this.returnConsumedCapacity.equals(that.returnConsumedCapacity) : that.returnConsumedCapacity != null) return false;
            if (this.returnItemCollectionMetrics != null ? !this.returnItemCollectionMetrics.equals(that.returnItemCollectionMetrics) : that.returnItemCollectionMetrics != null) return false;
            if (this.returnValues != null ? !this.returnValues.equals(that.returnValues) : that.returnValues != null) return false;
            if (this.sortKey != null ? !this.sortKey.equals(that.sortKey) : that.sortKey != null) return false;
            return this.updateExpression != null ? this.updateExpression.equals(that.updateExpression) : that.updateExpression == null;
        }

        @Override
        public int hashCode() {
            int result = this.partitionKey.hashCode();
            result = 31 * result + (this.tableName.hashCode());
            result = 31 * result + (this.conditionExpression != null ? this.conditionExpression.hashCode() : 0);
            result = 31 * result + (this.expressionAttributeNames != null ? this.expressionAttributeNames.hashCode() : 0);
            result = 31 * result + (this.expressionAttributeValues != null ? this.expressionAttributeValues.hashCode() : 0);
            result = 31 * result + (this.returnConsumedCapacity != null ? this.returnConsumedCapacity.hashCode() : 0);
            result = 31 * result + (this.returnItemCollectionMetrics != null ? this.returnItemCollectionMetrics.hashCode() : 0);
            result = 31 * result + (this.returnValues != null ? this.returnValues.hashCode() : 0);
            result = 31 * result + (this.sortKey != null ? this.sortKey.hashCode() : 0);
            result = 31 * result + (this.updateExpression != null ? this.updateExpression.hashCode() : 0);
            return result;
        }
    }
}
