package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Configures the S3 bucket where SageMaker will save the result of model training.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.3.0 (build 8ae966b)", date = "2020-04-17T19:11:37.907Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.OutputDataConfig")
@software.amazon.jsii.Jsii.Proxy(OutputDataConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface OutputDataConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Identifies the S3 path where you want Amazon SageMaker to store the model artifacts.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.S3Location getS3OutputLocation();

    /**
     * Optional KMS encryption key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
     * <p>
     * Default: - Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OutputDataConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OutputDataConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private software.amazon.awscdk.services.stepfunctions.tasks.S3Location s3OutputLocation;
        private software.amazon.awscdk.services.kms.IKey encryptionKey;

        /**
         * Sets the value of {@link OutputDataConfig#getS3OutputLocation}
         * @param s3OutputLocation Identifies the S3 path where you want Amazon SageMaker to store the model artifacts. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3OutputLocation(software.amazon.awscdk.services.stepfunctions.tasks.S3Location s3OutputLocation) {
            this.s3OutputLocation = s3OutputLocation;
            return this;
        }

        /**
         * Sets the value of {@link OutputDataConfig#getEncryptionKey}
         * @param encryptionKey Optional KMS encryption key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OutputDataConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public OutputDataConfig build() {
            return new Jsii$Proxy(s3OutputLocation, encryptionKey);
        }
    }

    /**
     * An implementation for {@link OutputDataConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputDataConfig {
        private final software.amazon.awscdk.services.stepfunctions.tasks.S3Location s3OutputLocation;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.s3OutputLocation = this.jsiiGet("s3OutputLocation", software.amazon.awscdk.services.stepfunctions.tasks.S3Location.class);
            this.encryptionKey = this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IKey.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.tasks.S3Location s3OutputLocation, final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.s3OutputLocation = java.util.Objects.requireNonNull(s3OutputLocation, "s3OutputLocation is required");
            this.encryptionKey = encryptionKey;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.S3Location getS3OutputLocation() {
            return this.s3OutputLocation;
        }

        @Override
        public software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("s3OutputLocation", om.valueToTree(this.getS3OutputLocation()));
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.OutputDataConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OutputDataConfig.Jsii$Proxy that = (OutputDataConfig.Jsii$Proxy) o;

            if (!s3OutputLocation.equals(that.s3OutputLocation)) return false;
            return this.encryptionKey != null ? this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey == null;
        }

        @Override
        public int hashCode() {
            int result = this.s3OutputLocation.hashCode();
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            return result;
        }
    }
}
