package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for creating an Amazon SageMaker training job task.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.3.0 (build 8ae966b)", date = "2020-04-17T19:11:37.927Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.SagemakerTransformProps")
@software.amazon.jsii.Jsii.Proxy(SagemakerTransformProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface SagemakerTransformProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Name of the model that you want to use for the transform job.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getModelName();

    /**
     * Dataset to be transformed and the Amazon S3 location where it is stored.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.TransformInput getTransformInput();

    /**
     * Training Job Name.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getTransformJobName();

    /**
     * S3 location where you want Amazon SageMaker to save the results from the transform job.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.TransformOutput getTransformOutput();

    /**
     * Number of records to include in a mini-batch for an HTTP inference request.
     * <p>
     * Default: - No batch strategy
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.BatchStrategy getBatchStrategy() {
        return null;
    }

    /**
     * Environment variables to set in the Docker container.
     * <p>
     * Default: - No environment variables
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return null;
    }

    /**
     * The service integration pattern indicates different ways to call SageMaker APIs.
     * <p>
     * The valid value is either FIRE_AND_FORGET or SYNC.
     * <p>
     * Default: FIRE_AND_FORGET
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern getIntegrationPattern() {
        return null;
    }

    /**
     * Maximum number of parallel requests that can be sent to each instance in a transform job.
     * <p>
     * Default: - Amazon SageMaker checks the optional execution-parameters to determine the settings for your chosen algorithm.
     * If the execution-parameters endpoint is not enabled, the default value is 1.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxConcurrentTransforms() {
        return null;
    }

    /**
     * Maximum allowed size of the payload, in MB.
     * <p>
     * Default: 6
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxPayloadInMb() {
        return null;
    }

    /**
     * Role for the Training Job.
     * <p>
     * Default: - A role is created with `AmazonSageMakerFullAccess` managed policy
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * Tags to be applied to the train job.
     * <p>
     * Default: - No tags
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * ML compute instances for the transform job.
     * <p>
     * Default: - 1 instance of type M4.XLarge
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.TransformResources getTransformResources() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SagemakerTransformProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SagemakerTransformProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private java.lang.String modelName;
        private software.amazon.awscdk.services.stepfunctions.tasks.TransformInput transformInput;
        private java.lang.String transformJobName;
        private software.amazon.awscdk.services.stepfunctions.tasks.TransformOutput transformOutput;
        private software.amazon.awscdk.services.stepfunctions.tasks.BatchStrategy batchStrategy;
        private java.util.Map<java.lang.String, java.lang.String> environment;
        private software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern;
        private java.lang.Number maxConcurrentTransforms;
        private java.lang.Number maxPayloadInMb;
        private software.amazon.awscdk.services.iam.IRole role;
        private java.util.Map<java.lang.String, java.lang.String> tags;
        private software.amazon.awscdk.services.stepfunctions.tasks.TransformResources transformResources;

        /**
         * Sets the value of {@link SagemakerTransformProps#getModelName}
         * @param modelName Name of the model that you want to use for the transform job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder modelName(java.lang.String modelName) {
            this.modelName = modelName;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerTransformProps#getTransformInput}
         * @param transformInput Dataset to be transformed and the Amazon S3 location where it is stored. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder transformInput(software.amazon.awscdk.services.stepfunctions.tasks.TransformInput transformInput) {
            this.transformInput = transformInput;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerTransformProps#getTransformJobName}
         * @param transformJobName Training Job Name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder transformJobName(java.lang.String transformJobName) {
            this.transformJobName = transformJobName;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerTransformProps#getTransformOutput}
         * @param transformOutput S3 location where you want Amazon SageMaker to save the results from the transform job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder transformOutput(software.amazon.awscdk.services.stepfunctions.tasks.TransformOutput transformOutput) {
            this.transformOutput = transformOutput;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerTransformProps#getBatchStrategy}
         * @param batchStrategy Number of records to include in a mini-batch for an HTTP inference request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder batchStrategy(software.amazon.awscdk.services.stepfunctions.tasks.BatchStrategy batchStrategy) {
            this.batchStrategy = batchStrategy;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerTransformProps#getEnvironment}
         * @param environment Environment variables to set in the Docker container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerTransformProps#getIntegrationPattern}
         * @param integrationPattern The service integration pattern indicates different ways to call SageMaker APIs.
         *                           The valid value is either FIRE_AND_FORGET or SYNC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerTransformProps#getMaxConcurrentTransforms}
         * @param maxConcurrentTransforms Maximum number of parallel requests that can be sent to each instance in a transform job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxConcurrentTransforms(java.lang.Number maxConcurrentTransforms) {
            this.maxConcurrentTransforms = maxConcurrentTransforms;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerTransformProps#getMaxPayloadInMb}
         * @param maxPayloadInMb Maximum allowed size of the payload, in MB.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxPayloadInMb(java.lang.Number maxPayloadInMb) {
            this.maxPayloadInMb = maxPayloadInMb;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerTransformProps#getRole}
         * @param role Role for the Training Job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerTransformProps#getTags}
         * @param tags Tags to be applied to the train job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerTransformProps#getTransformResources}
         * @param transformResources ML compute instances for the transform job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder transformResources(software.amazon.awscdk.services.stepfunctions.tasks.TransformResources transformResources) {
            this.transformResources = transformResources;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SagemakerTransformProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public SagemakerTransformProps build() {
            return new Jsii$Proxy(modelName, transformInput, transformJobName, transformOutput, batchStrategy, environment, integrationPattern, maxConcurrentTransforms, maxPayloadInMb, role, tags, transformResources);
        }
    }

    /**
     * An implementation for {@link SagemakerTransformProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SagemakerTransformProps {
        private final java.lang.String modelName;
        private final software.amazon.awscdk.services.stepfunctions.tasks.TransformInput transformInput;
        private final java.lang.String transformJobName;
        private final software.amazon.awscdk.services.stepfunctions.tasks.TransformOutput transformOutput;
        private final software.amazon.awscdk.services.stepfunctions.tasks.BatchStrategy batchStrategy;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern;
        private final java.lang.Number maxConcurrentTransforms;
        private final java.lang.Number maxPayloadInMb;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final software.amazon.awscdk.services.stepfunctions.tasks.TransformResources transformResources;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.modelName = this.jsiiGet("modelName", java.lang.String.class);
            this.transformInput = this.jsiiGet("transformInput", software.amazon.awscdk.services.stepfunctions.tasks.TransformInput.class);
            this.transformJobName = this.jsiiGet("transformJobName", java.lang.String.class);
            this.transformOutput = this.jsiiGet("transformOutput", software.amazon.awscdk.services.stepfunctions.tasks.TransformOutput.class);
            this.batchStrategy = this.jsiiGet("batchStrategy", software.amazon.awscdk.services.stepfunctions.tasks.BatchStrategy.class);
            this.environment = this.jsiiGet("environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.integrationPattern = this.jsiiGet("integrationPattern", software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern.class);
            this.maxConcurrentTransforms = this.jsiiGet("maxConcurrentTransforms", java.lang.Number.class);
            this.maxPayloadInMb = this.jsiiGet("maxPayloadInMB", java.lang.Number.class);
            this.role = this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
            this.tags = this.jsiiGet("tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.transformResources = this.jsiiGet("transformResources", software.amazon.awscdk.services.stepfunctions.tasks.TransformResources.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String modelName, final software.amazon.awscdk.services.stepfunctions.tasks.TransformInput transformInput, final java.lang.String transformJobName, final software.amazon.awscdk.services.stepfunctions.tasks.TransformOutput transformOutput, final software.amazon.awscdk.services.stepfunctions.tasks.BatchStrategy batchStrategy, final java.util.Map<java.lang.String, java.lang.String> environment, final software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern, final java.lang.Number maxConcurrentTransforms, final java.lang.Number maxPayloadInMb, final software.amazon.awscdk.services.iam.IRole role, final java.util.Map<java.lang.String, java.lang.String> tags, final software.amazon.awscdk.services.stepfunctions.tasks.TransformResources transformResources) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.modelName = java.util.Objects.requireNonNull(modelName, "modelName is required");
            this.transformInput = java.util.Objects.requireNonNull(transformInput, "transformInput is required");
            this.transformJobName = java.util.Objects.requireNonNull(transformJobName, "transformJobName is required");
            this.transformOutput = java.util.Objects.requireNonNull(transformOutput, "transformOutput is required");
            this.batchStrategy = batchStrategy;
            this.environment = environment;
            this.integrationPattern = integrationPattern;
            this.maxConcurrentTransforms = maxConcurrentTransforms;
            this.maxPayloadInMb = maxPayloadInMb;
            this.role = role;
            this.tags = tags;
            this.transformResources = transformResources;
        }

        @Override
        public java.lang.String getModelName() {
            return this.modelName;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.TransformInput getTransformInput() {
            return this.transformInput;
        }

        @Override
        public java.lang.String getTransformJobName() {
            return this.transformJobName;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.TransformOutput getTransformOutput() {
            return this.transformOutput;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.BatchStrategy getBatchStrategy() {
            return this.batchStrategy;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public java.lang.Number getMaxConcurrentTransforms() {
            return this.maxConcurrentTransforms;
        }

        @Override
        public java.lang.Number getMaxPayloadInMb() {
            return this.maxPayloadInMb;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.TransformResources getTransformResources() {
            return this.transformResources;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("modelName", om.valueToTree(this.getModelName()));
            data.set("transformInput", om.valueToTree(this.getTransformInput()));
            data.set("transformJobName", om.valueToTree(this.getTransformJobName()));
            data.set("transformOutput", om.valueToTree(this.getTransformOutput()));
            if (this.getBatchStrategy() != null) {
                data.set("batchStrategy", om.valueToTree(this.getBatchStrategy()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getMaxConcurrentTransforms() != null) {
                data.set("maxConcurrentTransforms", om.valueToTree(this.getMaxConcurrentTransforms()));
            }
            if (this.getMaxPayloadInMb() != null) {
                data.set("maxPayloadInMB", om.valueToTree(this.getMaxPayloadInMb()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTransformResources() != null) {
                data.set("transformResources", om.valueToTree(this.getTransformResources()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.SagemakerTransformProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SagemakerTransformProps.Jsii$Proxy that = (SagemakerTransformProps.Jsii$Proxy) o;

            if (!modelName.equals(that.modelName)) return false;
            if (!transformInput.equals(that.transformInput)) return false;
            if (!transformJobName.equals(that.transformJobName)) return false;
            if (!transformOutput.equals(that.transformOutput)) return false;
            if (this.batchStrategy != null ? !this.batchStrategy.equals(that.batchStrategy) : that.batchStrategy != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.maxConcurrentTransforms != null ? !this.maxConcurrentTransforms.equals(that.maxConcurrentTransforms) : that.maxConcurrentTransforms != null) return false;
            if (this.maxPayloadInMb != null ? !this.maxPayloadInMb.equals(that.maxPayloadInMb) : that.maxPayloadInMb != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.transformResources != null ? this.transformResources.equals(that.transformResources) : that.transformResources == null;
        }

        @Override
        public int hashCode() {
            int result = this.modelName.hashCode();
            result = 31 * result + (this.transformInput.hashCode());
            result = 31 * result + (this.transformJobName.hashCode());
            result = 31 * result + (this.transformOutput.hashCode());
            result = 31 * result + (this.batchStrategy != null ? this.batchStrategy.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.maxConcurrentTransforms != null ? this.maxConcurrentTransforms.hashCode() : 0);
            result = 31 * result + (this.maxPayloadInMb != null ? this.maxPayloadInMb.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.transformResources != null ? this.transformResources.hashCode() : 0);
            return result;
        }
    }
}
