package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for DynamoPutItem Task.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.3.2 (build 237c474)", date = "2020-04-21T17:16:26.676Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.DynamoPutItemProps")
@software.amazon.jsii.Jsii.Proxy(DynamoPutItemProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DynamoPutItemProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A map of attribute name/value pairs, one for each attribute.
     * <p>
     * Only the primary key attributes are required;
     * you can optionally provide other attribute name-value pairs for the item.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutItem.html#DDB-PutItem-request-Item
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValueMap getItem();

    /**
     * The name of the table where the item should be writen .
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getTableName();

    /**
     * A condition that must be satisfied in order for a conditional PutItem operation to succeed.
     * <p>
     * Default: - No condition expression
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutItem.html#DDB-PutItem-request-ConditionExpression
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getConditionExpression() {
        return null;
    }

    /**
     * One or more substitution tokens for attribute names in an expression.
     * <p>
     * Default: - No expression attribute names
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutItem.html#DDB-PutItem-request-ExpressionAttributeNames
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getExpressionAttributeNames() {
        return null;
    }

    /**
     * One or more values that can be substituted in an expression.
     * <p>
     * Default: - No expression attribute values
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutItem.html#DDB-PutItem-request-ExpressionAttributeValues
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValueMap getExpressionAttributeValues() {
        return null;
    }

    /**
     * Determines the level of detail about provisioned throughput consumption that is returned in the response.
     * <p>
     * Default: DynamoConsumedCapacity.NONE
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutItem.html#DDB-PutItem-request-ReturnConsumedCapacity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity getReturnConsumedCapacity() {
        return null;
    }

    /**
     * The item collection metrics to returned in the response.
     * <p>
     * Default: DynamoItemCollectionMetrics.NONE
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LSI.html#LSI.ItemCollections
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics getReturnItemCollectionMetrics() {
        return null;
    }

    /**
     * Use ReturnValues if you want to get the item attributes as they appeared before they were updated with the PutItem request.
     * <p>
     * Default: DynamoReturnValues.NONE
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutItem.html#DDB-PutItem-request-ReturnValues
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues getReturnValues() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DynamoPutItemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DynamoPutItemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValueMap item;
        private java.lang.String tableName;
        private java.lang.String conditionExpression;
        private java.util.Map<java.lang.String, java.lang.String> expressionAttributeNames;
        private software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValueMap expressionAttributeValues;
        private software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity returnConsumedCapacity;
        private software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics returnItemCollectionMetrics;
        private software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues returnValues;

        /**
         * Sets the value of {@link DynamoPutItemProps#getItem}
         * @param item A map of attribute name/value pairs, one for each attribute. This parameter is required.
         *             Only the primary key attributes are required;
         *             you can optionally provide other attribute name-value pairs for the item.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder item(software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValueMap item) {
            this.item = item;
            return this;
        }

        /**
         * Sets the value of {@link DynamoPutItemProps#getTableName}
         * @param tableName The name of the table where the item should be writen . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Sets the value of {@link DynamoPutItemProps#getConditionExpression}
         * @param conditionExpression A condition that must be satisfied in order for a conditional PutItem operation to succeed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder conditionExpression(java.lang.String conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        /**
         * Sets the value of {@link DynamoPutItemProps#getExpressionAttributeNames}
         * @param expressionAttributeNames One or more substitution tokens for attribute names in an expression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder expressionAttributeNames(java.util.Map<java.lang.String, java.lang.String> expressionAttributeNames) {
            this.expressionAttributeNames = expressionAttributeNames;
            return this;
        }

        /**
         * Sets the value of {@link DynamoPutItemProps#getExpressionAttributeValues}
         * @param expressionAttributeValues One or more values that can be substituted in an expression.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder expressionAttributeValues(software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValueMap expressionAttributeValues) {
            this.expressionAttributeValues = expressionAttributeValues;
            return this;
        }

        /**
         * Sets the value of {@link DynamoPutItemProps#getReturnConsumedCapacity}
         * @param returnConsumedCapacity Determines the level of detail about provisioned throughput consumption that is returned in the response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder returnConsumedCapacity(software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        /**
         * Sets the value of {@link DynamoPutItemProps#getReturnItemCollectionMetrics}
         * @param returnItemCollectionMetrics The item collection metrics to returned in the response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder returnItemCollectionMetrics(software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            return this;
        }

        /**
         * Sets the value of {@link DynamoPutItemProps#getReturnValues}
         * @param returnValues Use ReturnValues if you want to get the item attributes as they appeared before they were updated with the PutItem request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder returnValues(software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues returnValues) {
            this.returnValues = returnValues;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DynamoPutItemProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public DynamoPutItemProps build() {
            return new Jsii$Proxy(item, tableName, conditionExpression, expressionAttributeNames, expressionAttributeValues, returnConsumedCapacity, returnItemCollectionMetrics, returnValues);
        }
    }

    /**
     * An implementation for {@link DynamoPutItemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamoPutItemProps {
        private final software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValueMap item;
        private final java.lang.String tableName;
        private final java.lang.String conditionExpression;
        private final java.util.Map<java.lang.String, java.lang.String> expressionAttributeNames;
        private final software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValueMap expressionAttributeValues;
        private final software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity returnConsumedCapacity;
        private final software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics returnItemCollectionMetrics;
        private final software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues returnValues;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.item = this.jsiiGet("item", software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValueMap.class);
            this.tableName = this.jsiiGet("tableName", java.lang.String.class);
            this.conditionExpression = this.jsiiGet("conditionExpression", java.lang.String.class);
            this.expressionAttributeNames = this.jsiiGet("expressionAttributeNames", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.expressionAttributeValues = this.jsiiGet("expressionAttributeValues", software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValueMap.class);
            this.returnConsumedCapacity = this.jsiiGet("returnConsumedCapacity", software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity.class);
            this.returnItemCollectionMetrics = this.jsiiGet("returnItemCollectionMetrics", software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics.class);
            this.returnValues = this.jsiiGet("returnValues", software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValueMap item, final java.lang.String tableName, final java.lang.String conditionExpression, final java.util.Map<java.lang.String, java.lang.String> expressionAttributeNames, final software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValueMap expressionAttributeValues, final software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity returnConsumedCapacity, final software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics returnItemCollectionMetrics, final software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues returnValues) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.item = java.util.Objects.requireNonNull(item, "item is required");
            this.tableName = java.util.Objects.requireNonNull(tableName, "tableName is required");
            this.conditionExpression = conditionExpression;
            this.expressionAttributeNames = expressionAttributeNames;
            this.expressionAttributeValues = expressionAttributeValues;
            this.returnConsumedCapacity = returnConsumedCapacity;
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            this.returnValues = returnValues;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValueMap getItem() {
            return this.item;
        }

        @Override
        public java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        public java.lang.String getConditionExpression() {
            return this.conditionExpression;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getExpressionAttributeNames() {
            return this.expressionAttributeNames;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValueMap getExpressionAttributeValues() {
            return this.expressionAttributeValues;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics getReturnItemCollectionMetrics() {
            return this.returnItemCollectionMetrics;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues getReturnValues() {
            return this.returnValues;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("item", om.valueToTree(this.getItem()));
            data.set("tableName", om.valueToTree(this.getTableName()));
            if (this.getConditionExpression() != null) {
                data.set("conditionExpression", om.valueToTree(this.getConditionExpression()));
            }
            if (this.getExpressionAttributeNames() != null) {
                data.set("expressionAttributeNames", om.valueToTree(this.getExpressionAttributeNames()));
            }
            if (this.getExpressionAttributeValues() != null) {
                data.set("expressionAttributeValues", om.valueToTree(this.getExpressionAttributeValues()));
            }
            if (this.getReturnConsumedCapacity() != null) {
                data.set("returnConsumedCapacity", om.valueToTree(this.getReturnConsumedCapacity()));
            }
            if (this.getReturnItemCollectionMetrics() != null) {
                data.set("returnItemCollectionMetrics", om.valueToTree(this.getReturnItemCollectionMetrics()));
            }
            if (this.getReturnValues() != null) {
                data.set("returnValues", om.valueToTree(this.getReturnValues()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.DynamoPutItemProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DynamoPutItemProps.Jsii$Proxy that = (DynamoPutItemProps.Jsii$Proxy) o;

            if (!item.equals(that.item)) return false;
            if (!tableName.equals(that.tableName)) return false;
            if (this.conditionExpression != null ? !this.conditionExpression.equals(that.conditionExpression) : that.conditionExpression != null) return false;
            if (this.expressionAttributeNames != null ? !this.expressionAttributeNames.equals(that.expressionAttributeNames) : that.expressionAttributeNames != null) return false;
            if (this.expressionAttributeValues != null ? !this.expressionAttributeValues.equals(that.expressionAttributeValues) : that.expressionAttributeValues != null) return false;
            if (this.returnConsumedCapacity != null ? !this.returnConsumedCapacity.equals(that.returnConsumedCapacity) : that.returnConsumedCapacity != null) return false;
            if (this.returnItemCollectionMetrics != null ? !this.returnItemCollectionMetrics.equals(that.returnItemCollectionMetrics) : that.returnItemCollectionMetrics != null) return false;
            return this.returnValues != null ? this.returnValues.equals(that.returnValues) : that.returnValues == null;
        }

        @Override
        public int hashCode() {
            int result = this.item.hashCode();
            result = 31 * result + (this.tableName.hashCode());
            result = 31 * result + (this.conditionExpression != null ? this.conditionExpression.hashCode() : 0);
            result = 31 * result + (this.expressionAttributeNames != null ? this.expressionAttributeNames.hashCode() : 0);
            result = 31 * result + (this.expressionAttributeValues != null ? this.expressionAttributeValues.hashCode() : 0);
            result = 31 * result + (this.returnConsumedCapacity != null ? this.returnConsumedCapacity.hashCode() : 0);
            result = 31 * result + (this.returnItemCollectionMetrics != null ? this.returnItemCollectionMetrics.hashCode() : 0);
            result = 31 * result + (this.returnValues != null ? this.returnValues.hashCode() : 0);
            return result;
        }
    }
}
