package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * A Step Functions Task to add a Step to an EMR Cluster.
 * <p>
 * The StepConfiguration is defined as Parameters in the state machine definition.
 * <p>
 * OUTPUT: the StepId
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.3.2 (build 237c474)", date = "2020-04-21T17:16:26.678Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrAddStep")
public class EmrAddStep extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.IStepFunctionsTask {

    protected EmrAddStep(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EmrAddStep(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public EmrAddStep(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrAddStepProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Called when the task object is used in a workflow.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param _task This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Task _task) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig.class, new Object[] { java.util.Objects.requireNonNull(_task, "_task is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.EmrAddStep}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        /**
         * EXPERIMENTAL
         * <p>
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.stepfunctions.tasks.EmrAddStepProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.stepfunctions.tasks.EmrAddStepProps.Builder();
        }

        /**
         * The ClusterId to add the Step to.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param clusterId The ClusterId to add the Step to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterId(final java.lang.String clusterId) {
            this.props.clusterId(clusterId);
            return this;
        }

        /**
         * A path to a JAR file run during the step.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_HadoopJarStepConfig.html
         * @param jar A path to a JAR file run during the step. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jar(final java.lang.String jar) {
            this.props.jar(jar);
            return this;
        }

        /**
         * The name of the Step.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_StepConfig.html
         * @param name The name of the Step. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The action to take when the cluster step fails.
         * <p>
         * Default: CONTINUE
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_StepConfig.html
         * @param actionOnFailure The action to take when the cluster step fails. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder actionOnFailure(final software.amazon.awscdk.services.stepfunctions.tasks.ActionOnFailure actionOnFailure) {
            this.props.actionOnFailure(actionOnFailure);
            return this;
        }

        /**
         * A list of command line arguments passed to the JAR file's main function when executed.
         * <p>
         * Default: No args
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_HadoopJarStepConfig.html
         * @param args A list of command line arguments passed to the JAR file's main function when executed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder args(final java.util.List<java.lang.String> args) {
            this.props.args(args);
            return this;
        }

        /**
         * The service integration pattern indicates different ways to call AddStep.
         * <p>
         * The valid value is either FIRE_AND_FORGET or SYNC.
         * <p>
         * Default: SYNC
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param integrationPattern The service integration pattern indicates different ways to call AddStep. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integrationPattern(final software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        /**
         * The name of the main class in the specified Java file.
         * <p>
         * If not specified, the JAR file should specify a Main-Class in its manifest file.
         * <p>
         * Default: No mainClass
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_HadoopJarStepConfig.html
         * @param mainClass The name of the main class in the specified Java file. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mainClass(final java.lang.String mainClass) {
            this.props.mainClass(mainClass);
            return this;
        }

        /**
         * A list of Java properties that are set when the step runs.
         * <p>
         * You can use these properties to pass key value pairs to your main function.
         * <p>
         * Default: No properties
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_HadoopJarStepConfig.html
         * @param properties A list of Java properties that are set when the step runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder properties(final java.util.Map<java.lang.String, java.lang.String> properties) {
            this.props.properties(properties);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.EmrAddStep}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.stepfunctions.tasks.EmrAddStep build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.EmrAddStep(
                this.props.build()
            );
        }
    }
}
