package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Class representing the SageMaker Create Training Job task.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.3.2 (build 237c474)", date = "2020-04-21T17:16:26.705Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.SagemakerTrainTask")
public class SagemakerTrainTask extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.IGrantable,software.amazon.awscdk.services.ec2.IConnectable,software.amazon.awscdk.services.stepfunctions.IStepFunctionsTask {

    protected SagemakerTrainTask(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SagemakerTrainTask(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SagemakerTrainTask(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.SagemakerTrainTaskProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add the security group to all instances via the launch configuration security groups array.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param securityGroup : The security group to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addSecurityGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
        this.jsiiCall("addSecurityGroup", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(securityGroup, "securityGroup is required") });
    }

    /**
     * Called when the task object is used in a workflow.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param task This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Task task) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig.class, new Object[] { java.util.Objects.requireNonNull(task, "task is required") });
    }

    /**
     * Allows specify security group connections for instances of this fleet.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return this.jsiiGet("connections", software.amazon.awscdk.services.ec2.Connections.class);
    }

    /**
     * The principal to grant permissions to.
     * <p>
     * EXPERIMENTAL
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return this.jsiiGet("grantPrincipal", software.amazon.awscdk.services.iam.IPrincipal.class);
    }

    /**
     * The execution role for the Sagemaker training job.
     * <p>
     * Only available after task has been added to a state machine.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole() {
        return this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.SagemakerTrainTask}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        /**
         * EXPERIMENTAL
         * <p>
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.stepfunctions.tasks.SagemakerTrainTaskProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.stepfunctions.tasks.SagemakerTrainTaskProps.Builder();
        }

        /**
         * Identifies the training algorithm to use.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param algorithmSpecification Identifies the training algorithm to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder algorithmSpecification(final software.amazon.awscdk.services.stepfunctions.tasks.AlgorithmSpecification algorithmSpecification) {
            this.props.algorithmSpecification(algorithmSpecification);
            return this;
        }

        /**
         * Describes the various datasets (e.g. train, validation, test) and the Amazon S3 location where stored.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param inputDataConfig Describes the various datasets (e.g. train, validation, test) and the Amazon S3 location where stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder inputDataConfig(final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.Channel> inputDataConfig) {
            this.props.inputDataConfig(inputDataConfig);
            return this;
        }

        /**
         * Identifies the Amazon S3 location where you want Amazon SageMaker to save the results of model training.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param outputDataConfig Identifies the Amazon S3 location where you want Amazon SageMaker to save the results of model training. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputDataConfig(final software.amazon.awscdk.services.stepfunctions.tasks.OutputDataConfig outputDataConfig) {
            this.props.outputDataConfig(outputDataConfig);
            return this;
        }

        /**
         * Training Job Name.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param trainingJobName Training Job Name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder trainingJobName(final java.lang.String trainingJobName) {
            this.props.trainingJobName(trainingJobName);
            return this;
        }

        /**
         * Algorithm-specific parameters that influence the quality of the model.
         * <p>
         * Set hyperparameters before you start the learning process.
         * For a list of hyperparameters provided by Amazon SageMaker
         * <p>
         * Default: - No hyperparameters
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html
         * @param hyperparameters Algorithm-specific parameters that influence the quality of the model. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder hyperparameters(final java.util.Map<java.lang.String, java.lang.Object> hyperparameters) {
            this.props.hyperparameters(hyperparameters);
            return this;
        }

        /**
         * The service integration pattern indicates different ways to call SageMaker APIs.
         * <p>
         * The valid value is either FIRE_AND_FORGET or SYNC.
         * <p>
         * Default: FIRE_AND_FORGET
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param integrationPattern The service integration pattern indicates different ways to call SageMaker APIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integrationPattern(final software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        /**
         * Specifies the resources, ML compute instances, and ML storage volumes to deploy for model training.
         * <p>
         * Default: - 1 instance of EC2 `M4.XLarge` with `10GB` volume
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param resourceConfig Specifies the resources, ML compute instances, and ML storage volumes to deploy for model training. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder resourceConfig(final software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig resourceConfig) {
            this.props.resourceConfig(resourceConfig);
            return this;
        }

        /**
         * Role for the Training Job.
         * <p>
         * The role must be granted all necessary permissions for the SageMaker training job to
         * be able to operate.
         * <p>
         * See https://docs.aws.amazon.com/fr_fr/sagemaker/latest/dg/sagemaker-roles.html#sagemaker-roles-createtrainingjob-perms
         * <p>
         * Default: - a role with appropriate permissions will be created.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param role Role for the Training Job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * Sets a time limit for training.
         * <p>
         * Default: - max runtime of 1 hour
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param stoppingCondition Sets a time limit for training. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stoppingCondition(final software.amazon.awscdk.services.stepfunctions.tasks.StoppingCondition stoppingCondition) {
            this.props.stoppingCondition(stoppingCondition);
            return this;
        }

        /**
         * Tags to be applied to the train job.
         * <p>
         * Default: - No tags
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param tags Tags to be applied to the train job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Specifies the VPC that you want your training job to connect to.
         * <p>
         * Default: - No VPC
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param vpcConfig Specifies the VPC that you want your training job to connect to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcConfig(final software.amazon.awscdk.services.stepfunctions.tasks.VpcConfig vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.SagemakerTrainTask}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.stepfunctions.tasks.SagemakerTrainTask build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.SagemakerTrainTask(
                this.props.build()
            );
        }
    }
}
