package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for creating an Amazon SageMaker training job.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.3.2 (build 237c474)", date = "2020-04-21T17:16:26.705Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.SagemakerTrainTaskProps")
@software.amazon.jsii.Jsii.Proxy(SagemakerTrainTaskProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface SagemakerTrainTaskProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Identifies the training algorithm to use.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.AlgorithmSpecification getAlgorithmSpecification();

    /**
     * Describes the various datasets (e.g. train, validation, test) and the Amazon S3 location where stored.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.Channel> getInputDataConfig();

    /**
     * Identifies the Amazon S3 location where you want Amazon SageMaker to save the results of model training.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.OutputDataConfig getOutputDataConfig();

    /**
     * Training Job Name.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getTrainingJobName();

    /**
     * Algorithm-specific parameters that influence the quality of the model.
     * <p>
     * Set hyperparameters before you start the learning process.
     * For a list of hyperparameters provided by Amazon SageMaker
     * <p>
     * Default: - No hyperparameters
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getHyperparameters() {
        return null;
    }

    /**
     * The service integration pattern indicates different ways to call SageMaker APIs.
     * <p>
     * The valid value is either FIRE_AND_FORGET or SYNC.
     * <p>
     * Default: FIRE_AND_FORGET
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern getIntegrationPattern() {
        return null;
    }

    /**
     * Specifies the resources, ML compute instances, and ML storage volumes to deploy for model training.
     * <p>
     * Default: - 1 instance of EC2 `M4.XLarge` with `10GB` volume
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig getResourceConfig() {
        return null;
    }

    /**
     * Role for the Training Job.
     * <p>
     * The role must be granted all necessary permissions for the SageMaker training job to
     * be able to operate.
     * <p>
     * See https://docs.aws.amazon.com/fr_fr/sagemaker/latest/dg/sagemaker-roles.html#sagemaker-roles-createtrainingjob-perms
     * <p>
     * Default: - a role with appropriate permissions will be created.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * Sets a time limit for training.
     * <p>
     * Default: - max runtime of 1 hour
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.StoppingCondition getStoppingCondition() {
        return null;
    }

    /**
     * Tags to be applied to the train job.
     * <p>
     * Default: - No tags
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * Specifies the VPC that you want your training job to connect to.
     * <p>
     * Default: - No VPC
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.VpcConfig getVpcConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SagemakerTrainTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SagemakerTrainTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private software.amazon.awscdk.services.stepfunctions.tasks.AlgorithmSpecification algorithmSpecification;
        private java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.Channel> inputDataConfig;
        private software.amazon.awscdk.services.stepfunctions.tasks.OutputDataConfig outputDataConfig;
        private java.lang.String trainingJobName;
        private java.util.Map<java.lang.String, java.lang.Object> hyperparameters;
        private software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern;
        private software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig resourceConfig;
        private software.amazon.awscdk.services.iam.IRole role;
        private software.amazon.awscdk.services.stepfunctions.tasks.StoppingCondition stoppingCondition;
        private java.util.Map<java.lang.String, java.lang.String> tags;
        private software.amazon.awscdk.services.stepfunctions.tasks.VpcConfig vpcConfig;

        /**
         * Sets the value of {@link SagemakerTrainTaskProps#getAlgorithmSpecification}
         * @param algorithmSpecification Identifies the training algorithm to use. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder algorithmSpecification(software.amazon.awscdk.services.stepfunctions.tasks.AlgorithmSpecification algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerTrainTaskProps#getInputDataConfig}
         * @param inputDataConfig Describes the various datasets (e.g. train, validation, test) and the Amazon S3 location where stored. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder inputDataConfig(java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.Channel> inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerTrainTaskProps#getOutputDataConfig}
         * @param outputDataConfig Identifies the Amazon S3 location where you want Amazon SageMaker to save the results of model training. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputDataConfig(software.amazon.awscdk.services.stepfunctions.tasks.OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerTrainTaskProps#getTrainingJobName}
         * @param trainingJobName Training Job Name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder trainingJobName(java.lang.String trainingJobName) {
            this.trainingJobName = trainingJobName;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerTrainTaskProps#getHyperparameters}
         * @param hyperparameters Algorithm-specific parameters that influence the quality of the model.
         *                        Set hyperparameters before you start the learning process.
         *                        For a list of hyperparameters provided by Amazon SageMaker
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder hyperparameters(java.util.Map<java.lang.String, java.lang.Object> hyperparameters) {
            this.hyperparameters = hyperparameters;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerTrainTaskProps#getIntegrationPattern}
         * @param integrationPattern The service integration pattern indicates different ways to call SageMaker APIs.
         *                           The valid value is either FIRE_AND_FORGET or SYNC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerTrainTaskProps#getResourceConfig}
         * @param resourceConfig Specifies the resources, ML compute instances, and ML storage volumes to deploy for model training.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder resourceConfig(software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerTrainTaskProps#getRole}
         * @param role Role for the Training Job.
         *             The role must be granted all necessary permissions for the SageMaker training job to
         *             be able to operate.
         *             <p>
         *             See https://docs.aws.amazon.com/fr_fr/sagemaker/latest/dg/sagemaker-roles.html#sagemaker-roles-createtrainingjob-perms
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerTrainTaskProps#getStoppingCondition}
         * @param stoppingCondition Sets a time limit for training.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stoppingCondition(software.amazon.awscdk.services.stepfunctions.tasks.StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerTrainTaskProps#getTags}
         * @param tags Tags to be applied to the train job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link SagemakerTrainTaskProps#getVpcConfig}
         * @param vpcConfig Specifies the VPC that you want your training job to connect to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcConfig(software.amazon.awscdk.services.stepfunctions.tasks.VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SagemakerTrainTaskProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public SagemakerTrainTaskProps build() {
            return new Jsii$Proxy(algorithmSpecification, inputDataConfig, outputDataConfig, trainingJobName, hyperparameters, integrationPattern, resourceConfig, role, stoppingCondition, tags, vpcConfig);
        }
    }

    /**
     * An implementation for {@link SagemakerTrainTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SagemakerTrainTaskProps {
        private final software.amazon.awscdk.services.stepfunctions.tasks.AlgorithmSpecification algorithmSpecification;
        private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.Channel> inputDataConfig;
        private final software.amazon.awscdk.services.stepfunctions.tasks.OutputDataConfig outputDataConfig;
        private final java.lang.String trainingJobName;
        private final java.util.Map<java.lang.String, java.lang.Object> hyperparameters;
        private final software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern;
        private final software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig resourceConfig;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.stepfunctions.tasks.StoppingCondition stoppingCondition;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final software.amazon.awscdk.services.stepfunctions.tasks.VpcConfig vpcConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.algorithmSpecification = this.jsiiGet("algorithmSpecification", software.amazon.awscdk.services.stepfunctions.tasks.AlgorithmSpecification.class);
            this.inputDataConfig = this.jsiiGet("inputDataConfig", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.Channel.class)));
            this.outputDataConfig = this.jsiiGet("outputDataConfig", software.amazon.awscdk.services.stepfunctions.tasks.OutputDataConfig.class);
            this.trainingJobName = this.jsiiGet("trainingJobName", java.lang.String.class);
            this.hyperparameters = this.jsiiGet("hyperparameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.integrationPattern = this.jsiiGet("integrationPattern", software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern.class);
            this.resourceConfig = this.jsiiGet("resourceConfig", software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig.class);
            this.role = this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
            this.stoppingCondition = this.jsiiGet("stoppingCondition", software.amazon.awscdk.services.stepfunctions.tasks.StoppingCondition.class);
            this.tags = this.jsiiGet("tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.vpcConfig = this.jsiiGet("vpcConfig", software.amazon.awscdk.services.stepfunctions.tasks.VpcConfig.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.tasks.AlgorithmSpecification algorithmSpecification, final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.Channel> inputDataConfig, final software.amazon.awscdk.services.stepfunctions.tasks.OutputDataConfig outputDataConfig, final java.lang.String trainingJobName, final java.util.Map<java.lang.String, java.lang.Object> hyperparameters, final software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern, final software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig resourceConfig, final software.amazon.awscdk.services.iam.IRole role, final software.amazon.awscdk.services.stepfunctions.tasks.StoppingCondition stoppingCondition, final java.util.Map<java.lang.String, java.lang.String> tags, final software.amazon.awscdk.services.stepfunctions.tasks.VpcConfig vpcConfig) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.algorithmSpecification = java.util.Objects.requireNonNull(algorithmSpecification, "algorithmSpecification is required");
            this.inputDataConfig = java.util.Objects.requireNonNull(inputDataConfig, "inputDataConfig is required");
            this.outputDataConfig = java.util.Objects.requireNonNull(outputDataConfig, "outputDataConfig is required");
            this.trainingJobName = java.util.Objects.requireNonNull(trainingJobName, "trainingJobName is required");
            this.hyperparameters = hyperparameters;
            this.integrationPattern = integrationPattern;
            this.resourceConfig = resourceConfig;
            this.role = role;
            this.stoppingCondition = stoppingCondition;
            this.tags = tags;
            this.vpcConfig = vpcConfig;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.AlgorithmSpecification getAlgorithmSpecification() {
            return this.algorithmSpecification;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.Channel> getInputDataConfig() {
            return this.inputDataConfig;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.OutputDataConfig getOutputDataConfig() {
            return this.outputDataConfig;
        }

        @Override
        public java.lang.String getTrainingJobName() {
            return this.trainingJobName;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.Object> getHyperparameters() {
            return this.hyperparameters;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig getResourceConfig() {
            return this.resourceConfig;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.StoppingCondition getStoppingCondition() {
            return this.stoppingCondition;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.VpcConfig getVpcConfig() {
            return this.vpcConfig;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("algorithmSpecification", om.valueToTree(this.getAlgorithmSpecification()));
            data.set("inputDataConfig", om.valueToTree(this.getInputDataConfig()));
            data.set("outputDataConfig", om.valueToTree(this.getOutputDataConfig()));
            data.set("trainingJobName", om.valueToTree(this.getTrainingJobName()));
            if (this.getHyperparameters() != null) {
                data.set("hyperparameters", om.valueToTree(this.getHyperparameters()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getResourceConfig() != null) {
                data.set("resourceConfig", om.valueToTree(this.getResourceConfig()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getStoppingCondition() != null) {
                data.set("stoppingCondition", om.valueToTree(this.getStoppingCondition()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpcConfig() != null) {
                data.set("vpcConfig", om.valueToTree(this.getVpcConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.SagemakerTrainTaskProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SagemakerTrainTaskProps.Jsii$Proxy that = (SagemakerTrainTaskProps.Jsii$Proxy) o;

            if (!algorithmSpecification.equals(that.algorithmSpecification)) return false;
            if (!inputDataConfig.equals(that.inputDataConfig)) return false;
            if (!outputDataConfig.equals(that.outputDataConfig)) return false;
            if (!trainingJobName.equals(that.trainingJobName)) return false;
            if (this.hyperparameters != null ? !this.hyperparameters.equals(that.hyperparameters) : that.hyperparameters != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.resourceConfig != null ? !this.resourceConfig.equals(that.resourceConfig) : that.resourceConfig != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.stoppingCondition != null ? !this.stoppingCondition.equals(that.stoppingCondition) : that.stoppingCondition != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vpcConfig != null ? this.vpcConfig.equals(that.vpcConfig) : that.vpcConfig == null;
        }

        @Override
        public int hashCode() {
            int result = this.algorithmSpecification.hashCode();
            result = 31 * result + (this.inputDataConfig.hashCode());
            result = 31 * result + (this.outputDataConfig.hashCode());
            result = 31 * result + (this.trainingJobName.hashCode());
            result = 31 * result + (this.hyperparameters != null ? this.hyperparameters.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.resourceConfig != null ? this.resourceConfig.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.stoppingCondition != null ? this.stoppingCondition.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpcConfig != null ? this.vpcConfig.hashCode() : 0);
            return result;
        }
    }
}
