package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Class representing the SageMaker Create Training Job task.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.3.2 (build 237c474)", date = "2020-04-21T17:16:26.707Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.SagemakerTransformTask")
public class SagemakerTransformTask extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.IStepFunctionsTask {

    protected SagemakerTransformTask(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SagemakerTransformTask(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SagemakerTransformTask(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.SagemakerTransformProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Called when the task object is used in a workflow.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param task This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Task task) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig.class, new Object[] { java.util.Objects.requireNonNull(task, "task is required") });
    }

    /**
     * The execution role for the Sagemaker training job.
     * <p>
     * Only available after task has been added to a state machine.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole() {
        return this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.SagemakerTransformTask}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        /**
         * EXPERIMENTAL
         * <p>
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.stepfunctions.tasks.SagemakerTransformProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.stepfunctions.tasks.SagemakerTransformProps.Builder();
        }

        /**
         * Name of the model that you want to use for the transform job.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param modelName Name of the model that you want to use for the transform job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder modelName(final java.lang.String modelName) {
            this.props.modelName(modelName);
            return this;
        }

        /**
         * Dataset to be transformed and the Amazon S3 location where it is stored.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param transformInput Dataset to be transformed and the Amazon S3 location where it is stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder transformInput(final software.amazon.awscdk.services.stepfunctions.tasks.TransformInput transformInput) {
            this.props.transformInput(transformInput);
            return this;
        }

        /**
         * Training Job Name.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param transformJobName Training Job Name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder transformJobName(final java.lang.String transformJobName) {
            this.props.transformJobName(transformJobName);
            return this;
        }

        /**
         * S3 location where you want Amazon SageMaker to save the results from the transform job.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param transformOutput S3 location where you want Amazon SageMaker to save the results from the transform job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder transformOutput(final software.amazon.awscdk.services.stepfunctions.tasks.TransformOutput transformOutput) {
            this.props.transformOutput(transformOutput);
            return this;
        }

        /**
         * Number of records to include in a mini-batch for an HTTP inference request.
         * <p>
         * Default: - No batch strategy
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param batchStrategy Number of records to include in a mini-batch for an HTTP inference request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder batchStrategy(final software.amazon.awscdk.services.stepfunctions.tasks.BatchStrategy batchStrategy) {
            this.props.batchStrategy(batchStrategy);
            return this;
        }

        /**
         * Environment variables to set in the Docker container.
         * <p>
         * Default: - No environment variables
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param environment Environment variables to set in the Docker container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environment(final java.util.Map<java.lang.String, java.lang.String> environment) {
            this.props.environment(environment);
            return this;
        }

        /**
         * The service integration pattern indicates different ways to call SageMaker APIs.
         * <p>
         * The valid value is either FIRE_AND_FORGET or SYNC.
         * <p>
         * Default: FIRE_AND_FORGET
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param integrationPattern The service integration pattern indicates different ways to call SageMaker APIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integrationPattern(final software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        /**
         * Maximum number of parallel requests that can be sent to each instance in a transform job.
         * <p>
         * Default: - Amazon SageMaker checks the optional execution-parameters to determine the settings for your chosen algorithm.
         * If the execution-parameters endpoint is not enabled, the default value is 1.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param maxConcurrentTransforms Maximum number of parallel requests that can be sent to each instance in a transform job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxConcurrentTransforms(final java.lang.Number maxConcurrentTransforms) {
            this.props.maxConcurrentTransforms(maxConcurrentTransforms);
            return this;
        }

        /**
         * Maximum allowed size of the payload, in MB.
         * <p>
         * Default: 6
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param maxPayloadInMb Maximum allowed size of the payload, in MB. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxPayloadInMb(final java.lang.Number maxPayloadInMb) {
            this.props.maxPayloadInMb(maxPayloadInMb);
            return this;
        }

        /**
         * Role for the Training Job.
         * <p>
         * Default: - A role is created with `AmazonSageMakerFullAccess` managed policy
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param role Role for the Training Job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * Tags to be applied to the train job.
         * <p>
         * Default: - No tags
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param tags Tags to be applied to the train job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * ML compute instances for the transform job.
         * <p>
         * Default: - 1 instance of type M4.XLarge
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param transformResources ML compute instances for the transform job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder transformResources(final software.amazon.awscdk.services.stepfunctions.tasks.TransformResources transformResources) {
            this.props.transformResources(transformResources);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.SagemakerTransformTask}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.stepfunctions.tasks.SagemakerTransformTask build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.SagemakerTransformTask(
                this.props.build()
            );
        }
    }
}
