package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * A StepFunctions Task to send messages to SQS queue.
 * <p>
 * A Function can be used directly as a Resource, but this class mirrors
 * integration with other AWS services via a specific class instance.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.3.2 (build 237c474)", date = "2020-04-21T17:16:26.707Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.SendToQueue")
public class SendToQueue extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.IStepFunctionsTask {

    protected SendToQueue(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SendToQueue(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * <p>
     * @param queue This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SendToQueue(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue queue, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.SendToQueueProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(queue, "queue is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Called when the task object is used in a workflow.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param _task This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Task _task) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig.class, new Object[] { java.util.Objects.requireNonNull(_task, "_task is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.SendToQueue}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        /**
         * EXPERIMENTAL
         * <p>
         * @return a new instance of {@link Builder}.
         * @param queue This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.services.sqs.IQueue queue) {
            return new Builder(queue);
        }

        private final software.amazon.awscdk.services.sqs.IQueue queue;
        private final software.amazon.awscdk.services.stepfunctions.tasks.SendToQueueProps.Builder props;

        private Builder(final software.amazon.awscdk.services.sqs.IQueue queue) {
            this.queue = queue;
            this.props = new software.amazon.awscdk.services.stepfunctions.tasks.SendToQueueProps.Builder();
        }

        /**
         * The text message to send to the queue.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param messageBody The text message to send to the queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder messageBody(final software.amazon.awscdk.services.stepfunctions.TaskInput messageBody) {
            this.props.messageBody(messageBody);
            return this;
        }

        /**
         * The length of time, in seconds, for which to delay a specific message.
         * <p>
         * Valid values are 0-900 seconds.
         * <p>
         * Default: Default value of the queue is used
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param delay The length of time, in seconds, for which to delay a specific message. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder delay(final software.amazon.awscdk.core.Duration delay) {
            this.props.delay(delay);
            return this;
        }

        /**
         * The service integration pattern indicates different ways to call SendMessage to SQS.
         * <p>
         * The valid value is either FIRE_AND_FORGET or WAIT_FOR_TASK_TOKEN.
         * <p>
         * Default: FIRE_AND_FORGET
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param integrationPattern The service integration pattern indicates different ways to call SendMessage to SQS. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integrationPattern(final software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        /**
         * The token used for deduplication of sent messages.
         * <p>
         * Default: Use content-based deduplication
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param messageDeduplicationId The token used for deduplication of sent messages. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder messageDeduplicationId(final java.lang.String messageDeduplicationId) {
            this.props.messageDeduplicationId(messageDeduplicationId);
            return this;
        }

        /**
         * The tag that specifies that a message belongs to a specific message group.
         * <p>
         * Required for FIFO queues. FIFO ordering applies to messages in the same message
         * group.
         * <p>
         * Default: No group ID
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param messageGroupId The tag that specifies that a message belongs to a specific message group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder messageGroupId(final java.lang.String messageGroupId) {
            this.props.messageGroupId(messageGroupId);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.SendToQueue}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.stepfunctions.tasks.SendToQueue build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.SendToQueue(
                this.queue,
                this.props.build()
            );
        }
    }
}
