package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * ML compute instances for the transform job.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.3.2 (build 237c474)", date = "2020-04-21T17:16:26.719Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.TransformResources")
@software.amazon.jsii.Jsii.Proxy(TransformResources.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface TransformResources extends software.amazon.jsii.JsiiSerializable {

    /**
     * Number of ML compute instances to use in the transform job.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Number getInstanceCount();

    /**
     * ML compute instance type for the transform job.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceType getInstanceType();

    /**
     * AWS KMS key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s).
     * <p>
     * Default: - None
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.Key getVolumeKmsKeyId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TransformResources}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TransformResources}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private java.lang.Number instanceCount;
        private software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private software.amazon.awscdk.services.kms.Key volumeKmsKeyId;

        /**
         * Sets the value of {@link TransformResources#getInstanceCount}
         * @param instanceCount Number of ML compute instances to use in the transform job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceCount(java.lang.Number instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        /**
         * Sets the value of {@link TransformResources#getInstanceType}
         * @param instanceType ML compute instance type for the transform job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link TransformResources#getVolumeKmsKeyId}
         * @param volumeKmsKeyId AWS KMS key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder volumeKmsKeyId(software.amazon.awscdk.services.kms.Key volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TransformResources}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public TransformResources build() {
            return new Jsii$Proxy(instanceCount, instanceType, volumeKmsKeyId);
        }
    }

    /**
     * An implementation for {@link TransformResources}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransformResources {
        private final java.lang.Number instanceCount;
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final software.amazon.awscdk.services.kms.Key volumeKmsKeyId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceCount = this.jsiiGet("instanceCount", java.lang.Number.class);
            this.instanceType = this.jsiiGet("instanceType", software.amazon.awscdk.services.ec2.InstanceType.class);
            this.volumeKmsKeyId = this.jsiiGet("volumeKmsKeyId", software.amazon.awscdk.services.kms.Key.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Number instanceCount, final software.amazon.awscdk.services.ec2.InstanceType instanceType, final software.amazon.awscdk.services.kms.Key volumeKmsKeyId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceCount = java.util.Objects.requireNonNull(instanceCount, "instanceCount is required");
            this.instanceType = java.util.Objects.requireNonNull(instanceType, "instanceType is required");
            this.volumeKmsKeyId = volumeKmsKeyId;
        }

        @Override
        public java.lang.Number getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public software.amazon.awscdk.services.kms.Key getVolumeKmsKeyId() {
            return this.volumeKmsKeyId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            if (this.getVolumeKmsKeyId() != null) {
                data.set("volumeKmsKeyId", om.valueToTree(this.getVolumeKmsKeyId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.TransformResources"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TransformResources.Jsii$Proxy that = (TransformResources.Jsii$Proxy) o;

            if (!instanceCount.equals(that.instanceCount)) return false;
            if (!instanceType.equals(that.instanceType)) return false;
            return this.volumeKmsKeyId != null ? this.volumeKmsKeyId.equals(that.volumeKmsKeyId) : that.volumeKmsKeyId == null;
        }

        @Override
        public int hashCode() {
            int result = this.instanceCount.hashCode();
            result = 31 * result + (this.instanceType.hashCode());
            result = 31 * result + (this.volumeKmsKeyId != null ? this.volumeKmsKeyId.hashCode() : 0);
            return result;
        }
    }
}
