package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Construction properties for the BaseRunTaskProps.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-04-24T11:27:14.370Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EcsRunTaskBaseProps")
@software.amazon.jsii.Jsii.Proxy(EcsRunTaskBaseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface EcsRunTaskBaseProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.tasks.CommonEcsRunTaskProps {

    /**
     * Additional parameters to pass to the base task.
     * <p>
     * Default: - No additional parameters passed
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getParameters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EcsRunTaskBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EcsRunTaskBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private java.util.Map<java.lang.String, java.lang.Object> parameters;
        private software.amazon.awscdk.services.ecs.ICluster cluster;
        private software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition;
        private java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ContainerOverride> containerOverrides;
        private software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern;

        /**
         * Sets the value of {@link EcsRunTaskBaseProps#getParameters}
         * @param parameters Additional parameters to pass to the base task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameters(java.util.Map<java.lang.String, java.lang.Object> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link EcsRunTaskBaseProps#getCluster}
         * @param cluster The topic to run the task on. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cluster(software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link EcsRunTaskBaseProps#getTaskDefinition}
         * @param taskDefinition Task Definition used for running tasks in the service. This parameter is required.
         *                       Note: this must be TaskDefinition, and not ITaskDefinition,
         *                       as it requires properties that are not known for imported task definitions
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder taskDefinition(software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        /**
         * Sets the value of {@link EcsRunTaskBaseProps#getContainerOverrides}
         * @param containerOverrides Container setting overrides.
         *                           Key is the name of the container to override, value is the
         *                           values you want to override.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder containerOverrides(java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ContainerOverride> containerOverrides) {
            this.containerOverrides = containerOverrides;
            return this;
        }

        /**
         * Sets the value of {@link EcsRunTaskBaseProps#getIntegrationPattern}
         * @param integrationPattern The service integration pattern indicates different ways to call RunTask in ECS.
         *                           The valid value for Lambda is FIRE_AND_FORGET, SYNC and WAIT_FOR_TASK_TOKEN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EcsRunTaskBaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public EcsRunTaskBaseProps build() {
            return new Jsii$Proxy(parameters, cluster, taskDefinition, containerOverrides, integrationPattern);
        }
    }

    /**
     * An implementation for {@link EcsRunTaskBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsRunTaskBaseProps {
        private final java.util.Map<java.lang.String, java.lang.Object> parameters;
        private final software.amazon.awscdk.services.ecs.ICluster cluster;
        private final software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition;
        private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ContainerOverride> containerOverrides;
        private final software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.parameters = this.jsiiGet("parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.cluster = this.jsiiGet("cluster", software.amazon.awscdk.services.ecs.ICluster.class);
            this.taskDefinition = this.jsiiGet("taskDefinition", software.amazon.awscdk.services.ecs.TaskDefinition.class);
            this.containerOverrides = this.jsiiGet("containerOverrides", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.ContainerOverride.class)));
            this.integrationPattern = this.jsiiGet("integrationPattern", software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.util.Map<java.lang.String, java.lang.Object> parameters, final software.amazon.awscdk.services.ecs.ICluster cluster, final software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition, final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ContainerOverride> containerOverrides, final software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.parameters = parameters;
            this.cluster = java.util.Objects.requireNonNull(cluster, "cluster is required");
            this.taskDefinition = java.util.Objects.requireNonNull(taskDefinition, "taskDefinition is required");
            this.containerOverrides = containerOverrides;
            this.integrationPattern = integrationPattern;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.Object> getParameters() {
            return this.parameters;
        }

        @Override
        public software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public software.amazon.awscdk.services.ecs.TaskDefinition getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ContainerOverride> getContainerOverrides() {
            return this.containerOverrides;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            data.set("cluster", om.valueToTree(this.getCluster()));
            data.set("taskDefinition", om.valueToTree(this.getTaskDefinition()));
            if (this.getContainerOverrides() != null) {
                data.set("containerOverrides", om.valueToTree(this.getContainerOverrides()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EcsRunTaskBaseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EcsRunTaskBaseProps.Jsii$Proxy that = (EcsRunTaskBaseProps.Jsii$Proxy) o;

            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (!cluster.equals(that.cluster)) return false;
            if (!taskDefinition.equals(that.taskDefinition)) return false;
            if (this.containerOverrides != null ? !this.containerOverrides.equals(that.containerOverrides) : that.containerOverrides != null) return false;
            return this.integrationPattern != null ? this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern == null;
        }

        @Override
        public int hashCode() {
            int result = this.parameters != null ? this.parameters.hashCode() : 0;
            result = 31 * result + (this.cluster.hashCode());
            result = 31 * result + (this.taskDefinition.hashCode());
            result = 31 * result + (this.containerOverrides != null ? this.containerOverrides.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            return result;
        }
    }
}
