package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for EmrAddStep.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-04-24T11:27:14.371Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrAddStepProps")
@software.amazon.jsii.Jsii.Proxy(EmrAddStepProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface EmrAddStepProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ClusterId to add the Step to.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterId();

    /**
     * A path to a JAR file run during the step.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_HadoopJarStepConfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getJar();

    /**
     * The name of the Step.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_StepConfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The action to take when the cluster step fails.
     * <p>
     * Default: CONTINUE
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_StepConfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.ActionOnFailure getActionOnFailure() {
        return null;
    }

    /**
     * A list of command line arguments passed to the JAR file's main function when executed.
     * <p>
     * Default: No args
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_HadoopJarStepConfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArgs() {
        return null;
    }

    /**
     * The service integration pattern indicates different ways to call AddStep.
     * <p>
     * The valid value is either FIRE_AND_FORGET or SYNC.
     * <p>
     * Default: SYNC
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern getIntegrationPattern() {
        return null;
    }

    /**
     * The name of the main class in the specified Java file.
     * <p>
     * If not specified, the JAR file should specify a Main-Class in its manifest file.
     * <p>
     * Default: No mainClass
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_HadoopJarStepConfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getMainClass() {
        return null;
    }

    /**
     * A list of Java properties that are set when the step runs.
     * <p>
     * You can use these properties to pass key value pairs to your main function.
     * <p>
     * Default: No properties
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_HadoopJarStepConfig.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getProperties() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EmrAddStepProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EmrAddStepProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private java.lang.String clusterId;
        private java.lang.String jar;
        private java.lang.String name;
        private software.amazon.awscdk.services.stepfunctions.tasks.ActionOnFailure actionOnFailure;
        private java.util.List<java.lang.String> args;
        private software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern;
        private java.lang.String mainClass;
        private java.util.Map<java.lang.String, java.lang.String> properties;

        /**
         * Sets the value of {@link EmrAddStepProps#getClusterId}
         * @param clusterId The ClusterId to add the Step to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        /**
         * Sets the value of {@link EmrAddStepProps#getJar}
         * @param jar A path to a JAR file run during the step. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jar(java.lang.String jar) {
            this.jar = jar;
            return this;
        }

        /**
         * Sets the value of {@link EmrAddStepProps#getName}
         * @param name The name of the Step. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link EmrAddStepProps#getActionOnFailure}
         * @param actionOnFailure The action to take when the cluster step fails.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder actionOnFailure(software.amazon.awscdk.services.stepfunctions.tasks.ActionOnFailure actionOnFailure) {
            this.actionOnFailure = actionOnFailure;
            return this;
        }

        /**
         * Sets the value of {@link EmrAddStepProps#getArgs}
         * @param args A list of command line arguments passed to the JAR file's main function when executed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder args(java.util.List<java.lang.String> args) {
            this.args = args;
            return this;
        }

        /**
         * Sets the value of {@link EmrAddStepProps#getIntegrationPattern}
         * @param integrationPattern The service integration pattern indicates different ways to call AddStep.
         *                           The valid value is either FIRE_AND_FORGET or SYNC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link EmrAddStepProps#getMainClass}
         * @param mainClass The name of the main class in the specified Java file.
         *                  If not specified, the JAR file should specify a Main-Class in its manifest file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mainClass(java.lang.String mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        /**
         * Sets the value of {@link EmrAddStepProps#getProperties}
         * @param properties A list of Java properties that are set when the step runs.
         *                   You can use these properties to pass key value pairs to your main function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder properties(java.util.Map<java.lang.String, java.lang.String> properties) {
            this.properties = properties;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EmrAddStepProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public EmrAddStepProps build() {
            return new Jsii$Proxy(clusterId, jar, name, actionOnFailure, args, integrationPattern, mainClass, properties);
        }
    }

    /**
     * An implementation for {@link EmrAddStepProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmrAddStepProps {
        private final java.lang.String clusterId;
        private final java.lang.String jar;
        private final java.lang.String name;
        private final software.amazon.awscdk.services.stepfunctions.tasks.ActionOnFailure actionOnFailure;
        private final java.util.List<java.lang.String> args;
        private final software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern;
        private final java.lang.String mainClass;
        private final java.util.Map<java.lang.String, java.lang.String> properties;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterId = this.jsiiGet("clusterId", java.lang.String.class);
            this.jar = this.jsiiGet("jar", java.lang.String.class);
            this.name = this.jsiiGet("name", java.lang.String.class);
            this.actionOnFailure = this.jsiiGet("actionOnFailure", software.amazon.awscdk.services.stepfunctions.tasks.ActionOnFailure.class);
            this.args = this.jsiiGet("args", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.integrationPattern = this.jsiiGet("integrationPattern", software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern.class);
            this.mainClass = this.jsiiGet("mainClass", java.lang.String.class);
            this.properties = this.jsiiGet("properties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String clusterId, final java.lang.String jar, final java.lang.String name, final software.amazon.awscdk.services.stepfunctions.tasks.ActionOnFailure actionOnFailure, final java.util.List<java.lang.String> args, final software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern, final java.lang.String mainClass, final java.util.Map<java.lang.String, java.lang.String> properties) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterId = java.util.Objects.requireNonNull(clusterId, "clusterId is required");
            this.jar = java.util.Objects.requireNonNull(jar, "jar is required");
            this.name = java.util.Objects.requireNonNull(name, "name is required");
            this.actionOnFailure = actionOnFailure;
            this.args = args;
            this.integrationPattern = integrationPattern;
            this.mainClass = mainClass;
            this.properties = properties;
        }

        @Override
        public java.lang.String getClusterId() {
            return this.clusterId;
        }

        @Override
        public java.lang.String getJar() {
            return this.jar;
        }

        @Override
        public java.lang.String getName() {
            return this.name;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.ActionOnFailure getActionOnFailure() {
            return this.actionOnFailure;
        }

        @Override
        public java.util.List<java.lang.String> getArgs() {
            return this.args;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public java.lang.String getMainClass() {
            return this.mainClass;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getProperties() {
            return this.properties;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterId", om.valueToTree(this.getClusterId()));
            data.set("jar", om.valueToTree(this.getJar()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getActionOnFailure() != null) {
                data.set("actionOnFailure", om.valueToTree(this.getActionOnFailure()));
            }
            if (this.getArgs() != null) {
                data.set("args", om.valueToTree(this.getArgs()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getMainClass() != null) {
                data.set("mainClass", om.valueToTree(this.getMainClass()));
            }
            if (this.getProperties() != null) {
                data.set("properties", om.valueToTree(this.getProperties()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrAddStepProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EmrAddStepProps.Jsii$Proxy that = (EmrAddStepProps.Jsii$Proxy) o;

            if (!clusterId.equals(that.clusterId)) return false;
            if (!jar.equals(that.jar)) return false;
            if (!name.equals(that.name)) return false;
            if (this.actionOnFailure != null ? !this.actionOnFailure.equals(that.actionOnFailure) : that.actionOnFailure != null) return false;
            if (this.args != null ? !this.args.equals(that.args) : that.args != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.mainClass != null ? !this.mainClass.equals(that.mainClass) : that.mainClass != null) return false;
            return this.properties != null ? this.properties.equals(that.properties) : that.properties == null;
        }

        @Override
        public int hashCode() {
            int result = this.clusterId.hashCode();
            result = 31 * result + (this.jar.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.actionOnFailure != null ? this.actionOnFailure.hashCode() : 0);
            result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.mainClass != null ? this.mainClass.hashCode() : 0);
            result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
            return result;
        }
    }
}
