package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * A Step Functions Task to to modify an InstanceGroup on an EMR Cluster.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-04-24T11:27:14.380Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrModifyInstanceGroupByName")
public class EmrModifyInstanceGroupByName extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.IStepFunctionsTask {

    protected EmrModifyInstanceGroupByName(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EmrModifyInstanceGroupByName(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public EmrModifyInstanceGroupByName(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByNameProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Called when the task object is used in a workflow.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param _task This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Task _task) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig.class, new Object[] { java.util.Objects.requireNonNull(_task, "_task is required") });
    }
    /**
     * Modify the size or configurations of an instance group.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceGroupModifyConfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrModifyInstanceGroupByName.InstanceGroupModifyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceGroupModifyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface InstanceGroupModifyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of new or modified configurations to apply for an instance group.
         * <p>
         * Default: No configurations
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> getConfigurations() {
            return null;
        }

        /**
         * The EC2 InstanceIds to terminate.
         * <p>
         * After you terminate the instances, the instance group will not return to its original requested size.
         * <p>
         * Default: No eC2InstanceIdsToTerminate
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEC2InstanceIdsToTerminate() {
            return null;
        }

        /**
         * Target size for the instance group.
         * <p>
         * Default: No instanceCount
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInstanceCount() {
            return null;
        }

        /**
         * Policy for customizing shrink operations.
         * <p>
         * Default: No shrinkPolicy
         * <p>
         * EXPERIMENTAL
         * <p>
         * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_ShrinkPolicy.html
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.ShrinkPolicyProperty getShrinkPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceGroupModifyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceGroupModifyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder {
            private java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations;
            private java.util.List<java.lang.String> eC2InstanceIdsToTerminate;
            private java.lang.Number instanceCount;
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.ShrinkPolicyProperty shrinkPolicy;

            /**
             * Sets the value of {@link InstanceGroupModifyConfigProperty#getConfigurations}
             * @param configurations A list of new or modified configurations to apply for an instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder configurations(java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations) {
                this.configurations = configurations;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupModifyConfigProperty#getEC2InstanceIdsToTerminate}
             * @param eC2InstanceIdsToTerminate The EC2 InstanceIds to terminate.
             *                                  After you terminate the instances, the instance group will not return to its original requested size.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder eC2InstanceIdsToTerminate(java.util.List<java.lang.String> eC2InstanceIdsToTerminate) {
                this.eC2InstanceIdsToTerminate = eC2InstanceIdsToTerminate;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupModifyConfigProperty#getInstanceCount}
             * @param instanceCount Target size for the instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder instanceCount(java.lang.Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceGroupModifyConfigProperty#getShrinkPolicy}
             * @param shrinkPolicy Policy for customizing shrink operations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder shrinkPolicy(software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.ShrinkPolicyProperty shrinkPolicy) {
                this.shrinkPolicy = shrinkPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceGroupModifyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public InstanceGroupModifyConfigProperty build() {
                return new Jsii$Proxy(configurations, eC2InstanceIdsToTerminate, instanceCount, shrinkPolicy);
            }
        }

        /**
         * An implementation for {@link InstanceGroupModifyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceGroupModifyConfigProperty {
            private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations;
            private final java.util.List<java.lang.String> eC2InstanceIdsToTerminate;
            private final java.lang.Number instanceCount;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.ShrinkPolicyProperty shrinkPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.configurations = this.jsiiGet("configurations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty.class)));
                this.eC2InstanceIdsToTerminate = this.jsiiGet("eC2InstanceIdsToTerminate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.instanceCount = this.jsiiGet("instanceCount", java.lang.Number.class);
                this.shrinkPolicy = this.jsiiGet("shrinkPolicy", software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.ShrinkPolicyProperty.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations, final java.util.List<java.lang.String> eC2InstanceIdsToTerminate, final java.lang.Number instanceCount, final software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.ShrinkPolicyProperty shrinkPolicy) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configurations = configurations;
                this.eC2InstanceIdsToTerminate = eC2InstanceIdsToTerminate;
                this.instanceCount = instanceCount;
                this.shrinkPolicy = shrinkPolicy;
            }

            @Override
            public java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> getConfigurations() {
                return this.configurations;
            }

            @Override
            public java.util.List<java.lang.String> getEC2InstanceIdsToTerminate() {
                return this.eC2InstanceIdsToTerminate;
            }

            @Override
            public java.lang.Number getInstanceCount() {
                return this.instanceCount;
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.ShrinkPolicyProperty getShrinkPolicy() {
                return this.shrinkPolicy;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConfigurations() != null) {
                    data.set("configurations", om.valueToTree(this.getConfigurations()));
                }
                if (this.getEC2InstanceIdsToTerminate() != null) {
                    data.set("eC2InstanceIdsToTerminate", om.valueToTree(this.getEC2InstanceIdsToTerminate()));
                }
                if (this.getInstanceCount() != null) {
                    data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
                }
                if (this.getShrinkPolicy() != null) {
                    data.set("shrinkPolicy", om.valueToTree(this.getShrinkPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrModifyInstanceGroupByName.InstanceGroupModifyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceGroupModifyConfigProperty.Jsii$Proxy that = (InstanceGroupModifyConfigProperty.Jsii$Proxy) o;

                if (this.configurations != null ? !this.configurations.equals(that.configurations) : that.configurations != null) return false;
                if (this.eC2InstanceIdsToTerminate != null ? !this.eC2InstanceIdsToTerminate.equals(that.eC2InstanceIdsToTerminate) : that.eC2InstanceIdsToTerminate != null) return false;
                if (this.instanceCount != null ? !this.instanceCount.equals(that.instanceCount) : that.instanceCount != null) return false;
                return this.shrinkPolicy != null ? this.shrinkPolicy.equals(that.shrinkPolicy) : that.shrinkPolicy == null;
            }

            @Override
            public int hashCode() {
                int result = this.configurations != null ? this.configurations.hashCode() : 0;
                result = 31 * result + (this.eC2InstanceIdsToTerminate != null ? this.eC2InstanceIdsToTerminate.hashCode() : 0);
                result = 31 * result + (this.instanceCount != null ? this.instanceCount.hashCode() : 0);
                result = 31 * result + (this.shrinkPolicy != null ? this.shrinkPolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Custom policy for requesting termination protection or termination of specific instances when shrinking an instance group.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceResizePolicy.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrModifyInstanceGroupByName.InstanceResizePolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceResizePolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface InstanceResizePolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specific list of instances to be protected when shrinking an instance group.
         * <p>
         * Default: No instancesToProtect
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstancesToProtect() {
            return null;
        }

        /**
         * Specific list of instances to be terminated when shrinking an instance group.
         * <p>
         * Default: No instancesToTerminate
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstancesToTerminate() {
            return null;
        }

        /**
         * Decommissioning timeout override for the specific list of instances to be terminated.
         * <p>
         * Default: EMR selected default
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getInstanceTerminationTimeout() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceResizePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceResizePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder {
            private java.util.List<java.lang.String> instancesToProtect;
            private java.util.List<java.lang.String> instancesToTerminate;
            private software.amazon.awscdk.core.Duration instanceTerminationTimeout;

            /**
             * Sets the value of {@link InstanceResizePolicyProperty#getInstancesToProtect}
             * @param instancesToProtect Specific list of instances to be protected when shrinking an instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder instancesToProtect(java.util.List<java.lang.String> instancesToProtect) {
                this.instancesToProtect = instancesToProtect;
                return this;
            }

            /**
             * Sets the value of {@link InstanceResizePolicyProperty#getInstancesToTerminate}
             * @param instancesToTerminate Specific list of instances to be terminated when shrinking an instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder instancesToTerminate(java.util.List<java.lang.String> instancesToTerminate) {
                this.instancesToTerminate = instancesToTerminate;
                return this;
            }

            /**
             * Sets the value of {@link InstanceResizePolicyProperty#getInstanceTerminationTimeout}
             * @param instanceTerminationTimeout Decommissioning timeout override for the specific list of instances to be terminated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder instanceTerminationTimeout(software.amazon.awscdk.core.Duration instanceTerminationTimeout) {
                this.instanceTerminationTimeout = instanceTerminationTimeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceResizePolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public InstanceResizePolicyProperty build() {
                return new Jsii$Proxy(instancesToProtect, instancesToTerminate, instanceTerminationTimeout);
            }
        }

        /**
         * An implementation for {@link InstanceResizePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceResizePolicyProperty {
            private final java.util.List<java.lang.String> instancesToProtect;
            private final java.util.List<java.lang.String> instancesToTerminate;
            private final software.amazon.awscdk.core.Duration instanceTerminationTimeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instancesToProtect = this.jsiiGet("instancesToProtect", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.instancesToTerminate = this.jsiiGet("instancesToTerminate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.instanceTerminationTimeout = this.jsiiGet("instanceTerminationTimeout", software.amazon.awscdk.core.Duration.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.util.List<java.lang.String> instancesToProtect, final java.util.List<java.lang.String> instancesToTerminate, final software.amazon.awscdk.core.Duration instanceTerminationTimeout) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instancesToProtect = instancesToProtect;
                this.instancesToTerminate = instancesToTerminate;
                this.instanceTerminationTimeout = instanceTerminationTimeout;
            }

            @Override
            public java.util.List<java.lang.String> getInstancesToProtect() {
                return this.instancesToProtect;
            }

            @Override
            public java.util.List<java.lang.String> getInstancesToTerminate() {
                return this.instancesToTerminate;
            }

            @Override
            public software.amazon.awscdk.core.Duration getInstanceTerminationTimeout() {
                return this.instanceTerminationTimeout;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInstancesToProtect() != null) {
                    data.set("instancesToProtect", om.valueToTree(this.getInstancesToProtect()));
                }
                if (this.getInstancesToTerminate() != null) {
                    data.set("instancesToTerminate", om.valueToTree(this.getInstancesToTerminate()));
                }
                if (this.getInstanceTerminationTimeout() != null) {
                    data.set("instanceTerminationTimeout", om.valueToTree(this.getInstanceTerminationTimeout()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrModifyInstanceGroupByName.InstanceResizePolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceResizePolicyProperty.Jsii$Proxy that = (InstanceResizePolicyProperty.Jsii$Proxy) o;

                if (this.instancesToProtect != null ? !this.instancesToProtect.equals(that.instancesToProtect) : that.instancesToProtect != null) return false;
                if (this.instancesToTerminate != null ? !this.instancesToTerminate.equals(that.instancesToTerminate) : that.instancesToTerminate != null) return false;
                return this.instanceTerminationTimeout != null ? this.instanceTerminationTimeout.equals(that.instanceTerminationTimeout) : that.instanceTerminationTimeout == null;
            }

            @Override
            public int hashCode() {
                int result = this.instancesToProtect != null ? this.instancesToProtect.hashCode() : 0;
                result = 31 * result + (this.instancesToTerminate != null ? this.instancesToTerminate.hashCode() : 0);
                result = 31 * result + (this.instanceTerminationTimeout != null ? this.instanceTerminationTimeout.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Policy for customizing shrink operations.
     * <p>
     * Allows configuration of decommissioning timeout and targeted instance shrinking.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_ShrinkPolicy.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrModifyInstanceGroupByName.ShrinkPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ShrinkPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static interface ShrinkPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The desired timeout for decommissioning an instance.
         * <p>
         * Overrides the default YARN decommissioning timeout.
         * <p>
         * Default: EMR selected default
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getDecommissionTimeout() {
            return null;
        }

        /**
         * Custom policy for requesting termination protection or termination of specific instances when shrinking an instance group.
         * <p>
         * Default: No instanceResizePolicy
         * <p>
         * EXPERIMENTAL
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.InstanceResizePolicyProperty getInstanceResizePolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ShrinkPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ShrinkPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static final class Builder {
            private software.amazon.awscdk.core.Duration decommissionTimeout;
            private software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.InstanceResizePolicyProperty instanceResizePolicy;

            /**
             * Sets the value of {@link ShrinkPolicyProperty#getDecommissionTimeout}
             * @param decommissionTimeout The desired timeout for decommissioning an instance.
             *                            Overrides the default YARN decommissioning timeout.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder decommissionTimeout(software.amazon.awscdk.core.Duration decommissionTimeout) {
                this.decommissionTimeout = decommissionTimeout;
                return this;
            }

            /**
             * Sets the value of {@link ShrinkPolicyProperty#getInstanceResizePolicy}
             * @param instanceResizePolicy Custom policy for requesting termination protection or termination of specific instances when shrinking an instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public Builder instanceResizePolicy(software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.InstanceResizePolicyProperty instanceResizePolicy) {
                this.instanceResizePolicy = instanceResizePolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ShrinkPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
            public ShrinkPolicyProperty build() {
                return new Jsii$Proxy(decommissionTimeout, instanceResizePolicy);
            }
        }

        /**
         * An implementation for {@link ShrinkPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ShrinkPolicyProperty {
            private final software.amazon.awscdk.core.Duration decommissionTimeout;
            private final software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.InstanceResizePolicyProperty instanceResizePolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.decommissionTimeout = this.jsiiGet("decommissionTimeout", software.amazon.awscdk.core.Duration.class);
                this.instanceResizePolicy = this.jsiiGet("instanceResizePolicy", software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.InstanceResizePolicyProperty.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final software.amazon.awscdk.core.Duration decommissionTimeout, final software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.InstanceResizePolicyProperty instanceResizePolicy) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.decommissionTimeout = decommissionTimeout;
                this.instanceResizePolicy = instanceResizePolicy;
            }

            @Override
            public software.amazon.awscdk.core.Duration getDecommissionTimeout() {
                return this.decommissionTimeout;
            }

            @Override
            public software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.InstanceResizePolicyProperty getInstanceResizePolicy() {
                return this.instanceResizePolicy;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDecommissionTimeout() != null) {
                    data.set("decommissionTimeout", om.valueToTree(this.getDecommissionTimeout()));
                }
                if (this.getInstanceResizePolicy() != null) {
                    data.set("instanceResizePolicy", om.valueToTree(this.getInstanceResizePolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrModifyInstanceGroupByName.ShrinkPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ShrinkPolicyProperty.Jsii$Proxy that = (ShrinkPolicyProperty.Jsii$Proxy) o;

                if (this.decommissionTimeout != null ? !this.decommissionTimeout.equals(that.decommissionTimeout) : that.decommissionTimeout != null) return false;
                return this.instanceResizePolicy != null ? this.instanceResizePolicy.equals(that.instanceResizePolicy) : that.instanceResizePolicy == null;
            }

            @Override
            public int hashCode() {
                int result = this.decommissionTimeout != null ? this.decommissionTimeout.hashCode() : 0;
                result = 31 * result + (this.instanceResizePolicy != null ? this.instanceResizePolicy.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        /**
         * EXPERIMENTAL
         * <p>
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByNameProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByNameProps.Builder();
        }

        /**
         * The ClusterId to update.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param clusterId The ClusterId to update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterId(final java.lang.String clusterId) {
            this.props.clusterId(clusterId);
            return this;
        }

        /**
         * The JSON that you want to provide to your ModifyInstanceGroup call as input.
         * <p>
         * This uses the same syntax as the ModifyInstanceGroups API.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_ModifyInstanceGroups.html
         * @param instanceGroup The JSON that you want to provide to your ModifyInstanceGroup call as input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceGroup(final software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName.InstanceGroupModifyConfigProperty instanceGroup) {
            this.props.instanceGroup(instanceGroup);
            return this;
        }

        /**
         * The InstanceGroupName to update.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param instanceGroupName The InstanceGroupName to update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceGroupName(final java.lang.String instanceGroupName) {
            this.props.instanceGroupName(instanceGroupName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.EmrModifyInstanceGroupByName(
                this.props.build()
            );
        }
    }
}
