package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * A Step Functions Task to publish messages to SNS topic.
 * <p>
 * A Function can be used directly as a Resource, but this class mirrors
 * integration with other AWS services via a specific class instance.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-04-24T11:27:14.383Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.PublishToTopic")
public class PublishToTopic extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.IStepFunctionsTask {

    protected PublishToTopic(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PublishToTopic(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * <p>
     * @param topic This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public PublishToTopic(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic topic, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.PublishToTopicProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(topic, "topic is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Called when the task object is used in a workflow.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param _task This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Task _task) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig.class, new Object[] { java.util.Objects.requireNonNull(_task, "_task is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.PublishToTopic}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        /**
         * EXPERIMENTAL
         * <p>
         * @return a new instance of {@link Builder}.
         * @param topic This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.services.sns.ITopic topic) {
            return new Builder(topic);
        }

        private final software.amazon.awscdk.services.sns.ITopic topic;
        private final software.amazon.awscdk.services.stepfunctions.tasks.PublishToTopicProps.Builder props;

        private Builder(final software.amazon.awscdk.services.sns.ITopic topic) {
            this.topic = topic;
            this.props = new software.amazon.awscdk.services.stepfunctions.tasks.PublishToTopicProps.Builder();
        }

        /**
         * The text message to send to the topic.
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param message The text message to send to the topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder message(final software.amazon.awscdk.services.stepfunctions.TaskInput message) {
            this.props.message(message);
            return this;
        }

        /**
         * The service integration pattern indicates different ways to call Publish to SNS.
         * <p>
         * The valid value is either FIRE_AND_FORGET or WAIT_FOR_TASK_TOKEN.
         * <p>
         * Default: FIRE_AND_FORGET
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param integrationPattern The service integration pattern indicates different ways to call Publish to SNS. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integrationPattern(final software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        /**
         * If true, send a different message to every subscription type.
         * <p>
         * If this is set to true, message must be a JSON object with a
         * "default" key and a key for every subscription type (such as "sqs",
         * "email", etc.) The values are strings representing the messages
         * being sent to every subscription type.
         * <p>
         * Default: false
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/sns/latest/api/API_Publish.html#API_Publish_RequestParameters
         * @param messagePerSubscriptionType If true, send a different message to every subscription type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder messagePerSubscriptionType(final java.lang.Boolean messagePerSubscriptionType) {
            this.props.messagePerSubscriptionType(messagePerSubscriptionType);
            return this;
        }

        /**
         * Used as the "Subject" line when the message is delivered to email endpoints.
         * <p>
         * Also included, if present, in the standard JSON messages delivered to other endpoints.
         * <p>
         * Default: - No subject
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @param subject Used as the "Subject" line when the message is delivered to email endpoints. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subject(final java.lang.String subject) {
            this.props.subject(subject);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.PublishToTopic}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.stepfunctions.tasks.PublishToTopic build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.PublishToTopic(
                this.topic,
                this.props.build()
            );
        }
    }
}
