package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Specifies the resources, ML compute instances, and ML storage volumes to deploy for model training.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-04-24T11:27:14.393Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.ResourceConfig")
@software.amazon.jsii.Jsii.Proxy(ResourceConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ResourceConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The number of ML compute instances to use.
     * <p>
     * Default: 1 instance.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Number getInstanceCount();

    /**
     * ML compute instance type.
     * <p>
     * Default: is the 'm4.xlarge' instance type.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceType getInstanceType();

    /**
     * Size of the ML storage volume that you want to provision.
     * <p>
     * Default: 10 GB EBS volume.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Number getVolumeSizeInGb();

    /**
     * KMS key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the training job.
     * <p>
     * Default: - Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getVolumeEncryptionKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ResourceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResourceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private java.lang.Number instanceCount;
        private software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private java.lang.Number volumeSizeInGb;
        private software.amazon.awscdk.services.kms.IKey volumeEncryptionKey;

        /**
         * Sets the value of {@link ResourceConfig#getInstanceCount}
         * @param instanceCount The number of ML compute instances to use. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceCount(java.lang.Number instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        /**
         * Sets the value of {@link ResourceConfig#getInstanceType}
         * @param instanceType ML compute instance type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link ResourceConfig#getVolumeSizeInGb}
         * @param volumeSizeInGb Size of the ML storage volume that you want to provision. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder volumeSizeInGb(java.lang.Number volumeSizeInGb) {
            this.volumeSizeInGb = volumeSizeInGb;
            return this;
        }

        /**
         * Sets the value of {@link ResourceConfig#getVolumeEncryptionKey}
         * @param volumeEncryptionKey KMS key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the training job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder volumeEncryptionKey(software.amazon.awscdk.services.kms.IKey volumeEncryptionKey) {
            this.volumeEncryptionKey = volumeEncryptionKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResourceConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public ResourceConfig build() {
            return new Jsii$Proxy(instanceCount, instanceType, volumeSizeInGb, volumeEncryptionKey);
        }
    }

    /**
     * An implementation for {@link ResourceConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceConfig {
        private final java.lang.Number instanceCount;
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final java.lang.Number volumeSizeInGb;
        private final software.amazon.awscdk.services.kms.IKey volumeEncryptionKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceCount = this.jsiiGet("instanceCount", java.lang.Number.class);
            this.instanceType = this.jsiiGet("instanceType", software.amazon.awscdk.services.ec2.InstanceType.class);
            this.volumeSizeInGb = this.jsiiGet("volumeSizeInGB", java.lang.Number.class);
            this.volumeEncryptionKey = this.jsiiGet("volumeEncryptionKey", software.amazon.awscdk.services.kms.IKey.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Number instanceCount, final software.amazon.awscdk.services.ec2.InstanceType instanceType, final java.lang.Number volumeSizeInGb, final software.amazon.awscdk.services.kms.IKey volumeEncryptionKey) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceCount = java.util.Objects.requireNonNull(instanceCount, "instanceCount is required");
            this.instanceType = java.util.Objects.requireNonNull(instanceType, "instanceType is required");
            this.volumeSizeInGb = java.util.Objects.requireNonNull(volumeSizeInGb, "volumeSizeInGb is required");
            this.volumeEncryptionKey = volumeEncryptionKey;
        }

        @Override
        public java.lang.Number getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public java.lang.Number getVolumeSizeInGb() {
            return this.volumeSizeInGb;
        }

        @Override
        public software.amazon.awscdk.services.kms.IKey getVolumeEncryptionKey() {
            return this.volumeEncryptionKey;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            data.set("volumeSizeInGB", om.valueToTree(this.getVolumeSizeInGb()));
            if (this.getVolumeEncryptionKey() != null) {
                data.set("volumeEncryptionKey", om.valueToTree(this.getVolumeEncryptionKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.ResourceConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResourceConfig.Jsii$Proxy that = (ResourceConfig.Jsii$Proxy) o;

            if (!instanceCount.equals(that.instanceCount)) return false;
            if (!instanceType.equals(that.instanceType)) return false;
            if (!volumeSizeInGb.equals(that.volumeSizeInGb)) return false;
            return this.volumeEncryptionKey != null ? this.volumeEncryptionKey.equals(that.volumeEncryptionKey) : that.volumeEncryptionKey == null;
        }

        @Override
        public int hashCode() {
            int result = this.instanceCount.hashCode();
            result = 31 * result + (this.instanceType.hashCode());
            result = 31 * result + (this.volumeSizeInGb.hashCode());
            result = 31 * result + (this.volumeEncryptionKey != null ? this.volumeEncryptionKey.hashCode() : 0);
            return result;
        }
    }
}
