package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * S3 location of the channel data.
 * <p>
 * EXPERIMENTAL
 * <p>
 * @see https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_S3DataSource.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-04-24T11:27:14.400Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.S3DataSource")
@software.amazon.jsii.Jsii.Proxy(S3DataSource.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface S3DataSource extends software.amazon.jsii.JsiiSerializable {

    /**
     * S3 Uri.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.S3Location getS3Location();

    /**
     * List of one or more attribute names to use that are found in a specified augmented manifest file.
     * <p>
     * Default: - No attribute names
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAttributeNames() {
        return null;
    }

    /**
     * S3 Data Distribution Type.
     * <p>
     * Default: - None
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.S3DataDistributionType getS3DataDistributionType() {
        return null;
    }

    /**
     * S3 Data Type.
     * <p>
     * Default: S3_PREFIX
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.S3DataType getS3DataType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link S3DataSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link S3DataSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private software.amazon.awscdk.services.stepfunctions.tasks.S3Location s3Location;
        private java.util.List<java.lang.String> attributeNames;
        private software.amazon.awscdk.services.stepfunctions.tasks.S3DataDistributionType s3DataDistributionType;
        private software.amazon.awscdk.services.stepfunctions.tasks.S3DataType s3DataType;

        /**
         * Sets the value of {@link S3DataSource#getS3Location}
         * @param s3Location S3 Uri. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3Location(software.amazon.awscdk.services.stepfunctions.tasks.S3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        /**
         * Sets the value of {@link S3DataSource#getAttributeNames}
         * @param attributeNames List of one or more attribute names to use that are found in a specified augmented manifest file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder attributeNames(java.util.List<java.lang.String> attributeNames) {
            this.attributeNames = attributeNames;
            return this;
        }

        /**
         * Sets the value of {@link S3DataSource#getS3DataDistributionType}
         * @param s3DataDistributionType S3 Data Distribution Type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3DataDistributionType(software.amazon.awscdk.services.stepfunctions.tasks.S3DataDistributionType s3DataDistributionType) {
            this.s3DataDistributionType = s3DataDistributionType;
            return this;
        }

        /**
         * Sets the value of {@link S3DataSource#getS3DataType}
         * @param s3DataType S3 Data Type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3DataType(software.amazon.awscdk.services.stepfunctions.tasks.S3DataType s3DataType) {
            this.s3DataType = s3DataType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3DataSource}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public S3DataSource build() {
            return new Jsii$Proxy(s3Location, attributeNames, s3DataDistributionType, s3DataType);
        }
    }

    /**
     * An implementation for {@link S3DataSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3DataSource {
        private final software.amazon.awscdk.services.stepfunctions.tasks.S3Location s3Location;
        private final java.util.List<java.lang.String> attributeNames;
        private final software.amazon.awscdk.services.stepfunctions.tasks.S3DataDistributionType s3DataDistributionType;
        private final software.amazon.awscdk.services.stepfunctions.tasks.S3DataType s3DataType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.s3Location = this.jsiiGet("s3Location", software.amazon.awscdk.services.stepfunctions.tasks.S3Location.class);
            this.attributeNames = this.jsiiGet("attributeNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.s3DataDistributionType = this.jsiiGet("s3DataDistributionType", software.amazon.awscdk.services.stepfunctions.tasks.S3DataDistributionType.class);
            this.s3DataType = this.jsiiGet("s3DataType", software.amazon.awscdk.services.stepfunctions.tasks.S3DataType.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.tasks.S3Location s3Location, final java.util.List<java.lang.String> attributeNames, final software.amazon.awscdk.services.stepfunctions.tasks.S3DataDistributionType s3DataDistributionType, final software.amazon.awscdk.services.stepfunctions.tasks.S3DataType s3DataType) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.s3Location = java.util.Objects.requireNonNull(s3Location, "s3Location is required");
            this.attributeNames = attributeNames;
            this.s3DataDistributionType = s3DataDistributionType;
            this.s3DataType = s3DataType;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.S3Location getS3Location() {
            return this.s3Location;
        }

        @Override
        public java.util.List<java.lang.String> getAttributeNames() {
            return this.attributeNames;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.S3DataDistributionType getS3DataDistributionType() {
            return this.s3DataDistributionType;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.S3DataType getS3DataType() {
            return this.s3DataType;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("s3Location", om.valueToTree(this.getS3Location()));
            if (this.getAttributeNames() != null) {
                data.set("attributeNames", om.valueToTree(this.getAttributeNames()));
            }
            if (this.getS3DataDistributionType() != null) {
                data.set("s3DataDistributionType", om.valueToTree(this.getS3DataDistributionType()));
            }
            if (this.getS3DataType() != null) {
                data.set("s3DataType", om.valueToTree(this.getS3DataType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.S3DataSource"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            S3DataSource.Jsii$Proxy that = (S3DataSource.Jsii$Proxy) o;

            if (!s3Location.equals(that.s3Location)) return false;
            if (this.attributeNames != null ? !this.attributeNames.equals(that.attributeNames) : that.attributeNames != null) return false;
            if (this.s3DataDistributionType != null ? !this.s3DataDistributionType.equals(that.s3DataDistributionType) : that.s3DataDistributionType != null) return false;
            return this.s3DataType != null ? this.s3DataType.equals(that.s3DataType) : that.s3DataType == null;
        }

        @Override
        public int hashCode() {
            int result = this.s3Location.hashCode();
            result = 31 * result + (this.attributeNames != null ? this.attributeNames.hashCode() : 0);
            result = 31 * result + (this.s3DataDistributionType != null ? this.s3DataDistributionType.hashCode() : 0);
            result = 31 * result + (this.s3DataType != null ? this.s3DataType.hashCode() : 0);
            return result;
        }
    }
}
