package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * A Step Functions Task to call StartExecution on another state machine.
 * <p>
 * It supports three service integration patterns: FIRE_AND_FORGET, SYNC and WAIT_FOR_TASK_TOKEN.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.4.1 (build 0b09d7b)", date = "2020-04-24T11:27:14.404Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.StartExecution")
public class StartExecution extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.IStepFunctionsTask {

    protected StartExecution(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StartExecution(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * EXPERIMENTAL
     * <p>
     * @param stateMachine This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public StartExecution(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IStateMachine stateMachine, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.StartExecutionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(stateMachine, "stateMachine is required"), props });
    }

    /**
     * EXPERIMENTAL
     * <p>
     * @param stateMachine This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public StartExecution(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IStateMachine stateMachine) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(stateMachine, "stateMachine is required") });
    }

    /**
     * Called when the task object is used in a workflow.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param task This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Task task) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig.class, new Object[] { java.util.Objects.requireNonNull(task, "task is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.StartExecution}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        /**
         * EXPERIMENTAL
         * <p>
         * @return a new instance of {@link Builder}.
         * @param stateMachine This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.services.stepfunctions.IStateMachine stateMachine) {
            return new Builder(stateMachine);
        }

        private final software.amazon.awscdk.services.stepfunctions.IStateMachine stateMachine;
        private software.amazon.awscdk.services.stepfunctions.tasks.StartExecutionProps.Builder props;

        private Builder(final software.amazon.awscdk.services.stepfunctions.IStateMachine stateMachine) {
            this.stateMachine = stateMachine;
        }

        /**
         * The JSON input for the execution, same as that of StartExecution.
         * <p>
         * Default: - No input
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
         * @param input The JSON input for the execution, same as that of StartExecution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder input(final java.util.Map<java.lang.String, java.lang.Object> input) {
            this.props().input(input);
            return this;
        }

        /**
         * The service integration pattern indicates different ways to call StartExecution to Step Functions.
         * <p>
         * Default: FIRE_AND_FORGET
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html
         * @param integrationPattern The service integration pattern indicates different ways to call StartExecution to Step Functions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder integrationPattern(final software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern) {
            this.props().integrationPattern(integrationPattern);
            return this;
        }

        /**
         * The name of the execution, same as that of StartExecution.
         * <p>
         * Default: - None
         * <p>
         * EXPERIMENTAL
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
         * @param name The name of the execution, same as that of StartExecution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.StartExecution}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.stepfunctions.tasks.StartExecution build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.StartExecution(
                this.stateMachine,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.stepfunctions.tasks.StartExecutionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.stepfunctions.tasks.StartExecutionProps.Builder();
            }
            return this.props;
        }
    }
}
