package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for EmrCreateCluster.
 * <p>
 * See the RunJobFlow API for complete documentation on input parameters
 * <p>
 * EXPERIMENTAL
 * <p>
 * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_RunJobFlow.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.11.0 (build 1e9b8e1)", date = "2020-08-27T08:38:05.383Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.EmrCreateClusterProps")
@software.amazon.jsii.Jsii.Proxy(EmrCreateClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface EmrCreateClusterProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.TaskStateBaseProps {

    /**
     * A specification of the number and type of Amazon EC2 instances.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstancesConfigProperty getInstances();

    /**
     * The Name of the Cluster.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * A JSON string for selecting additional features.
     * <p>
     * Default: - None
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getAdditionalInfo() {
        return null;
    }

    /**
     * A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster.
     * <p>
     * Default: - EMR selected default
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty> getApplications() {
        return null;
    }

    /**
     * An IAM role for automatic scaling policies.
     * <p>
     * Default: - A role will be created.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getAutoScalingRole() {
        return null;
    }

    /**
     * A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
     * <p>
     * Default: - None
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty> getBootstrapActions() {
        return null;
    }

    /**
     * Also called instance profile and EC2 role.
     * <p>
     * An IAM role for an EMR cluster. The EC2 instances of the cluster assume this role.
     * <p>
     * This attribute has been renamed from jobFlowRole to clusterRole to align with other ERM/StepFunction integration parameters.
     * <p>
     * Default: - * A Role will be created
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getClusterRole() {
        return null;
    }

    /**
     * The list of configurations supplied for the EMR cluster you are creating.
     * <p>
     * Default: - None
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> getConfigurations() {
        return null;
    }

    /**
     * The ID of a custom Amazon EBS-backed Linux AMI.
     * <p>
     * Default: - None
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomAmiId() {
        return null;
    }

    /**
     * The size of the EBS root device volume of the Linux AMI that is used for each EC2 instance.
     * <p>
     * Default: - EMR selected default
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Size getEbsRootVolumeSize() {
        return null;
    }

    /**
     * Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
     * <p>
     * Default: - None
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.KerberosAttributesProperty getKerberosAttributes() {
        return null;
    }

    /**
     * The location in Amazon S3 to write the log files of the job flow.
     * <p>
     * Default: - None
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogUri() {
        return null;
    }

    /**
     * The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster.
     * <p>
     * Default: - EMR selected default
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getReleaseLabel() {
        return null;
    }

    /**
     * Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized.
     * <p>
     * Default: - EMR selected default
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EmrClusterScaleDownBehavior getScaleDownBehavior() {
        return null;
    }

    /**
     * The name of a security configuration to apply to the cluster.
     * <p>
     * Default: - None
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecurityConfiguration() {
        return null;
    }

    /**
     * The IAM role that will be assumed by the Amazon EMR service to access AWS resources on your behalf.
     * <p>
     * Default: - A role will be created that Amazon EMR service can assume.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getServiceRole() {
        return null;
    }

    /**
     * A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
     * <p>
     * Default: - None
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * A value of true indicates that all IAM users in the AWS account can perform cluster actions if they have the proper IAM policy permissions.
     * <p>
     * Default: true
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getVisibleToAllUsers() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EmrCreateClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EmrCreateClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<EmrCreateClusterProps> {
        private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstancesConfigProperty instances;
        private java.lang.String name;
        private java.lang.String additionalInfo;
        private java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty> applications;
        private software.amazon.awscdk.services.iam.IRole autoScalingRole;
        private java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty> bootstrapActions;
        private software.amazon.awscdk.services.iam.IRole clusterRole;
        private java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations;
        private java.lang.String customAmiId;
        private software.amazon.awscdk.core.Size ebsRootVolumeSize;
        private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.KerberosAttributesProperty kerberosAttributes;
        private java.lang.String logUri;
        private java.lang.String releaseLabel;
        private software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EmrClusterScaleDownBehavior scaleDownBehavior;
        private java.lang.String securityConfiguration;
        private software.amazon.awscdk.services.iam.IRole serviceRole;
        private java.util.Map<java.lang.String, java.lang.String> tags;
        private java.lang.Boolean visibleToAllUsers;
        private java.lang.String comment;
        private software.amazon.awscdk.core.Duration heartbeat;
        private java.lang.String inputPath;
        private software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private java.lang.String outputPath;
        private java.lang.String resultPath;
        private software.amazon.awscdk.core.Duration timeout;

        /**
         * Sets the value of {@link EmrCreateClusterProps#getInstances}
         * @param instances A specification of the number and type of Amazon EC2 instances. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instances(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstancesConfigProperty instances) {
            this.instances = instances;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getName}
         * @param name The Name of the Cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getAdditionalInfo}
         * @param additionalInfo A JSON string for selecting additional features.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder additionalInfo(java.lang.String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getApplications}
         * @param applications A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder applications(java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty> applications) {
            this.applications = applications;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getAutoScalingRole}
         * @param autoScalingRole An IAM role for automatic scaling policies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoScalingRole(software.amazon.awscdk.services.iam.IRole autoScalingRole) {
            this.autoScalingRole = autoScalingRole;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getBootstrapActions}
         * @param bootstrapActions A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bootstrapActions(java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty> bootstrapActions) {
            this.bootstrapActions = bootstrapActions;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getClusterRole}
         * @param clusterRole Also called instance profile and EC2 role.
         *                    An IAM role for an EMR cluster. The EC2 instances of the cluster assume this role.
         *                    <p>
         *                    This attribute has been renamed from jobFlowRole to clusterRole to align with other ERM/StepFunction integration parameters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterRole(software.amazon.awscdk.services.iam.IRole clusterRole) {
            this.clusterRole = clusterRole;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getConfigurations}
         * @param configurations The list of configurations supplied for the EMR cluster you are creating.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder configurations(java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations) {
            this.configurations = configurations;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getCustomAmiId}
         * @param customAmiId The ID of a custom Amazon EBS-backed Linux AMI.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder customAmiId(java.lang.String customAmiId) {
            this.customAmiId = customAmiId;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getEbsRootVolumeSize}
         * @param ebsRootVolumeSize The size of the EBS root device volume of the Linux AMI that is used for each EC2 instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ebsRootVolumeSize(software.amazon.awscdk.core.Size ebsRootVolumeSize) {
            this.ebsRootVolumeSize = ebsRootVolumeSize;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getKerberosAttributes}
         * @param kerberosAttributes Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kerberosAttributes(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.KerberosAttributesProperty kerberosAttributes) {
            this.kerberosAttributes = kerberosAttributes;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getLogUri}
         * @param logUri The location in Amazon S3 to write the log files of the job flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logUri(java.lang.String logUri) {
            this.logUri = logUri;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getReleaseLabel}
         * @param releaseLabel The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder releaseLabel(java.lang.String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getScaleDownBehavior}
         * @param scaleDownBehavior Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder scaleDownBehavior(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EmrClusterScaleDownBehavior scaleDownBehavior) {
            this.scaleDownBehavior = scaleDownBehavior;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getSecurityConfiguration}
         * @param securityConfiguration The name of a security configuration to apply to the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityConfiguration(java.lang.String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getServiceRole}
         * @param serviceRole The IAM role that will be assumed by the Amazon EMR service to access AWS resources on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serviceRole(software.amazon.awscdk.services.iam.IRole serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getTags}
         * @param tags A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getVisibleToAllUsers}
         * @param visibleToAllUsers A value of true indicates that all IAM users in the AWS account can perform cluster actions if they have the proper IAM policy permissions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder visibleToAllUsers(java.lang.Boolean visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getComment}
         * @param comment An optional description for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getHeartbeat}
         * @param heartbeat Timeout for the heartbeat.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeat(software.amazon.awscdk.core.Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getInputPath}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state.
         *                  May also be the special value JsonPath.DISCARD, which will cause the effective
         *                  input to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(java.lang.String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getIntegrationPattern}
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language.
         *                           You can control these AWS services using service integration patterns
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getOutputPath}
         * @param outputPath JSONPath expression to select select a portion of the state output to pass to the next state.
         *                   May also be the special value JsonPath.DISCARD, which will cause the effective
         *                   output to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getResultPath}
         * @param resultPath JSONPath expression to indicate where to inject the state's output.
         *                   May also be the special value JsonPath.DISCARD, which will cause the state's
         *                   input to become its output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(java.lang.String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        /**
         * Sets the value of {@link EmrCreateClusterProps#getTimeout}
         * @param timeout Timeout for the state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.core.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EmrCreateClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public EmrCreateClusterProps build() {
            return new Jsii$Proxy(instances, name, additionalInfo, applications, autoScalingRole, bootstrapActions, clusterRole, configurations, customAmiId, ebsRootVolumeSize, kerberosAttributes, logUri, releaseLabel, scaleDownBehavior, securityConfiguration, serviceRole, tags, visibleToAllUsers, comment, heartbeat, inputPath, integrationPattern, outputPath, resultPath, timeout);
        }
    }

    /**
     * An implementation for {@link EmrCreateClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmrCreateClusterProps {
        private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstancesConfigProperty instances;
        private final java.lang.String name;
        private final java.lang.String additionalInfo;
        private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty> applications;
        private final software.amazon.awscdk.services.iam.IRole autoScalingRole;
        private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty> bootstrapActions;
        private final software.amazon.awscdk.services.iam.IRole clusterRole;
        private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations;
        private final java.lang.String customAmiId;
        private final software.amazon.awscdk.core.Size ebsRootVolumeSize;
        private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.KerberosAttributesProperty kerberosAttributes;
        private final java.lang.String logUri;
        private final java.lang.String releaseLabel;
        private final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EmrClusterScaleDownBehavior scaleDownBehavior;
        private final java.lang.String securityConfiguration;
        private final software.amazon.awscdk.services.iam.IRole serviceRole;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.Boolean visibleToAllUsers;
        private final java.lang.String comment;
        private final software.amazon.awscdk.core.Duration heartbeat;
        private final java.lang.String inputPath;
        private final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private final java.lang.String outputPath;
        private final java.lang.String resultPath;
        private final software.amazon.awscdk.core.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instances = this.jsiiGet("instances", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstancesConfigProperty.class);
            this.name = this.jsiiGet("name", java.lang.String.class);
            this.additionalInfo = this.jsiiGet("additionalInfo", java.lang.String.class);
            this.applications = this.jsiiGet("applications", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty.class)));
            this.autoScalingRole = this.jsiiGet("autoScalingRole", software.amazon.awscdk.services.iam.IRole.class);
            this.bootstrapActions = this.jsiiGet("bootstrapActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty.class)));
            this.clusterRole = this.jsiiGet("clusterRole", software.amazon.awscdk.services.iam.IRole.class);
            this.configurations = this.jsiiGet("configurations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty.class)));
            this.customAmiId = this.jsiiGet("customAmiId", java.lang.String.class);
            this.ebsRootVolumeSize = this.jsiiGet("ebsRootVolumeSize", software.amazon.awscdk.core.Size.class);
            this.kerberosAttributes = this.jsiiGet("kerberosAttributes", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.KerberosAttributesProperty.class);
            this.logUri = this.jsiiGet("logUri", java.lang.String.class);
            this.releaseLabel = this.jsiiGet("releaseLabel", java.lang.String.class);
            this.scaleDownBehavior = this.jsiiGet("scaleDownBehavior", software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EmrClusterScaleDownBehavior.class);
            this.securityConfiguration = this.jsiiGet("securityConfiguration", java.lang.String.class);
            this.serviceRole = this.jsiiGet("serviceRole", software.amazon.awscdk.services.iam.IRole.class);
            this.tags = this.jsiiGet("tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.visibleToAllUsers = this.jsiiGet("visibleToAllUsers", java.lang.Boolean.class);
            this.comment = this.jsiiGet("comment", java.lang.String.class);
            this.heartbeat = this.jsiiGet("heartbeat", software.amazon.awscdk.core.Duration.class);
            this.inputPath = this.jsiiGet("inputPath", java.lang.String.class);
            this.integrationPattern = this.jsiiGet("integrationPattern", software.amazon.awscdk.services.stepfunctions.IntegrationPattern.class);
            this.outputPath = this.jsiiGet("outputPath", java.lang.String.class);
            this.resultPath = this.jsiiGet("resultPath", java.lang.String.class);
            this.timeout = this.jsiiGet("timeout", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstancesConfigProperty instances, final java.lang.String name, final java.lang.String additionalInfo, final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty> applications, final software.amazon.awscdk.services.iam.IRole autoScalingRole, final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty> bootstrapActions, final software.amazon.awscdk.services.iam.IRole clusterRole, final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> configurations, final java.lang.String customAmiId, final software.amazon.awscdk.core.Size ebsRootVolumeSize, final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.KerberosAttributesProperty kerberosAttributes, final java.lang.String logUri, final java.lang.String releaseLabel, final software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EmrClusterScaleDownBehavior scaleDownBehavior, final java.lang.String securityConfiguration, final software.amazon.awscdk.services.iam.IRole serviceRole, final java.util.Map<java.lang.String, java.lang.String> tags, final java.lang.Boolean visibleToAllUsers, final java.lang.String comment, final software.amazon.awscdk.core.Duration heartbeat, final java.lang.String inputPath, final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern, final java.lang.String outputPath, final java.lang.String resultPath, final software.amazon.awscdk.core.Duration timeout) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instances = java.util.Objects.requireNonNull(instances, "instances is required");
            this.name = java.util.Objects.requireNonNull(name, "name is required");
            this.additionalInfo = additionalInfo;
            this.applications = applications;
            this.autoScalingRole = autoScalingRole;
            this.bootstrapActions = bootstrapActions;
            this.clusterRole = clusterRole;
            this.configurations = configurations;
            this.customAmiId = customAmiId;
            this.ebsRootVolumeSize = ebsRootVolumeSize;
            this.kerberosAttributes = kerberosAttributes;
            this.logUri = logUri;
            this.releaseLabel = releaseLabel;
            this.scaleDownBehavior = scaleDownBehavior;
            this.securityConfiguration = securityConfiguration;
            this.serviceRole = serviceRole;
            this.tags = tags;
            this.visibleToAllUsers = visibleToAllUsers;
            this.comment = comment;
            this.heartbeat = heartbeat;
            this.inputPath = inputPath;
            this.integrationPattern = integrationPattern;
            this.outputPath = outputPath;
            this.resultPath = resultPath;
            this.timeout = timeout;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.InstancesConfigProperty getInstances() {
            return this.instances;
        }

        @Override
        public java.lang.String getName() {
            return this.name;
        }

        @Override
        public java.lang.String getAdditionalInfo() {
            return this.additionalInfo;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ApplicationConfigProperty> getApplications() {
            return this.applications;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getAutoScalingRole() {
            return this.autoScalingRole;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.BootstrapActionConfigProperty> getBootstrapActions() {
            return this.bootstrapActions;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getClusterRole() {
            return this.clusterRole;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.ConfigurationProperty> getConfigurations() {
            return this.configurations;
        }

        @Override
        public java.lang.String getCustomAmiId() {
            return this.customAmiId;
        }

        @Override
        public software.amazon.awscdk.core.Size getEbsRootVolumeSize() {
            return this.ebsRootVolumeSize;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.KerberosAttributesProperty getKerberosAttributes() {
            return this.kerberosAttributes;
        }

        @Override
        public java.lang.String getLogUri() {
            return this.logUri;
        }

        @Override
        public java.lang.String getReleaseLabel() {
            return this.releaseLabel;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EmrClusterScaleDownBehavior getScaleDownBehavior() {
            return this.scaleDownBehavior;
        }

        @Override
        public java.lang.String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public java.lang.Boolean getVisibleToAllUsers() {
            return this.visibleToAllUsers;
        }

        @Override
        public java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public software.amazon.awscdk.core.Duration getHeartbeat() {
            return this.heartbeat;
        }

        @Override
        public java.lang.String getInputPath() {
            return this.inputPath;
        }

        @Override
        public software.amazon.awscdk.services.stepfunctions.IntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        public java.lang.String getResultPath() {
            return this.resultPath;
        }

        @Override
        public software.amazon.awscdk.core.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instances", om.valueToTree(this.getInstances()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getAdditionalInfo() != null) {
                data.set("additionalInfo", om.valueToTree(this.getAdditionalInfo()));
            }
            if (this.getApplications() != null) {
                data.set("applications", om.valueToTree(this.getApplications()));
            }
            if (this.getAutoScalingRole() != null) {
                data.set("autoScalingRole", om.valueToTree(this.getAutoScalingRole()));
            }
            if (this.getBootstrapActions() != null) {
                data.set("bootstrapActions", om.valueToTree(this.getBootstrapActions()));
            }
            if (this.getClusterRole() != null) {
                data.set("clusterRole", om.valueToTree(this.getClusterRole()));
            }
            if (this.getConfigurations() != null) {
                data.set("configurations", om.valueToTree(this.getConfigurations()));
            }
            if (this.getCustomAmiId() != null) {
                data.set("customAmiId", om.valueToTree(this.getCustomAmiId()));
            }
            if (this.getEbsRootVolumeSize() != null) {
                data.set("ebsRootVolumeSize", om.valueToTree(this.getEbsRootVolumeSize()));
            }
            if (this.getKerberosAttributes() != null) {
                data.set("kerberosAttributes", om.valueToTree(this.getKerberosAttributes()));
            }
            if (this.getLogUri() != null) {
                data.set("logUri", om.valueToTree(this.getLogUri()));
            }
            if (this.getReleaseLabel() != null) {
                data.set("releaseLabel", om.valueToTree(this.getReleaseLabel()));
            }
            if (this.getScaleDownBehavior() != null) {
                data.set("scaleDownBehavior", om.valueToTree(this.getScaleDownBehavior()));
            }
            if (this.getSecurityConfiguration() != null) {
                data.set("securityConfiguration", om.valueToTree(this.getSecurityConfiguration()));
            }
            if (this.getServiceRole() != null) {
                data.set("serviceRole", om.valueToTree(this.getServiceRole()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVisibleToAllUsers() != null) {
                data.set("visibleToAllUsers", om.valueToTree(this.getVisibleToAllUsers()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getHeartbeat() != null) {
                data.set("heartbeat", om.valueToTree(this.getHeartbeat()));
            }
            if (this.getInputPath() != null) {
                data.set("inputPath", om.valueToTree(this.getInputPath()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }
            if (this.getResultPath() != null) {
                data.set("resultPath", om.valueToTree(this.getResultPath()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions-tasks.EmrCreateClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EmrCreateClusterProps.Jsii$Proxy that = (EmrCreateClusterProps.Jsii$Proxy) o;

            if (!instances.equals(that.instances)) return false;
            if (!name.equals(that.name)) return false;
            if (this.additionalInfo != null ? !this.additionalInfo.equals(that.additionalInfo) : that.additionalInfo != null) return false;
            if (this.applications != null ? !this.applications.equals(that.applications) : that.applications != null) return false;
            if (this.autoScalingRole != null ? !this.autoScalingRole.equals(that.autoScalingRole) : that.autoScalingRole != null) return false;
            if (this.bootstrapActions != null ? !this.bootstrapActions.equals(that.bootstrapActions) : that.bootstrapActions != null) return false;
            if (this.clusterRole != null ? !this.clusterRole.equals(that.clusterRole) : that.clusterRole != null) return false;
            if (this.configurations != null ? !this.configurations.equals(that.configurations) : that.configurations != null) return false;
            if (this.customAmiId != null ? !this.customAmiId.equals(that.customAmiId) : that.customAmiId != null) return false;
            if (this.ebsRootVolumeSize != null ? !this.ebsRootVolumeSize.equals(that.ebsRootVolumeSize) : that.ebsRootVolumeSize != null) return false;
            if (this.kerberosAttributes != null ? !this.kerberosAttributes.equals(that.kerberosAttributes) : that.kerberosAttributes != null) return false;
            if (this.logUri != null ? !this.logUri.equals(that.logUri) : that.logUri != null) return false;
            if (this.releaseLabel != null ? !this.releaseLabel.equals(that.releaseLabel) : that.releaseLabel != null) return false;
            if (this.scaleDownBehavior != null ? !this.scaleDownBehavior.equals(that.scaleDownBehavior) : that.scaleDownBehavior != null) return false;
            if (this.securityConfiguration != null ? !this.securityConfiguration.equals(that.securityConfiguration) : that.securityConfiguration != null) return false;
            if (this.serviceRole != null ? !this.serviceRole.equals(that.serviceRole) : that.serviceRole != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.visibleToAllUsers != null ? !this.visibleToAllUsers.equals(that.visibleToAllUsers) : that.visibleToAllUsers != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.heartbeat != null ? !this.heartbeat.equals(that.heartbeat) : that.heartbeat != null) return false;
            if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.outputPath != null ? !this.outputPath.equals(that.outputPath) : that.outputPath != null) return false;
            if (this.resultPath != null ? !this.resultPath.equals(that.resultPath) : that.resultPath != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public int hashCode() {
            int result = this.instances.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.additionalInfo != null ? this.additionalInfo.hashCode() : 0);
            result = 31 * result + (this.applications != null ? this.applications.hashCode() : 0);
            result = 31 * result + (this.autoScalingRole != null ? this.autoScalingRole.hashCode() : 0);
            result = 31 * result + (this.bootstrapActions != null ? this.bootstrapActions.hashCode() : 0);
            result = 31 * result + (this.clusterRole != null ? this.clusterRole.hashCode() : 0);
            result = 31 * result + (this.configurations != null ? this.configurations.hashCode() : 0);
            result = 31 * result + (this.customAmiId != null ? this.customAmiId.hashCode() : 0);
            result = 31 * result + (this.ebsRootVolumeSize != null ? this.ebsRootVolumeSize.hashCode() : 0);
            result = 31 * result + (this.kerberosAttributes != null ? this.kerberosAttributes.hashCode() : 0);
            result = 31 * result + (this.logUri != null ? this.logUri.hashCode() : 0);
            result = 31 * result + (this.releaseLabel != null ? this.releaseLabel.hashCode() : 0);
            result = 31 * result + (this.scaleDownBehavior != null ? this.scaleDownBehavior.hashCode() : 0);
            result = 31 * result + (this.securityConfiguration != null ? this.securityConfiguration.hashCode() : 0);
            result = 31 * result + (this.serviceRole != null ? this.serviceRole.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.visibleToAllUsers != null ? this.visibleToAllUsers.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.heartbeat != null ? this.heartbeat.hashCode() : 0);
            result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            result = 31 * result + (this.resultPath != null ? this.resultPath.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
