package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Invoke a Glue job as a Task.
 * <p>
 * OUTPUT: the output of this task is a JobRun structure, for details consult
 * https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-jobs-runs.html#aws-glue-api-jobs-runs-JobRun
 * <p>
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-glue.html
 * @deprecated use `GlueStartJobRun`
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.11.0 (build 1e9b8e1)", date = "2020-08-27T08:38:05.403Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
@Deprecated
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.tasks.$Module.class, fqn = "@aws-cdk/aws-stepfunctions-tasks.RunGlueJobTask")
public class RunGlueJobTask extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.IStepFunctionsTask {

    protected RunGlueJobTask(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RunGlueJobTask(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param glueJobName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public RunGlueJobTask(final @org.jetbrains.annotations.NotNull java.lang.String glueJobName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.RunGlueJobTaskProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(glueJobName, "glueJobName is required"), props });
    }

    /**
     * @param glueJobName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public RunGlueJobTask(final @org.jetbrains.annotations.NotNull java.lang.String glueJobName) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(glueJobName, "glueJobName is required") });
    }

    /**
     * Called when the task object is used in a workflow.
     * <p>
     * @param task This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Task task) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig.class, new Object[] { java.util.Objects.requireNonNull(task, "task is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.RunGlueJobTask}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.tasks.RunGlueJobTask> {
        /**
         * @return a new instance of {@link Builder}.
         * @param glueJobName This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public static Builder create(final java.lang.String glueJobName) {
            return new Builder(glueJobName);
        }

        private final java.lang.String glueJobName;
        private software.amazon.awscdk.services.stepfunctions.tasks.RunGlueJobTaskProps.Builder props;

        private Builder(final java.lang.String glueJobName) {
            this.glueJobName = glueJobName;
        }

        /**
         * The job arguments specifically for this run.
         * <p>
         * For this job run, they replace the default arguments set in the job definition itself.
         * <p>
         * Default: - Default arguments set in the job definition
         * <p>
         * @return {@code this}
         * @param arguments The job arguments specifically for this run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder arguments(final java.util.Map<java.lang.String, java.lang.String> arguments) {
            this.props().arguments(arguments);
            return this;
        }

        /**
         * The service integration pattern indicates different ways to start the Glue job.
         * <p>
         * The valid value for Glue is either FIRE_AND_FORGET or SYNC.
         * <p>
         * Default: FIRE_AND_FORGET
         * <p>
         * @return {@code this}
         * @param integrationPattern The service integration pattern indicates different ways to start the Glue job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder integrationPattern(final software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern integrationPattern) {
            this.props().integrationPattern(integrationPattern);
            return this;
        }

        /**
         * After a job run starts, the number of minutes to wait before sending a job run delay notification.
         * <p>
         * Must be at least 1 minute.
         * <p>
         * Default: - Default delay set in the job definition
         * <p>
         * @return {@code this}
         * @param notifyDelayAfter After a job run starts, the number of minutes to wait before sending a job run delay notification. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder notifyDelayAfter(final software.amazon.awscdk.core.Duration notifyDelayAfter) {
            this.props().notifyDelayAfter(notifyDelayAfter);
            return this;
        }

        /**
         * The name of the SecurityConfiguration structure to be used with this job run.
         * <p>
         * This must match the Glue API
         * <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html#aws-glue-api-regex-oneLine">single-line string pattern</a>.
         * <p>
         * Default: - Default configuration set in the job definition
         * <p>
         * @return {@code this}
         * @param securityConfiguration The name of the SecurityConfiguration structure to be used with this job run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder securityConfiguration(final java.lang.String securityConfiguration) {
            this.props().securityConfiguration(securityConfiguration);
            return this;
        }

        /**
         * The job run timeout.
         * <p>
         * This is the maximum time that a job run can consume resources before it is terminated and enters TIMEOUT status.
         * Must be at least 1 minute.
         * <p>
         * Default: - Default timeout set in the job definition
         * <p>
         * @return {@code this}
         * @param timeout The job run timeout. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder timeout(final software.amazon.awscdk.core.Duration timeout) {
            this.props().timeout(timeout);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.RunGlueJobTask}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.RunGlueJobTask build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.RunGlueJobTask(
                this.glueJobName,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.stepfunctions.tasks.RunGlueJobTaskProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.stepfunctions.tasks.RunGlueJobTaskProps.Builder();
            }
            return this.props;
        }
    }
}
