/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awsconstructs.services.apigatewaykinesisstreams;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.services.apigateway.ModelOptions;
import software.amazon.awscdk.services.apigateway.RestApi;
import software.amazon.awscdk.services.apigateway.RestApiProps;
import software.amazon.awscdk.services.cloudwatch.Alarm;
import software.amazon.awscdk.services.iam.Role;
import software.amazon.awscdk.services.kinesis.Stream;
import software.amazon.awscdk.services.kinesis.StreamProps;
import software.amazon.awscdk.services.logs.LogGroup;
import software.amazon.awscdk.services.logs.LogGroupProps;
import software.amazon.awsconstructs.services.apigatewaykinesisstreams.$Module;
import software.amazon.awsconstructs.services.apigatewaykinesisstreams.ApiGatewayToKinesisStreamsProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-solutions-constructs/aws-apigateway-kinesisstreams.ApiGatewayToKinesisStreams")
public class ApiGatewayToKinesisStreams
extends Construct {
    protected ApiGatewayToKinesisStreams(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApiGatewayToKinesisStreams(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ApiGatewayToKinesisStreams(@NotNull Construct scope, @NotNull String id, @NotNull ApiGatewayToKinesisStreamsProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public RestApi getApiGateway() {
        return (RestApi)Kernel.get((Object)((Object)this), (String)"apiGateway", (NativeType)NativeType.forClass(RestApi.class));
    }

    @NotNull
    public LogGroup getApiGatewayLogGroup() {
        return (LogGroup)Kernel.get((Object)((Object)this), (String)"apiGatewayLogGroup", (NativeType)NativeType.forClass(LogGroup.class));
    }

    @NotNull
    public Role getApiGatewayRole() {
        return (Role)Kernel.get((Object)((Object)this), (String)"apiGatewayRole", (NativeType)NativeType.forClass(Role.class));
    }

    @NotNull
    public Stream getKinesisStream() {
        return (Stream)Kernel.get((Object)((Object)this), (String)"kinesisStream", (NativeType)NativeType.forClass(Stream.class));
    }

    @Nullable
    public Role getApiGatewayCloudWatchRole() {
        return (Role)Kernel.get((Object)((Object)this), (String)"apiGatewayCloudWatchRole", (NativeType)NativeType.forClass(Role.class));
    }

    @Nullable
    public List<Alarm> getCloudwatchAlarms() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"cloudwatchAlarms", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Alarm.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ApiGatewayToKinesisStreams> {
        private final Construct scope;
        private final String id;
        private final ApiGatewayToKinesisStreamsProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ApiGatewayToKinesisStreamsProps.Builder();
        }

        public Builder apiGatewayProps(RestApiProps apiGatewayProps) {
            this.props.apiGatewayProps(apiGatewayProps);
            return this;
        }

        public Builder createCloudWatchAlarms(Boolean createCloudWatchAlarms) {
            this.props.createCloudWatchAlarms(createCloudWatchAlarms);
            return this;
        }

        public Builder existingStreamObj(Stream existingStreamObj) {
            this.props.existingStreamObj(existingStreamObj);
            return this;
        }

        public Builder kinesisStreamProps(StreamProps kinesisStreamProps) {
            this.props.kinesisStreamProps(kinesisStreamProps);
            return this;
        }

        public Builder logGroupProps(LogGroupProps logGroupProps) {
            this.props.logGroupProps(logGroupProps);
            return this;
        }

        public Builder putRecordRequestModel(ModelOptions putRecordRequestModel) {
            this.props.putRecordRequestModel(putRecordRequestModel);
            return this;
        }

        public Builder putRecordRequestTemplate(String putRecordRequestTemplate) {
            this.props.putRecordRequestTemplate(putRecordRequestTemplate);
            return this;
        }

        public Builder putRecordsRequestModel(ModelOptions putRecordsRequestModel) {
            this.props.putRecordsRequestModel(putRecordsRequestModel);
            return this;
        }

        public Builder putRecordsRequestTemplate(String putRecordsRequestTemplate) {
            this.props.putRecordsRequestTemplate(putRecordsRequestTemplate);
            return this;
        }

        public ApiGatewayToKinesisStreams build() {
            return new ApiGatewayToKinesisStreams(this.scope, this.id, this.props.build());
        }
    }
}

