/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awsconstructs.services.cloudfronts3;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.services.cloudfront.Distribution;
import software.amazon.awscdk.services.cloudfront.Function;
import software.amazon.awscdk.services.s3.Bucket;
import software.amazon.awscdk.services.s3.BucketProps;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awsconstructs.services.cloudfronts3.;
import software.amazon.awsconstructs.services.cloudfronts3.CloudFrontToS3Props;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="@aws-solutions-constructs/aws-cloudfront-s3.CloudFrontToS3")
public class CloudFrontToS3
extends Construct {
    protected CloudFrontToS3(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudFrontToS3(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CloudFrontToS3(@NotNull Construct scope, @NotNull String id, @NotNull CloudFrontToS3Props props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public Distribution getCloudFrontWebDistribution() {
        return (Distribution)Kernel.get((Object)((Object)this), (String)"cloudFrontWebDistribution", (NativeType)NativeType.forClass(Distribution.class));
    }

    @NotNull
    public IBucket getS3BucketInterface() {
        return (IBucket)Kernel.get((Object)((Object)this), (String)"s3BucketInterface", (NativeType)NativeType.forClass(IBucket.class));
    }

    @Nullable
    public Function getCloudFrontFunction() {
        return (Function)Kernel.get((Object)((Object)this), (String)"cloudFrontFunction", (NativeType)NativeType.forClass(Function.class));
    }

    @Nullable
    public Bucket getCloudFrontLoggingBucket() {
        return (Bucket)Kernel.get((Object)((Object)this), (String)"cloudFrontLoggingBucket", (NativeType)NativeType.forClass(Bucket.class));
    }

    @Nullable
    public Bucket getS3Bucket() {
        return (Bucket)Kernel.get((Object)((Object)this), (String)"s3Bucket", (NativeType)NativeType.forClass(Bucket.class));
    }

    @Nullable
    public Bucket getS3LoggingBucket() {
        return (Bucket)Kernel.get((Object)((Object)this), (String)"s3LoggingBucket", (NativeType)NativeType.forClass(Bucket.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CloudFrontToS3> {
        private final Construct scope;
        private final String id;
        private final CloudFrontToS3Props.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CloudFrontToS3Props.Builder();
        }

        public Builder bucketProps(BucketProps bucketProps) {
            this.props.bucketProps(bucketProps);
            return this;
        }

        public Builder cloudFrontDistributionProps(Object cloudFrontDistributionProps) {
            this.props.cloudFrontDistributionProps(cloudFrontDistributionProps);
            return this;
        }

        public Builder cloudFrontLoggingBucketProps(BucketProps cloudFrontLoggingBucketProps) {
            this.props.cloudFrontLoggingBucketProps(cloudFrontLoggingBucketProps);
            return this;
        }

        public Builder existingBucketObj(IBucket existingBucketObj) {
            this.props.existingBucketObj(existingBucketObj);
            return this;
        }

        public Builder insertHttpSecurityHeaders(Boolean insertHttpSecurityHeaders) {
            this.props.insertHttpSecurityHeaders(insertHttpSecurityHeaders);
            return this;
        }

        public Builder loggingBucketProps(BucketProps loggingBucketProps) {
            this.props.loggingBucketProps(loggingBucketProps);
            return this;
        }

        public Builder logS3AccessLogs(Boolean logS3AccessLogs) {
            this.props.logS3AccessLogs(logS3AccessLogs);
            return this;
        }

        public Builder originPath(String originPath) {
            this.props.originPath(originPath);
            return this;
        }

        public CloudFrontToS3 build() {
            return new CloudFrontToS3(this.scope, this.id, this.props.build());
        }
    }
}

