package software.amazon.awsconstructs.services.fargatestepfunctions;

@javax.annotation.Generated(value = "jsii-pacmak/1.101.0 (build b95fe5d)", date = "2024-07-05T20:07:54.589Z")
@software.amazon.jsii.Jsii(module = software.amazon.awsconstructs.services.fargatestepfunctions.$Module.class, fqn = "@aws-solutions-constructs/aws-fargate-stepfunctions.FargateToStepfunctionsProps")
@software.amazon.jsii.Jsii.Proxy(FargateToStepfunctionsProps.Jsii$Proxy.class)
public interface FargateToStepfunctionsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether the construct is deploying a private or public API.
     * <p>
     * This has implications for the VPC deployed
     * by this construct.
     */
    @org.jetbrains.annotations.NotNull java.lang.Boolean getPublicApi();

    /**
     * User provided StateMachineProps to override the defaults.
     * <p>
     * Default: - None
     */
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateMachineProps getStateMachineProps();

    /**
     * Optional properties to create a new ECS cluster.
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ClusterProps getClusterProps() {
        return null;
    }

    default @org.jetbrains.annotations.Nullable java.lang.Object getContainerDefinitionProps() {
        return null;
    }

    /**
     * Whether to create recommended CloudWatch alarms.
     * <p>
     * Default: - true
     */
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCreateCloudWatchAlarms() {
        return null;
    }

    /**
     * The version of the image to use from the repository.
     * <p>
     * Default: - 'latest'
     */
    default @org.jetbrains.annotations.Nullable java.lang.String getEcrImageVersion() {
        return null;
    }

    /**
     * The arn of an ECR Repository containing the image to use to generate the containers.
     * <p>
     * format:
     * arn:aws:ecr:[region]:[account number]:repository/[Repository Name]
     */
    default @org.jetbrains.annotations.Nullable java.lang.String getEcrRepositoryArn() {
        return null;
    }

    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ContainerDefinition getExistingContainerDefinitionObject() {
        return null;
    }

    /**
     * A Fargate Service already instantiated (probably by another Solutions Construct).
     * <p>
     * If
     * this is specified, then no props defining a new service can be provided, including:
     * existingImageObject, ecrImageVersion, containerDefinitionProps, fargateTaskDefinitionProps,
     * ecrRepositoryArn, fargateServiceProps, clusterProps, existingClusterInterface. If this value
     * is provided, then existingContainerDefinitionObject must be provided as well.
     * <p>
     * Default: - none
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.FargateService getExistingFargateServiceObject() {
        return null;
    }

    /**
     * An existing VPC in which to deploy the construct.
     * <p>
     * Providing both this and
     * vpcProps is an error. If the client provides an existing Fargate service,
     * this value must be the VPC where the service is running. A Step Functions Interface
     * endpoint will be added to this VPC.
     * <p>
     * Default: - none
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getExistingVpc() {
        return null;
    }

    /**
     * Optional values to override default Fargate Task definition properties (fargate-defaults.ts). The construct will default to launching the service is the most isolated subnets available (precedence: Isolated, Private and Public). Override those and other defaults here.
     * <p>
     * defaults - fargate-defaults.ts
     */
    default @org.jetbrains.annotations.Nullable java.lang.Object getFargateServiceProps() {
        return null;
    }

    default @org.jetbrains.annotations.Nullable java.lang.Object getFargateTaskDefinitionProps() {
        return null;
    }

    /**
     * User provided props to override the default props for the CloudWatchLogs LogGroup.
     * <p>
     * Default: - Default props are used
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.LogGroupProps getLogGroupProps() {
        return null;
    }

    /**
     * Optional Name for the container environment variable set to the ARN of the state machine.
     * <p>
     * Default: - STATE_MACHINE_ARN
     */
    default @org.jetbrains.annotations.Nullable java.lang.String getStateMachineEnvironmentVariableName() {
        return null;
    }

    /**
     * Optional custom properties for a VPC the construct will create.
     * <p>
     * This VPC will
     * be used by the new Fargate service the construct creates (that's
     * why targetGroupProps can't include a VPC). Providing
     * both this and existingVpc is an error. A Step Functions Interface
     * endpoint will be included in this VPC.
     * <p>
     * Default: - A set of defaults from vpc-defaults.ts: DefaultPublicPrivateVpcProps() for public APIs
     * and DefaultIsolatedVpcProps() for private APIs.
     */
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.VpcProps getVpcProps() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FargateToStepfunctionsProps}
     */
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FargateToStepfunctionsProps}
     */
    public static final class Builder implements software.amazon.jsii.Builder<FargateToStepfunctionsProps> {
        java.lang.Boolean publicApi;
        software.amazon.awscdk.services.stepfunctions.StateMachineProps stateMachineProps;
        software.amazon.awscdk.services.ecs.ClusterProps clusterProps;
        java.lang.Object containerDefinitionProps;
        java.lang.Boolean createCloudWatchAlarms;
        java.lang.String ecrImageVersion;
        java.lang.String ecrRepositoryArn;
        software.amazon.awscdk.services.ecs.ContainerDefinition existingContainerDefinitionObject;
        software.amazon.awscdk.services.ecs.FargateService existingFargateServiceObject;
        software.amazon.awscdk.services.ec2.IVpc existingVpc;
        java.lang.Object fargateServiceProps;
        java.lang.Object fargateTaskDefinitionProps;
        software.amazon.awscdk.services.logs.LogGroupProps logGroupProps;
        java.lang.String stateMachineEnvironmentVariableName;
        software.amazon.awscdk.services.ec2.VpcProps vpcProps;

        /**
         * Sets the value of {@link FargateToStepfunctionsProps#getPublicApi}
         * @param publicApi Whether the construct is deploying a private or public API. This parameter is required.
         *                  This has implications for the VPC deployed
         *                  by this construct.
         * @return {@code this}
         */
        public Builder publicApi(java.lang.Boolean publicApi) {
            this.publicApi = publicApi;
            return this;
        }

        /**
         * Sets the value of {@link FargateToStepfunctionsProps#getStateMachineProps}
         * @param stateMachineProps User provided StateMachineProps to override the defaults. This parameter is required.
         * @return {@code this}
         */
        public Builder stateMachineProps(software.amazon.awscdk.services.stepfunctions.StateMachineProps stateMachineProps) {
            this.stateMachineProps = stateMachineProps;
            return this;
        }

        /**
         * Sets the value of {@link FargateToStepfunctionsProps#getClusterProps}
         * @param clusterProps Optional properties to create a new ECS cluster.
         * @return {@code this}
         */
        public Builder clusterProps(software.amazon.awscdk.services.ecs.ClusterProps clusterProps) {
            this.clusterProps = clusterProps;
            return this;
        }

        /**
         * Sets the value of {@link FargateToStepfunctionsProps#getContainerDefinitionProps}
         * @param containerDefinitionProps the value to be set.
         * @return {@code this}
         */
        public Builder containerDefinitionProps(java.lang.Object containerDefinitionProps) {
            this.containerDefinitionProps = containerDefinitionProps;
            return this;
        }

        /**
         * Sets the value of {@link FargateToStepfunctionsProps#getCreateCloudWatchAlarms}
         * @param createCloudWatchAlarms Whether to create recommended CloudWatch alarms.
         * @return {@code this}
         */
        public Builder createCloudWatchAlarms(java.lang.Boolean createCloudWatchAlarms) {
            this.createCloudWatchAlarms = createCloudWatchAlarms;
            return this;
        }

        /**
         * Sets the value of {@link FargateToStepfunctionsProps#getEcrImageVersion}
         * @param ecrImageVersion The version of the image to use from the repository.
         * @return {@code this}
         */
        public Builder ecrImageVersion(java.lang.String ecrImageVersion) {
            this.ecrImageVersion = ecrImageVersion;
            return this;
        }

        /**
         * Sets the value of {@link FargateToStepfunctionsProps#getEcrRepositoryArn}
         * @param ecrRepositoryArn The arn of an ECR Repository containing the image to use to generate the containers.
         *                         format:
         *                         arn:aws:ecr:[region]:[account number]:repository/[Repository Name]
         * @return {@code this}
         */
        public Builder ecrRepositoryArn(java.lang.String ecrRepositoryArn) {
            this.ecrRepositoryArn = ecrRepositoryArn;
            return this;
        }

        /**
         * Sets the value of {@link FargateToStepfunctionsProps#getExistingContainerDefinitionObject}
         * @param existingContainerDefinitionObject the value to be set.
         * @return {@code this}
         */
        public Builder existingContainerDefinitionObject(software.amazon.awscdk.services.ecs.ContainerDefinition existingContainerDefinitionObject) {
            this.existingContainerDefinitionObject = existingContainerDefinitionObject;
            return this;
        }

        /**
         * Sets the value of {@link FargateToStepfunctionsProps#getExistingFargateServiceObject}
         * @param existingFargateServiceObject A Fargate Service already instantiated (probably by another Solutions Construct).
         *                                     If
         *                                     this is specified, then no props defining a new service can be provided, including:
         *                                     existingImageObject, ecrImageVersion, containerDefinitionProps, fargateTaskDefinitionProps,
         *                                     ecrRepositoryArn, fargateServiceProps, clusterProps, existingClusterInterface. If this value
         *                                     is provided, then existingContainerDefinitionObject must be provided as well.
         * @return {@code this}
         */
        public Builder existingFargateServiceObject(software.amazon.awscdk.services.ecs.FargateService existingFargateServiceObject) {
            this.existingFargateServiceObject = existingFargateServiceObject;
            return this;
        }

        /**
         * Sets the value of {@link FargateToStepfunctionsProps#getExistingVpc}
         * @param existingVpc An existing VPC in which to deploy the construct.
         *                    Providing both this and
         *                    vpcProps is an error. If the client provides an existing Fargate service,
         *                    this value must be the VPC where the service is running. A Step Functions Interface
         *                    endpoint will be added to this VPC.
         * @return {@code this}
         */
        public Builder existingVpc(software.amazon.awscdk.services.ec2.IVpc existingVpc) {
            this.existingVpc = existingVpc;
            return this;
        }

        /**
         * Sets the value of {@link FargateToStepfunctionsProps#getFargateServiceProps}
         * @param fargateServiceProps Optional values to override default Fargate Task definition properties (fargate-defaults.ts). The construct will default to launching the service is the most isolated subnets available (precedence: Isolated, Private and Public). Override those and other defaults here.
         *                            defaults - fargate-defaults.ts
         * @return {@code this}
         */
        public Builder fargateServiceProps(java.lang.Object fargateServiceProps) {
            this.fargateServiceProps = fargateServiceProps;
            return this;
        }

        /**
         * Sets the value of {@link FargateToStepfunctionsProps#getFargateTaskDefinitionProps}
         * @param fargateTaskDefinitionProps the value to be set.
         * @return {@code this}
         */
        public Builder fargateTaskDefinitionProps(java.lang.Object fargateTaskDefinitionProps) {
            this.fargateTaskDefinitionProps = fargateTaskDefinitionProps;
            return this;
        }

        /**
         * Sets the value of {@link FargateToStepfunctionsProps#getLogGroupProps}
         * @param logGroupProps User provided props to override the default props for the CloudWatchLogs LogGroup.
         * @return {@code this}
         */
        public Builder logGroupProps(software.amazon.awscdk.services.logs.LogGroupProps logGroupProps) {
            this.logGroupProps = logGroupProps;
            return this;
        }

        /**
         * Sets the value of {@link FargateToStepfunctionsProps#getStateMachineEnvironmentVariableName}
         * @param stateMachineEnvironmentVariableName Optional Name for the container environment variable set to the ARN of the state machine.
         * @return {@code this}
         */
        public Builder stateMachineEnvironmentVariableName(java.lang.String stateMachineEnvironmentVariableName) {
            this.stateMachineEnvironmentVariableName = stateMachineEnvironmentVariableName;
            return this;
        }

        /**
         * Sets the value of {@link FargateToStepfunctionsProps#getVpcProps}
         * @param vpcProps Optional custom properties for a VPC the construct will create.
         *                 This VPC will
         *                 be used by the new Fargate service the construct creates (that's
         *                 why targetGroupProps can't include a VPC). Providing
         *                 both this and existingVpc is an error. A Step Functions Interface
         *                 endpoint will be included in this VPC.
         * @return {@code this}
         */
        public Builder vpcProps(software.amazon.awscdk.services.ec2.VpcProps vpcProps) {
            this.vpcProps = vpcProps;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FargateToStepfunctionsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @Override
        public FargateToStepfunctionsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FargateToStepfunctionsProps}
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FargateToStepfunctionsProps {
        private final java.lang.Boolean publicApi;
        private final software.amazon.awscdk.services.stepfunctions.StateMachineProps stateMachineProps;
        private final software.amazon.awscdk.services.ecs.ClusterProps clusterProps;
        private final java.lang.Object containerDefinitionProps;
        private final java.lang.Boolean createCloudWatchAlarms;
        private final java.lang.String ecrImageVersion;
        private final java.lang.String ecrRepositoryArn;
        private final software.amazon.awscdk.services.ecs.ContainerDefinition existingContainerDefinitionObject;
        private final software.amazon.awscdk.services.ecs.FargateService existingFargateServiceObject;
        private final software.amazon.awscdk.services.ec2.IVpc existingVpc;
        private final java.lang.Object fargateServiceProps;
        private final java.lang.Object fargateTaskDefinitionProps;
        private final software.amazon.awscdk.services.logs.LogGroupProps logGroupProps;
        private final java.lang.String stateMachineEnvironmentVariableName;
        private final software.amazon.awscdk.services.ec2.VpcProps vpcProps;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.publicApi = software.amazon.jsii.Kernel.get(this, "publicApi", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.stateMachineProps = software.amazon.jsii.Kernel.get(this, "stateMachineProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.StateMachineProps.class));
            this.clusterProps = software.amazon.jsii.Kernel.get(this, "clusterProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ClusterProps.class));
            this.containerDefinitionProps = software.amazon.jsii.Kernel.get(this, "containerDefinitionProps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.createCloudWatchAlarms = software.amazon.jsii.Kernel.get(this, "createCloudWatchAlarms", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ecrImageVersion = software.amazon.jsii.Kernel.get(this, "ecrImageVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ecrRepositoryArn = software.amazon.jsii.Kernel.get(this, "ecrRepositoryArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.existingContainerDefinitionObject = software.amazon.jsii.Kernel.get(this, "existingContainerDefinitionObject", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerDefinition.class));
            this.existingFargateServiceObject = software.amazon.jsii.Kernel.get(this, "existingFargateServiceObject", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FargateService.class));
            this.existingVpc = software.amazon.jsii.Kernel.get(this, "existingVpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.fargateServiceProps = software.amazon.jsii.Kernel.get(this, "fargateServiceProps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.fargateTaskDefinitionProps = software.amazon.jsii.Kernel.get(this, "fargateTaskDefinitionProps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.logGroupProps = software.amazon.jsii.Kernel.get(this, "logGroupProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.LogGroupProps.class));
            this.stateMachineEnvironmentVariableName = software.amazon.jsii.Kernel.get(this, "stateMachineEnvironmentVariableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcProps = software.amazon.jsii.Kernel.get(this, "vpcProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.VpcProps.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.publicApi = java.util.Objects.requireNonNull(builder.publicApi, "publicApi is required");
            this.stateMachineProps = java.util.Objects.requireNonNull(builder.stateMachineProps, "stateMachineProps is required");
            this.clusterProps = builder.clusterProps;
            this.containerDefinitionProps = builder.containerDefinitionProps;
            this.createCloudWatchAlarms = builder.createCloudWatchAlarms;
            this.ecrImageVersion = builder.ecrImageVersion;
            this.ecrRepositoryArn = builder.ecrRepositoryArn;
            this.existingContainerDefinitionObject = builder.existingContainerDefinitionObject;
            this.existingFargateServiceObject = builder.existingFargateServiceObject;
            this.existingVpc = builder.existingVpc;
            this.fargateServiceProps = builder.fargateServiceProps;
            this.fargateTaskDefinitionProps = builder.fargateTaskDefinitionProps;
            this.logGroupProps = builder.logGroupProps;
            this.stateMachineEnvironmentVariableName = builder.stateMachineEnvironmentVariableName;
            this.vpcProps = builder.vpcProps;
        }

        @Override
        public final java.lang.Boolean getPublicApi() {
            return this.publicApi;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.StateMachineProps getStateMachineProps() {
            return this.stateMachineProps;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ClusterProps getClusterProps() {
            return this.clusterProps;
        }

        @Override
        public final java.lang.Object getContainerDefinitionProps() {
            return this.containerDefinitionProps;
        }

        @Override
        public final java.lang.Boolean getCreateCloudWatchAlarms() {
            return this.createCloudWatchAlarms;
        }

        @Override
        public final java.lang.String getEcrImageVersion() {
            return this.ecrImageVersion;
        }

        @Override
        public final java.lang.String getEcrRepositoryArn() {
            return this.ecrRepositoryArn;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ContainerDefinition getExistingContainerDefinitionObject() {
            return this.existingContainerDefinitionObject;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.FargateService getExistingFargateServiceObject() {
            return this.existingFargateServiceObject;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getExistingVpc() {
            return this.existingVpc;
        }

        @Override
        public final java.lang.Object getFargateServiceProps() {
            return this.fargateServiceProps;
        }

        @Override
        public final java.lang.Object getFargateTaskDefinitionProps() {
            return this.fargateTaskDefinitionProps;
        }

        @Override
        public final software.amazon.awscdk.services.logs.LogGroupProps getLogGroupProps() {
            return this.logGroupProps;
        }

        @Override
        public final java.lang.String getStateMachineEnvironmentVariableName() {
            return this.stateMachineEnvironmentVariableName;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.VpcProps getVpcProps() {
            return this.vpcProps;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("publicApi", om.valueToTree(this.getPublicApi()));
            data.set("stateMachineProps", om.valueToTree(this.getStateMachineProps()));
            if (this.getClusterProps() != null) {
                data.set("clusterProps", om.valueToTree(this.getClusterProps()));
            }
            if (this.getContainerDefinitionProps() != null) {
                data.set("containerDefinitionProps", om.valueToTree(this.getContainerDefinitionProps()));
            }
            if (this.getCreateCloudWatchAlarms() != null) {
                data.set("createCloudWatchAlarms", om.valueToTree(this.getCreateCloudWatchAlarms()));
            }
            if (this.getEcrImageVersion() != null) {
                data.set("ecrImageVersion", om.valueToTree(this.getEcrImageVersion()));
            }
            if (this.getEcrRepositoryArn() != null) {
                data.set("ecrRepositoryArn", om.valueToTree(this.getEcrRepositoryArn()));
            }
            if (this.getExistingContainerDefinitionObject() != null) {
                data.set("existingContainerDefinitionObject", om.valueToTree(this.getExistingContainerDefinitionObject()));
            }
            if (this.getExistingFargateServiceObject() != null) {
                data.set("existingFargateServiceObject", om.valueToTree(this.getExistingFargateServiceObject()));
            }
            if (this.getExistingVpc() != null) {
                data.set("existingVpc", om.valueToTree(this.getExistingVpc()));
            }
            if (this.getFargateServiceProps() != null) {
                data.set("fargateServiceProps", om.valueToTree(this.getFargateServiceProps()));
            }
            if (this.getFargateTaskDefinitionProps() != null) {
                data.set("fargateTaskDefinitionProps", om.valueToTree(this.getFargateTaskDefinitionProps()));
            }
            if (this.getLogGroupProps() != null) {
                data.set("logGroupProps", om.valueToTree(this.getLogGroupProps()));
            }
            if (this.getStateMachineEnvironmentVariableName() != null) {
                data.set("stateMachineEnvironmentVariableName", om.valueToTree(this.getStateMachineEnvironmentVariableName()));
            }
            if (this.getVpcProps() != null) {
                data.set("vpcProps", om.valueToTree(this.getVpcProps()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-solutions-constructs/aws-fargate-stepfunctions.FargateToStepfunctionsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FargateToStepfunctionsProps.Jsii$Proxy that = (FargateToStepfunctionsProps.Jsii$Proxy) o;

            if (!publicApi.equals(that.publicApi)) return false;
            if (!stateMachineProps.equals(that.stateMachineProps)) return false;
            if (this.clusterProps != null ? !this.clusterProps.equals(that.clusterProps) : that.clusterProps != null) return false;
            if (this.containerDefinitionProps != null ? !this.containerDefinitionProps.equals(that.containerDefinitionProps) : that.containerDefinitionProps != null) return false;
            if (this.createCloudWatchAlarms != null ? !this.createCloudWatchAlarms.equals(that.createCloudWatchAlarms) : that.createCloudWatchAlarms != null) return false;
            if (this.ecrImageVersion != null ? !this.ecrImageVersion.equals(that.ecrImageVersion) : that.ecrImageVersion != null) return false;
            if (this.ecrRepositoryArn != null ? !this.ecrRepositoryArn.equals(that.ecrRepositoryArn) : that.ecrRepositoryArn != null) return false;
            if (this.existingContainerDefinitionObject != null ? !this.existingContainerDefinitionObject.equals(that.existingContainerDefinitionObject) : that.existingContainerDefinitionObject != null) return false;
            if (this.existingFargateServiceObject != null ? !this.existingFargateServiceObject.equals(that.existingFargateServiceObject) : that.existingFargateServiceObject != null) return false;
            if (this.existingVpc != null ? !this.existingVpc.equals(that.existingVpc) : that.existingVpc != null) return false;
            if (this.fargateServiceProps != null ? !this.fargateServiceProps.equals(that.fargateServiceProps) : that.fargateServiceProps != null) return false;
            if (this.fargateTaskDefinitionProps != null ? !this.fargateTaskDefinitionProps.equals(that.fargateTaskDefinitionProps) : that.fargateTaskDefinitionProps != null) return false;
            if (this.logGroupProps != null ? !this.logGroupProps.equals(that.logGroupProps) : that.logGroupProps != null) return false;
            if (this.stateMachineEnvironmentVariableName != null ? !this.stateMachineEnvironmentVariableName.equals(that.stateMachineEnvironmentVariableName) : that.stateMachineEnvironmentVariableName != null) return false;
            return this.vpcProps != null ? this.vpcProps.equals(that.vpcProps) : that.vpcProps == null;
        }

        @Override
        public final int hashCode() {
            int result = this.publicApi.hashCode();
            result = 31 * result + (this.stateMachineProps.hashCode());
            result = 31 * result + (this.clusterProps != null ? this.clusterProps.hashCode() : 0);
            result = 31 * result + (this.containerDefinitionProps != null ? this.containerDefinitionProps.hashCode() : 0);
            result = 31 * result + (this.createCloudWatchAlarms != null ? this.createCloudWatchAlarms.hashCode() : 0);
            result = 31 * result + (this.ecrImageVersion != null ? this.ecrImageVersion.hashCode() : 0);
            result = 31 * result + (this.ecrRepositoryArn != null ? this.ecrRepositoryArn.hashCode() : 0);
            result = 31 * result + (this.existingContainerDefinitionObject != null ? this.existingContainerDefinitionObject.hashCode() : 0);
            result = 31 * result + (this.existingFargateServiceObject != null ? this.existingFargateServiceObject.hashCode() : 0);
            result = 31 * result + (this.existingVpc != null ? this.existingVpc.hashCode() : 0);
            result = 31 * result + (this.fargateServiceProps != null ? this.fargateServiceProps.hashCode() : 0);
            result = 31 * result + (this.fargateTaskDefinitionProps != null ? this.fargateTaskDefinitionProps.hashCode() : 0);
            result = 31 * result + (this.logGroupProps != null ? this.logGroupProps.hashCode() : 0);
            result = 31 * result + (this.stateMachineEnvironmentVariableName != null ? this.stateMachineEnvironmentVariableName.hashCode() : 0);
            result = 31 * result + (this.vpcProps != null ? this.vpcProps.hashCode() : 0);
            return result;
        }
    }
}
